/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class DeleteBaselineAction
extends ActionDialog {
    private static final String BASELINE_NAME = "BaselineName";
    private static final String PURGE = "Purge";

    protected String getTitle() {
        return DbaNavigatorResources.getString("DELETE_BASELINE_TITLE");
    }

    protected String getObjectName() {
        return super.getObjectName().split("/")[0];
    }

    protected String getDbId() {
        return super.getObjectName().split("/")[1];
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(BASELINE_NAME, DbaNavigatorResources.getString("BASELINE_NAME_LABEL"), this.getObjectName());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(PURGE, DbaNavigatorResources.getString("PURGE_UNDERLYING_DATA_LABEL"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN\n");
        stringBuilder.append("   DBMS_WORKLOAD_REPOSITORY.DROP_BASELINE('");
        stringBuilder.append(this.getObjectName());
        stringBuilder.append("', ");
        stringBuilder.append(Boolean.parseBoolean(values.get(PURGE)) ? "TRUE" : "FALSE");
        stringBuilder.append(", ");
        stringBuilder.append(this.getDbId());
        stringBuilder.append(");\n");
        stringBuilder.append("END;\n");
        return stringBuilder.toString();
    }
}

