/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class StorageSizeControl
extends ActionControl {
    public static final String UNLIMITED = "Unlimited";
    public static final String SIZE = "Size";
    public static final String UNIT = "Unit";
    public static final String BYTES = "Bytes";
    public static final String SIZE_CLAUSE = "SizeClause";
    private JCheckBox _unlimited = new JCheckBox(DbaNavigatorResources.getString("UNLIMITED_STORAGE"));
    private JSpinner _spinner;
    private JComboBox _units;
    private JPanel _panel;

    public StorageSizeControl(String string, String string2) {
        super(string, string2);
        this._unlimited.setHorizontalTextPosition(10);
        this._spinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this._units = new JComboBox<Object>(new Object[]{"B", "KB", "MB", "GB", "TB"});
        this.reset();
        this.enableControls();
        this._unlimited.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                StorageSizeControl.this.enableControls();
                StorageSizeControl.this.firePropertyChangeListeners();
            }
        });
        this._spinner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                StorageSizeControl.this.firePropertyChangeListeners();
            }
        });
        this._units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StorageSizeControl.this.firePropertyChangeListeners();
            }
        });
        this._unlimited.setName(string + "_Unlimited");
        this._spinner.setName(string + "_Size");
        this._units.setName(string + "_Unit");
        this._panel = new JPanel(new GridBagLayout());
        this._panel.add((Component)this._unlimited, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this._panel.add((Component)this._spinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        this._panel.add((Component)this._units, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public ActionControl.Value getValue() {
        boolean bl = this._unlimited.isSelected();
        Long l = ((Number)this._spinner.getValue()).longValue();
        String string = l.toString();
        String string2 = this._units.getSelectedItem().toString();
        long l2 = 0L;
        Object object = null;
        if (string2.equals("B")) {
            l2 = l;
            object = string;
        } else if (string2.equals("KB")) {
            l2 = l * 1024L;
            object = string + "K";
        } else if (string2.equals("MB")) {
            l2 = l * 0x100000L;
            object = string + "M";
        } else if (string2.equals("GB")) {
            l2 = l * 0x40000000L;
            object = string + "G";
        } else {
            l2 = l * 0x10000000000L;
            object = string + "T";
        }
        ActionControl.Value value = new ActionControl.Value();
        value.add(UNLIMITED, Boolean.toString(bl));
        value.add(SIZE, string);
        value.add(UNIT, string2);
        value.add(BYTES, Long.toString(l2));
        value.add(SIZE_CLAUSE, (String)object);
        return value;
    }

    private void enableControls() {
        boolean bl = this._unlimited.isSelected();
        this._spinner.setEnabled(!bl);
        this._units.setEnabled(!bl);
    }

    public Component getUI() {
        return this._panel;
    }

    public void reset() {
        this._unlimited.setSelected(true);
        this._spinner.setValue(0);
        this._units.setSelectedItem("KB");
    }

    public void enableUI(boolean bl) {
        this._unlimited.setEnabled(bl);
        boolean bl2 = this._unlimited.isSelected();
        this._spinner.setEnabled(!bl2 && bl);
        this._units.setEnabled(!bl2 && bl);
    }

    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }
}

