/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.StorageSizeControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;

public class PdbStorageControl
extends PropertyPanelActionControl {
    private static final String UNLIMITED_STORAGE = "UNLIMITED_STORAGE";
    private static final String TEMPFILE_REUSE = "TEMPFILE_REUSE";
    private static final String TOTAL_SIZE = "TOTAL_SIZE";
    private static final String TEMP_TABLESPACE_USAGE = "TEMP_TABLESPACE_USAGE";
    private BooleanCheckBoxActionControl unlimitedStorageCtl;
    private BooleanCheckBoxActionControl reuseTempCtl;
    private StorageSizeControl totalSizeCtl;
    private StorageSizeControl tempTablespaceUsageCtl;

    public PdbStorageControl(String string, String string2) {
        super(string, string2);
        this.getUI().setBorder(BorderFactory.createTitledBorder((String)null));
        this.addChildControls(this.createControlList());
    }

    public static String getStorageClause(String string, ActionValuesLookup actionValuesLookup, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(actionValuesLookup.get(string, UNLIMITED_STORAGE));
        boolean bl2 = Boolean.parseBoolean(actionValuesLookup.get(string, "TOTAL_SIZE/Unlimited"));
        boolean bl3 = Boolean.parseBoolean(actionValuesLookup.get(string, TEMPFILE_REUSE));
        String string3 = actionValuesLookup.get(string, "TOTAL_SIZE/SizeClause");
        boolean bl4 = Boolean.parseBoolean(actionValuesLookup.get(string, "TEMP_TABLESPACE_USAGE/Unlimited"));
        String string4 = actionValuesLookup.get(string, "TEMP_TABLESPACE_USAGE/SizeClause");
        stringBuffer.append("\n" + string2);
        if (bl) {
            stringBuffer.append("  STORAGE UNLIMITED");
        } else {
            stringBuffer.append("  STORAGE (");
            stringBuffer.append("\n" + string2);
            if (bl2) {
                stringBuffer.append("    MAXSIZE UNLIMITED");
                stringBuffer.append("\n" + string2);
            } else if (!string3.equals("0K")) {
                stringBuffer.append("    MAXSIZE " + string3);
                stringBuffer.append("\n" + string2);
            }
            if (bl4) {
                stringBuffer.append("    MAX_SHARED_TEMP_SIZE UNLIMITED");
                stringBuffer.append("\n" + string2);
            } else if (!string4.equals("0K")) {
                stringBuffer.append("    MAX_SHARED_TEMP_SIZE " + string4);
                stringBuffer.append("\n" + string2);
            }
            stringBuffer.append("  )");
        }
        if (bl3) {
            if (bl) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append("\n" + string2 + "  ");
            }
            stringBuffer.append("TEMPFILE REUSE");
        }
        return stringBuffer.toString();
    }

    private List<ActionControl> createControlList() {
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        this.unlimitedStorageCtl = new BooleanCheckBoxActionControl(UNLIMITED_STORAGE, DbaNavigatorResources.getString(UNLIMITED_STORAGE), true);
        this.reuseTempCtl = new BooleanCheckBoxActionControl(TEMPFILE_REUSE, DbaNavigatorResources.getString(TEMPFILE_REUSE), true);
        this.totalSizeCtl = new StorageSizeControl(TOTAL_SIZE, DbaNavigatorResources.getString(TOTAL_SIZE));
        this.tempTablespaceUsageCtl = new StorageSizeControl(TEMP_TABLESPACE_USAGE, DbaNavigatorResources.getString(TEMP_TABLESPACE_USAGE));
        this.enableControls();
        this.unlimitedStorageCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PdbStorageControl.this.enableControls();
            }
        });
        arrayList.add((ActionControl)this.unlimitedStorageCtl);
        arrayList.add((ActionControl)this.reuseTempCtl);
        arrayList.add(this.totalSizeCtl);
        arrayList.add(this.tempTablespaceUsageCtl);
        return arrayList;
    }

    private void enableControls() {
        boolean bl = Boolean.parseBoolean(this.unlimitedStorageCtl.getValue().get());
        this.unlimitedStorageCtl.enableUI(true);
        this.totalSizeCtl.enableUI(!bl);
        this.tempTablespaceUsageCtl.enableUI(!bl);
    }
}

