/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ContainerActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;

public class FileNameConvertControl
extends CardLayoutActionControl {
    private TableActionControl fileNameConvertTable = (TableActionControl)this.findActionControl("FileNames", this.getChildControls());
    private static final String FILE_NAMES = "FileNames";
    private static final String FILE_EXPRESSIONS = "FileExpressions";
    private static final String SOURCE_FILE_NAMES = DbaNavigatorResources.getString("SOURCE_FILE_NAMES");
    private static final String TARGET_FILE_NAMES = DbaNavigatorResources.getString("TARGET_FILE_NAMES");
    private static final String SOURCE_FILE_EXPRESSIONS = DbaNavigatorResources.getString("SOURCE_FILE_EXPRESSIONS");
    private static final String TARGET_FILE_EXPRESSIONS = DbaNavigatorResources.getString("TARGET_FILE_EXPRESSIONS");

    public FileNameConvertControl(String string, String string2, Connection connection, boolean bl, String string3) {
        this(string, string2, connection, null, bl, string3);
    }

    public FileNameConvertControl(String string, String string2, Connection connection, String string3, boolean bl, String string4) {
        super(string, string2, CardLayoutPanel.Type.TITLE_BORDER, FileNameConvertControl.createControlMap(connection, string3, bl, string4));
    }

    public static String getFileNameConvertClause(String string, ActionValuesLookup actionValuesLookup, boolean bl, boolean bl2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        List list2 = null;
        String string3 = actionValuesLookup.get(string);
        if (string3.equals(FileNameConvertTypes.NAME_LIST.toString())) {
            list = actionValuesLookup.getList(string, "FileNames/" + SOURCE_FILE_NAMES);
            list2 = actionValuesLookup.getList(string, "FileNames/" + TARGET_FILE_NAMES);
        } else if (string3.equals(FileNameConvertTypes.EXPRESSION_LIST.toString())) {
            list = actionValuesLookup.getList(string, "FileExpressions/" + SOURCE_FILE_EXPRESSIONS);
            list2 = actionValuesLookup.getList(string, "FileExpressions/" + TARGET_FILE_EXPRESSIONS);
        }
        stringBuffer.append("\n" + string2);
        if (bl) {
            stringBuffer.append("  SOURCE_FILE_NAME_CONVERT=");
        } else {
            stringBuffer.append("  FILE_NAME_CONVERT=");
        }
        if (list != null && list2 != null) {
            stringBuffer.append("(\n" + string2);
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                    stringBuffer.append("\n" + string2);
                }
                if (bl2) {
                    stringBuffer.append("    ''");
                } else {
                    stringBuffer.append("    '");
                }
                stringBuffer.append((String)list.get(i));
                if (bl2) {
                    stringBuffer.append("'', ''");
                } else {
                    stringBuffer.append("', '");
                }
                stringBuffer.append((String)list2.get(i));
                if (bl2) {
                    stringBuffer.append("''");
                    continue;
                }
                stringBuffer.append("'");
            }
            stringBuffer.append("\n" + string2);
            stringBuffer.append("  )");
        } else {
            stringBuffer.append("NONE");
        }
        return stringBuffer.toString();
    }

    public void resetSourcePdbName(Connection connection, String string, String string2) {
        String string3 = null;
        string3 = string.equals("PDB$SEED") ? "PDBSEED" : string;
        List<String> list = FileNameConvertControl.sourceFileNames(connection, string);
        ArrayList<1> arrayList = new ArrayList<1>();
        for (String string4 : list) {
            String string5 = FileNameConvertControl.fabricateNewPath(string4, string3, string2);
            arrayList.add(new FileRow(string4, string5){

                public boolean isValueEditable(int n) {
                    return n == 1;
                }
            });
        }
        this.fileNameConvertTable.setRows(arrayList);
    }

    private ActionControl findActionControl(String string, List<ActionControl> list) {
        ActionControl actionControl = null;
        for (ActionControl actionControl2 : list) {
            if (string.equals(actionControl2.getName())) {
                actionControl = actionControl2;
            } else if (actionControl2 instanceof ContainerActionControl) {
                ContainerActionControl containerActionControl = (ContainerActionControl)actionControl2;
                actionControl = this.findActionControl(string, containerActionControl.getChildControls());
            }
            if (actionControl == null) continue;
            break;
        }
        return actionControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> sourceFileNames(Connection connection, String string) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", string);
                    resultSet = dBUtil.executeOracleQuery(Utils.getQuery(FileNameConvertControl.class, (Connection)connection, (String)"getSeedFiles"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString(1));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(FileNameConvertControl.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    private static Map<?, ActionControl> createControlMap(Connection connection, String string, boolean bl, String string2) {
        PropertyPanelActionControl propertyPanelActionControl;
        ArrayList<Object> arrayList;
        if (string == null) {
            string = "PDB$SEED";
        }
        List<String> list = FileNameConvertControl.sourceFileNames(connection, string);
        EnumMap<FileNameConvertTypes, PropertyPanelActionControl> enumMap = new EnumMap<FileNameConvertTypes, PropertyPanelActionControl>(FileNameConvertTypes.class);
        if (bl) {
            arrayList = new ArrayList<Object>();
            arrayList.add(new LabelActionControl(null, DbaNavigatorResources.getString("FILE_NAME_CONVERT_NONE_DESC")));
            propertyPanelActionControl = new PropertyPanelActionControl(arrayList);
            enumMap.put(FileNameConvertTypes.NONE, propertyPanelActionControl);
        }
        arrayList = new ArrayList();
        arrayList.add(FileNameConvertControl.createFileNameConvertNameListTable(list, string, string2));
        propertyPanelActionControl = new PropertyPanelActionControl(arrayList);
        enumMap.put(FileNameConvertTypes.NAME_LIST, propertyPanelActionControl);
        ArrayList<TableActionControl> arrayList2 = new ArrayList<TableActionControl>();
        arrayList2.add(FileNameConvertControl.createFileNameConvertExpressionListTable());
        PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl(arrayList2);
        enumMap.put(FileNameConvertTypes.EXPRESSION_LIST, propertyPanelActionControl2);
        return enumMap;
    }

    private static TableActionControl createFileNameConvertNameListTable(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SOURCE_FILE_NAMES);
        arrayList.add(TARGET_FILE_NAMES);
        String string3 = null;
        string3 = string.equals("PDB$SEED") ? "PDBSEED" : string;
        ArrayList<2> arrayList2 = new ArrayList<2>();
        for (String string4 : list) {
            String string5 = FileNameConvertControl.fabricateNewPath(string4, string3, string2);
            arrayList2.add(new FileRow(string4, string5){

                public boolean isValueEditable(int n) {
                    return n == 1;
                }
            });
        }
        return new TableActionControl(FILE_NAMES, null, arrayList, arrayList2, 4);
    }

    private static String fabricateNewPath(String string, String string2, String string3) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Path path = Paths.get(string, new String[0]);
        String string4 = string.contains("/") ? "/" : "\\";
        String string5 = File.separator;
        boolean bl = false;
        do {
            if (((String)(object = path.getFileName().toString())).equalsIgnoreCase(string2)) {
                stringBuilder.insert(0, string3);
                bl = true;
            } else {
                stringBuilder.insert(0, (String)object);
            }
            stringBuilder.insert(0, string4);
        } while ((path = path.getParent()).getParent() != null);
        if (path.getRoot() != null) {
            stringBuilder.insert(0, path.getRoot().toString().replace(string5, ""));
        }
        if (bl) {
            object = stringBuilder.toString();
        } else {
            String string6 = string.substring(0, string.lastIndexOf(".") - 1);
            String string7 = string.substring(string.lastIndexOf("."), string.length());
            object = string6 + "-" + string3 + string7;
        }
        return object;
    }

    private static TableActionControl createFileNameConvertExpressionListTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SOURCE_FILE_EXPRESSIONS);
        arrayList.add(TARGET_FILE_EXPRESSIONS);
        ArrayList arrayList2 = new ArrayList();
        return new TableActionControl(FILE_EXPRESSIONS, null, (TableActionControl.RowFactory)new FileRowFactory(), arrayList, arrayList2, 4);
    }

    private static enum FileNameConvertTypes {
        NONE(DbaNavigatorResources.getString("FILE_NAME_CONVERT_NONE")),
        NAME_LIST(DbaNavigatorResources.getString("FILE_NAME_CONVERT_NAME_LIST")),
        EXPRESSION_LIST(DbaNavigatorResources.getString("FILE_NAME_CONVERT_EXPRESSION_LIST"));

        private String _display;

        private FileNameConvertTypes(String string2) {
            this._display = string2;
        }

        public String toString() {
            return this._display;
        }
    }

    private static class FileRowFactory
    implements TableActionControl.RowFactory {
        private FileRowFactory() {
        }

        public TableActionControl.Row createRow(int n, TableActionControl.Row row) {
            return new FileRow(DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT")){

                public boolean isValueEditable(int n) {
                    return true;
                }
            };
        }
    }

    private static abstract class FileRow
    implements TableActionControl.Row {
        private String[] _cols = new String[2];

        FileRow(String string, String string2) {
            this._cols[0] = string;
            this._cols[1] = string2;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }
}

