/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SwitchFlashbackDatabaseAction
extends ActionDialog {
    private static final String FLASHBACK_ON = "FLASHBACK_ON";

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(this);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("SWITCH_FLASHBACK_DATABASE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        Object object;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object = null;
                try {
                    cloneable = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getFlashbackOn"), (Map)((Object)cloneable));
                    if (object == null) break block6;
                    while (object.next()) {
                        bl = !object.getString(FLASHBACK_ON).equals("NO");
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        object = new BooleanCheckBoxActionControl(FLASHBACK_ON, DbaNavigatorResources.getString("ENABLE_FLASHBACK_DATABASE_LABEL"), bl);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        ((ArrayList)cloneable).add(new SeperatorActionControl());
        ((ArrayList)cloneable).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", false));
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(FLASHBACK_ON));
        String string = RMANScriptProcessorActionControl.getJobName((ActionDialog.Lookup)values);
        stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
        stringBuffer.append("STARTUP MOUNT;\n");
        stringBuffer.append("SQL \"ALTER DATABASE FLASHBACK ");
        if (bl) {
            stringBuffer.append("ON");
        } else {
            stringBuffer.append("OFF");
        }
        stringBuffer.append("\";\n");
        stringBuffer.append("ALTER DATABASE OPEN;\n");
        return stringBuffer.toString();
    }
}

