/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditRetentionPoliciesAction
extends ActionDialog {
    private static final String RETENTION_POLICY = "RETENTION_POLICY";
    private static final String RECOVERY_WINDOW_DAYS = "RECOVERY_WINDOW_DAYS";
    private static final String REDUNDANCY_COUNT = "REDUNDANCY_COUNT";
    private static final String RETAIN_ALL = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_ALL");
    private static final String RETAIN_FOR_WINDOW = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_FOR_WINDOW");
    private static final String RETAIN_REDUNDANT = DbaNavigatorResources.getString("RETENTION_POLICY_RETAIN_REDUNDANT");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_RETENTION_POLICIES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        ResultSet resultSet;
        int n;
        int n2;
        String string;
        block8: {
            string = null;
            n2 = 0;
            n = 0;
            if (Connections.getInstance().lock(connection)) {
                resultSet = null;
                try {
                    textBoxActionControl = new HashMap();
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getRetentionPolicies"), textBoxActionControl);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            string = resultSet.getString(RETENTION_POLICY);
                            n2 = resultSet.getInt(RECOVERY_WINDOW_DAYS);
                            n = resultSet.getInt(REDUNDANCY_COUNT);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSet = new ComboBoxActionControl(RETENTION_POLICY, DbaNavigatorResources.getString("RETENTION_POLICY_LABEL"), new String[]{RETAIN_ALL, RETAIN_FOR_WINDOW, RETAIN_REDUNDANT}, string);
        textBoxActionControl = new TextBoxActionControl(RECOVERY_WINDOW_DAYS, DbaNavigatorResources.getString("RECOVERY_WINDOW_DAYS_LABEL"), Integer.toString(n2), TextBoxActionControl.getIntegerFormat());
        dBUtil = new TextBoxActionControl(REDUNDANCY_COUNT, DbaNavigatorResources.getString("REDUNDANCY_COUNT_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        this.onChangePolicy((ActionControl)resultSet, (ActionControl)textBoxActionControl, (ActionControl)dBUtil);
        resultSet.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$retentionPolicyCtl;
            final /* synthetic */ ActionControl val$recoveryWindowDaysCtl;
            final /* synthetic */ ActionControl val$redundancyCountCtl;
            {
                this.val$retentionPolicyCtl = actionControl;
                this.val$recoveryWindowDaysCtl = actionControl2;
                this.val$redundancyCountCtl = actionControl3;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditRetentionPoliciesAction.this.onChangePolicy(this.val$retentionPolicyCtl, this.val$recoveryWindowDaysCtl, this.val$redundancyCountCtl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)resultSet);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return arrayList;
    }

    private void onChangePolicy(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3) {
        String string = actionControl.getValue().get();
        if (string.equals(RETAIN_ALL)) {
            actionControl2.enableUI(false);
            actionControl3.enableUI(false);
        } else if (string.equals(RETAIN_FOR_WINDOW)) {
            actionControl2.enableUI(true);
            actionControl3.enableUI(false);
        } else if (string.equals(RETAIN_REDUNDANT)) {
            actionControl2.enableUI(false);
            actionControl3.enableUI(true);
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = values.get(RETENTION_POLICY);
        int n = Integer.parseInt(values.get(RECOVERY_WINDOW_DAYS));
        int n2 = Integer.parseInt(values.get(REDUNDANCY_COUNT));
        stringBuffer.append("CONFIGURE RETENTION POLICY TO ");
        if (string.equals(RETAIN_ALL)) {
            stringBuffer.append("NONE");
        } else if (string.equals(RETAIN_FOR_WINDOW)) {
            stringBuffer.append("RECOVERY WINDOW OF ");
            stringBuffer.append(n);
            stringBuffer.append(" DAYS");
        } else if (string.equals(RETAIN_REDUNDANT)) {
            stringBuffer.append("REDUNDANCY ");
            stringBuffer.append(n2);
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

