/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.view.View;
import oracle.ideimpl.vcscore.VersioningRegistrations;
import oracle.ideimpl.vcscore.nav.ConnectionProvider;
import oracle.ideimpl.vcscore.nav.ConnectionProviderClosure;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

public class VersioningConnectController
implements Controller {
    public static final String VCS_ACTION_PROPERTY = "VCS";

    public boolean handleEvent(IdeAction action, Context context) {
        String extensionId = (String)action.getValue(VCS_ACTION_PROPERTY);
        if (extensionId != null) {
            try {
                VersioningRegistrations.getInstance().lookup(extensionId).getConnectionProviderClass().toClass();
                ConnectionProviderClosure closure = new ConnectionProviderClosure(extensionId){

                    @Override
                    protected final void runImpl(final ConnectionProvider provider) {
                        if (provider.isConnected()) {
                            return;
                        }
                        View activeView = Ide.getMainWindow().getLastActiveView();
                        final Context context = activeView != null ? activeView.getContext(null) : Context.newIdeContext();
                        try {
                            new SwingClosure(true){

                                protected void runImpl() {
                                    provider.runConnect(context);
                                }
                            }.run();
                        }
                        catch (ClosureException ce) {
                            FeedbackManager.reportException((Throwable)ce);
                        }
                    }
                };
                closure.run();
            }
            catch (ClassNotFoundException cnfe) {
                FeedbackManager.reportException((Throwable)cnfe);
            }
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }
}

