/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import oracle.security.xmlsec.liberty.v11.AuthnContext;
import oracle.security.xmlsec.liberty.v11.AuthnRequest;
import oracle.security.xmlsec.liberty.v11.AuthnRequestEnvelope;
import oracle.security.xmlsec.liberty.v11.AuthnResponse;
import oracle.security.xmlsec.liberty.v11.AuthnResponseEnvelope;
import oracle.security.xmlsec.liberty.v11.FederationTerminationNotification;
import oracle.security.xmlsec.liberty.v11.IDPDescriptor;
import oracle.security.xmlsec.liberty.v11.IDPEntries;
import oracle.security.xmlsec.liberty.v11.IDPEntry;
import oracle.security.xmlsec.liberty.v11.IDPList;
import oracle.security.xmlsec.liberty.v11.IDPProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v11.LibAssertion;
import oracle.security.xmlsec.liberty.v11.LibAuthenticationStatement;
import oracle.security.xmlsec.liberty.v11.LibSAMLRequest;
import oracle.security.xmlsec.liberty.v11.LibSubject;
import oracle.security.xmlsec.liberty.v11.LogoutRequest;
import oracle.security.xmlsec.liberty.v11.LogoutResponse;
import oracle.security.xmlsec.liberty.v11.OldProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v11.RegisterNameIdentifierRequest;
import oracle.security.xmlsec.liberty.v11.RegisterNameIdentifierResponse;
import oracle.security.xmlsec.liberty.v11.SPDescriptor;
import oracle.security.xmlsec.liberty.v11.SPProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationMethod;
import oracle.security.xmlsec.liberty.v11.ac.Authenticator;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticatorTransportProtocol;
import oracle.security.xmlsec.liberty.v11.ac.DeactivationCallCenter;
import oracle.security.xmlsec.liberty.v11.ac.DigSig;
import oracle.security.xmlsec.liberty.v11.ac.Generation;
import oracle.security.xmlsec.liberty.v11.ac.GoverningAgreementRef;
import oracle.security.xmlsec.liberty.v11.ac.GoverningAgreements;
import oracle.security.xmlsec.liberty.v11.ac.HTTP;
import oracle.security.xmlsec.liberty.v11.ac.IPSec;
import oracle.security.xmlsec.liberty.v11.ac.Identification;
import oracle.security.xmlsec.liberty.v11.ac.KeyActivation;
import oracle.security.xmlsec.liberty.v11.ac.KeyStorage;
import oracle.security.xmlsec.liberty.v11.ac.Length;
import oracle.security.xmlsec.liberty.v11.ac.MobileAuthCard;
import oracle.security.xmlsec.liberty.v11.ac.MobileContractClass;
import oracle.security.xmlsec.liberty.v11.ac.MobileDevice;
import oracle.security.xmlsec.liberty.v11.ac.MobileDigitalIDClass;
import oracle.security.xmlsec.liberty.v11.ac.MobileNetwork;
import oracle.security.xmlsec.liberty.v11.ac.MobileUnregisteredClass;
import oracle.security.xmlsec.liberty.v11.ac.OperationalProtection;
import oracle.security.xmlsec.liberty.v11.ac.Password;
import oracle.security.xmlsec.liberty.v11.ac.PasswordClass;
import oracle.security.xmlsec.liberty.v11.ac.PasswordProtectedTransportClass;
import oracle.security.xmlsec.liberty.v11.ac.PhysicalVerification;
import oracle.security.xmlsec.liberty.v11.ac.PreviousSession;
import oracle.security.xmlsec.liberty.v11.ac.PreviousSessionClass;
import oracle.security.xmlsec.liberty.v11.ac.PrincipalAuthenticationMechanism;
import oracle.security.xmlsec.liberty.v11.ac.PrivateKeyProtection;
import oracle.security.xmlsec.liberty.v11.ac.SSL;
import oracle.security.xmlsec.liberty.v11.ac.SecurityAudit;
import oracle.security.xmlsec.liberty.v11.ac.SharedKeyProtection;
import oracle.security.xmlsec.liberty.v11.ac.SharedSecretChallengeResponse;
import oracle.security.xmlsec.liberty.v11.ac.Smartcard;
import oracle.security.xmlsec.liberty.v11.ac.SmartcardClass;
import oracle.security.xmlsec.liberty.v11.ac.SmartcardPKIClass;
import oracle.security.xmlsec.liberty.v11.ac.SoftwarePKIClass;
import oracle.security.xmlsec.liberty.v11.ac.SwitchAudit;
import oracle.security.xmlsec.liberty.v11.ac.TechnicalProtection;
import oracle.security.xmlsec.liberty.v11.ac.TimeSyncToken;
import oracle.security.xmlsec.liberty.v11.ac.TimeSyncTokenClass;
import oracle.security.xmlsec.liberty.v11.ac.Token;
import oracle.security.xmlsec.liberty.v11.ac.WTLS;
import oracle.security.xmlsec.liberty.v11.ac.WrittenConsent;
import oracle.security.xmlsec.liberty.v11.ac.ZeroKnowledge;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;

public class LibertyInitializer {
    public static final String AUTHENTICATION_CONTEXT_CLASS_KEY = "authenticationContextClass";
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XMLElement.setDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance", (String)"xsi");
            XMLElement.setDefaultNSPrefix((String)"http://projectliberty.org/schemas/core/2002/12", (String)"lib");
            XMLElement.setDefaultNSPrefix((String)"http://projectliberty.org/schemas/authctx/2002/05", (String)"ac");
            LibertyInitializer.mapLibertyProtocolTags();
            LibertyInitializer.mapACClassURIs();
            LibertyInitializer.mapACTags();
            XMLUtils.addIdAttribute((String)"http://projectliberty.org/schemas/core/2002/12", (String)"id");
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:assertion", (String)"id");
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"id");
            initialized = true;
        }
    }

    private LibertyInitializer() {
    }

    private static void mapACClassURIs() {
        URIManager uriMgr = URIManager.getURIManager();
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/MobileContract", AUTHENTICATION_CONTEXT_CLASS_KEY, MobileContractClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/MobileDigitalID", AUTHENTICATION_CONTEXT_CLASS_KEY, MobileDigitalIDClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/MobileUnregistered", AUTHENTICATION_CONTEXT_CLASS_KEY, MobileUnregisteredClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Password", AUTHENTICATION_CONTEXT_CLASS_KEY, PasswordClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Password-ProtectedTransport", AUTHENTICATION_CONTEXT_CLASS_KEY, PasswordProtectedTransportClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Previous-Session", AUTHENTICATION_CONTEXT_CLASS_KEY, PreviousSessionClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Smartcard", AUTHENTICATION_CONTEXT_CLASS_KEY, SmartcardClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Smartcard-PKI", AUTHENTICATION_CONTEXT_CLASS_KEY, SmartcardPKIClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Software-PKI", AUTHENTICATION_CONTEXT_CLASS_KEY, SoftwarePKIClass.class);
        uriMgr.mapClass("http://www.projectliberty.org/schemas/authctx/classes/Time-Sync-Token", AUTHENTICATION_CONTEXT_CLASS_KEY, TimeSyncTokenClass.class);
    }

    private static void mapACTags() {
        TagManager tm = TagManager.getTagManager();
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationContextStatement", AuthenticationContextStatement.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationMethod", AuthenticationMethod.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Authenticator", Authenticator.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "AuthenticatorTransportProtocol", AuthenticatorTransportProtocol.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "DeactivationCallCenter", DeactivationCallCenter.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Dig-sig", DigSig.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Generation", Generation.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "GoverningAgreementRef", GoverningAgreementRef.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "GoverningAgreements", GoverningAgreements.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "HTTP", HTTP.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Identification", Identification.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "IPSec", IPSec.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "KeyActivation", KeyActivation.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "KeyStorage", KeyStorage.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Length", Length.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "MobileAuthCard", MobileAuthCard.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "MobileDevice", MobileDevice.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "MobileNetwork", MobileNetwork.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "OperationalProtection", OperationalProtection.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Password", Password.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "PhysicalVerification", PhysicalVerification.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "PreviousSession", PreviousSession.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "PrincipalAuthenticationMechanism", PrincipalAuthenticationMechanism.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "PrivateKeyProtection", PrivateKeyProtection.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "SecurityAudit", SecurityAudit.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "SharedKeyProtection", SharedKeyProtection.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "SharedSecretChallengeResponse", SharedSecretChallengeResponse.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Smartcard", Smartcard.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "SSL", SSL.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "SwitchAudit", SwitchAudit.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "TechnicalProtection", TechnicalProtection.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "TimeSyncToken", TimeSyncToken.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "Token", Token.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "WrittenConsent", WrittenConsent.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "WTLS", WTLS.class);
        tm.mapTag("http://projectliberty.org/schemas/authctx/2002/05", "ZeroKnowledge", ZeroKnowledge.class);
    }

    private static void mapLibertyProtocolTags() {
        TagManager tm = TagManager.getTagManager();
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthnContext", AuthnContext.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthnRequest", AuthnRequest.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthnRequestEnvelope", AuthnRequestEnvelope.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthnResponse", AuthnResponse.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthnResponseEnvelope", AuthnResponseEnvelope.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "FederationTerminationNotification", FederationTerminationNotification.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "IDPDescriptor", IDPDescriptor.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "IDPEntries", IDPEntries.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "IDPEntry", IDPEntry.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "IDPList", IDPList.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "IDPProvidedNameIdentifier", IDPProvidedNameIdentifier.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "LogoutRequest", LogoutRequest.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "LogoutResponse", LogoutResponse.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "OldProvidedNameIdentifier", OldProvidedNameIdentifier.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierRequest", RegisterNameIdentifierRequest.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierResponse", RegisterNameIdentifierResponse.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "SPDescriptor", SPDescriptor.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "SPProvidedNameIdentifier", SPProvidedNameIdentifier.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AssertionType", LibAssertion.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "AuthenticationStatementType", LibAuthenticationStatement.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "SignedSAMLRequestType", LibSAMLRequest.class);
        tm.mapTag("http://projectliberty.org/schemas/core/2002/12", "SubjectType", LibSubject.class);
    }
}

