/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.mysql4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.mysql3.MySQLCapturer;
import oracle.dbtools.migration.workbench.mysql4.Black4Messages;
import oracle.dbtools.migration.workbench.mysql4.MySQL4CaptureQueries;

public class MySQL4Capturer
extends MySQLCapturer {
    private static MySQL4CaptureQueries s_captureQueries;
    private String[] m_captureColumn = new String[]{Black4Messages.getString("MySQL4Capturer.Field"), Black4Messages.getString("MySQL4Capturer.Type"), Black4Messages.getString("MySQL4Capturer.Collation"), Black4Messages.getString("MySQL4Capturer.Null"), Black4Messages.getString("MySQL4Capturer.Key"), Black4Messages.getString("MySQL4Capturer.Default"), Black4Messages.getString("MySQL4Capturer.Extra"), Black4Messages.getString("MySQL4Capturer.Priv"), Black4Messages.getString("MySQL4Capturer.comment")};

    public MySQL4Capturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
    }

    @Override
    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQL4CaptureQueries();
        }
        return s_captureQueries;
    }

    @Override
    protected int getColumnCaptureInfo(String string) {
        if (this.m_minorVersion < 1) {
            return super.getColumnCaptureInfo(string);
        }
        for (int i = 0; i < this.m_captureColumn.length; ++i) {
            if (!this.m_captureColumn[i].equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 1;
    }

    @Override
    protected void captureIndexForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        boolean bl;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer("SHOW INDEX FROM `${schema}`.`${table}`");
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_INDEXES");
        CloseableResultSet closeableResultSet = null;
        closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        boolean bl2 = bl = !resultSet.next();
        while (!bl) {
            MdConstraint mdConstraint;
            String string;
            int n = 1;
            if (captureContext.shouldCancel()) {
                string = new CaptureEvent(-1, Black4Messages.getString("MySQL4Capturer.index"), "");
                captureContext.getAudience().fireListeners((CaptureEvent)string);
                closeableResultSet.close();
                return;
            }
            string = resultSet.getString(3);
            if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string)) {
                bl = !resultSet.next();
                continue;
            }
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
            int n2 = resultSet.getInt(2);
            MdIndexe mdIndexe = new MdIndexe(dBObjectId);
            mdIndexe.setIndexName(resultSet.getString(3));
            String string2 = captureContext.applyToSQLString("${schema}");
            String string3 = "SHOW COLUMNS FROM `" + string2 + "`.`" + resultSet.getString(1) + "`";
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string3, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet2 = closeableResultSet2.getResultSet();
            String string4 = "";
            while (resultSet2.next()) {
                if (!resultSet2.getString(1).equals(resultSet.getString(5))) continue;
                string4 = resultSet2.getString(4);
                break;
            }
            closeableResultSet2.close();
            if (string4.startsWith("PRI") && n2 == 0 && resultSet.getString(3).equals("PRIMARY")) {
                mdConstraint = this.createPrimaryIndexConstraint(captureContext, resultSet.getString(3), dBObjectId);
                do {
                    this.createPrimaryIndexConstraintDetails(captureContext, mdConstraint, resultSet.getString(5), n++, dBObjectId);
                } while (!(bl = !resultSet.next()) && resultSet.getString(3).equals(mdConstraint.getObjectName()));
                continue;
            }
            mdIndexe = new MdIndexe(dBObjectId);
            mdIndexe.setIndexName(resultSet.getString(3));
            if (n2 == 0) {
                mdIndexe.setIndexType("UNIQUE");
            } else {
                mdIndexe.setIndexType("NON_UNIQUE");
            }
            mdConstraint = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners((CaptureEvent)mdConstraint);
            mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
            mdConstraint.setEventId(4);
            captureContext.getAudience().fireListeners((CaptureEvent)mdConstraint);
            do {
                this.createIndexDetails(captureContext, mdIndexe, resultSet, n++);
            } while (!(bl = !resultSet.next()) && resultSet.getString(3).equals(mdIndexe.getIndexName()));
        }
        closeableResultSet.close();
    }
}

