/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.EditorProperties;

public final class EditorOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_autoIndent;
    private JCheckBox checkBox_autoSurroundSelection;
    private JCheckBox checkBox_useBlockOnSelection;
    private JCheckBox checkBox_useJumpScroll;
    private JCheckBox checkBox_useSmartHome;
    private JCheckBox checkBox_useSmartEnd;
    private JCheckBox checkBox_useCaseForWord;
    private JCheckBox checkBox_cutCopyLine;
    private JCheckBox checkBox_importsCopyPaste;
    private JCheckBox checkBox_indentCopyPaste;
    private JCheckBox checkBox_reformatCopyPaste;
    private JCheckBox checkBox_escapeStringPaste;
    private JCheckBox checkBox_middleButton;
    private JCheckBox checkBox_lineLimit;
    private JSpinner spinner_lineLimit;

    public EditorOptionsPanel() {
        this.setHelpID("f1_idedideseteditor_html");
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        EditorOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        EditorOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private EditorOptions findOptions(TraversableContext tc) {
        return EditorOptions.getInstance(tc.getPropertyStorage());
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        EditorOptions options = this.findOptions(tc);
        EditorOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(EditorOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean autoIndent = options.getAutoIndent();
        properties.putBooleanProperty("use-auto-indent", autoIndent);
        boolean useBlockOnSelection = options.getUseBlockOnSelection();
        properties.putBooleanProperty("do-block-indents-on-selection", useBlockOnSelection);
        boolean useJumpScroll = options.getUseJumpScroll();
        properties.putBooleanProperty("use-jump-scroll", useJumpScroll);
        boolean useSmartHome = options.getUseSmartHome();
        properties.putBooleanProperty("use-smart-home", useSmartHome);
        boolean useSmartEnd = options.getUseSmartEnd();
        properties.putBooleanProperty("use-smart-end", useSmartEnd);
        boolean useCaseDelimited = options.getUseCaseDelimitedWord();
        properties.putBooleanProperty("word-boundary-use-case", useCaseDelimited);
        boolean useLineStart = options.getUseLineStartForWord();
        properties.putBooleanProperty("word-boundary-use-line-start", useLineStart);
        boolean useLineEnd = options.getUseLineEndForWord();
        properties.putBooleanProperty("word-boundary-use-line-end", useLineEnd);
        boolean useCutCopyLine = options.getCutCopyLine();
        properties.putBooleanProperty("cut-copy-line", useCutCopyLine);
        boolean importsCopyPaste = options.getImportsCopyPaste();
        properties.putBooleanProperty("smart-copy-paste", importsCopyPaste);
        boolean indentCopyPaste = options.getIndentCopyPaste();
        properties.putBooleanProperty("autoindent-copy-paste", indentCopyPaste);
        boolean reformatCopyPaste = options.getReformatCopyPaste();
        properties.putBooleanProperty("autoreformat-copy-paste", reformatCopyPaste);
        boolean escapeStringPaste = options.getEscapeStringPaste();
        properties.putBooleanProperty("escape-string-paste", escapeStringPaste);
        boolean reuseUndoEvent = options.getReuseUndoEvent();
        properties.putBooleanProperty("reuse-undoable-edit", reuseUndoEvent);
        boolean reuseDocEvent = options.getReuseDocEvent();
        properties.putBooleanProperty("reuse-document-event", reuseDocEvent);
        boolean useExpensivePaste = options.getUseExpensivePasteChecking();
        properties.putBooleanProperty("check-clipboard-for-paste", useExpensivePaste);
        BasicCaret.MiddleButtonBehavior middleButtonBehavior = options.getMiddleButtonBehavior();
        properties.putProperty("middle-button-behavior", (Object)middleButtonBehavior);
    }

    void loadSettingsFrom(EditorOptions options) {
        this.checkBox_autoIndent.setSelected(options.getAutoIndent());
        this.checkBox_autoSurroundSelection.setSelected(options.getAutoSurroundSelection());
        this.checkBox_useBlockOnSelection.setSelected(options.getUseBlockOnSelection());
        this.checkBox_useJumpScroll.setSelected(options.getUseJumpScroll());
        this.checkBox_useSmartHome.setSelected(options.getUseSmartHome());
        this.checkBox_useSmartEnd.setSelected(options.getUseSmartEnd());
        this.checkBox_useCaseForWord.setSelected(options.getUseCaseDelimitedWord());
        this.checkBox_cutCopyLine.setSelected(options.getCutCopyLine());
        this.checkBox_importsCopyPaste.setSelected(options.getImportsCopyPaste());
        this.checkBox_indentCopyPaste.setSelected(options.getIndentCopyPaste());
        this.checkBox_reformatCopyPaste.setSelected(options.getReformatCopyPaste());
        this.checkBox_escapeStringPaste.setSelected(options.getEscapeStringPaste());
        this.checkBox_middleButton.setSelected(options.getMiddleButtonBehavior() == BasicCaret.MiddleButtonBehavior.SCROLLS);
        this.checkBox_lineLimit.setSelected(options.isLongLineWarning());
        this.spinner_lineLimit.setValue(options.getLongLineWarningLimit());
    }

    void saveSettingsTo(EditorOptions options) {
        options.setAutoIndent(this.checkBox_autoIndent.isSelected());
        options.setAutoSurroundSelection(this.checkBox_autoSurroundSelection.isSelected());
        options.setUseBlockOnSelection(this.checkBox_useBlockOnSelection.isSelected());
        options.setUseJumpScroll(this.checkBox_useJumpScroll.isSelected());
        options.setUseSmartHome(this.checkBox_useSmartHome.isSelected());
        options.setUseSmartEnd(this.checkBox_useSmartEnd.isSelected());
        options.setUseCaseDelimitedWord(this.checkBox_useCaseForWord.isSelected());
        options.setCutCopyLine(this.checkBox_cutCopyLine.isSelected());
        options.setImportsCopyPaste(this.checkBox_importsCopyPaste.isSelected());
        options.setIndentCopyPaste(this.checkBox_indentCopyPaste.isSelected());
        options.setReformatCopyPaste(this.checkBox_reformatCopyPaste.isSelected());
        options.setEscapeStringPaste(this.checkBox_escapeStringPaste.isSelected());
        options.setMiddleButtonBehavior(this.checkBox_middleButton.isSelected() ? BasicCaret.MiddleButtonBehavior.SCROLLS : BasicCaret.MiddleButtonBehavior.DEFAULT);
        options.setLongLineWarning(this.checkBox_lineLimit.isSelected());
        options.setLongLineWarningLimit((Integer)this.spinner_lineLimit.getValue());
    }

    private void initializeComponent() {
        this.checkBox_autoIndent = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoIndent, (String)OptionsArb.getString(0));
        this.checkBox_autoSurroundSelection = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoSurroundSelection, (String)OptionsArb.getString(1));
        this.checkBox_useBlockOnSelection = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useBlockOnSelection, (String)OptionsArb.getString(2));
        this.checkBox_useJumpScroll = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useJumpScroll, (String)OptionsArb.getString(3));
        this.checkBox_useSmartHome = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartHome, (String)OptionsArb.getString(4));
        this.checkBox_useSmartEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartEnd, (String)OptionsArb.getString(5));
        this.checkBox_useCaseForWord = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useCaseForWord, (String)OptionsArb.getString(6));
        this.checkBox_cutCopyLine = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_cutCopyLine, (String)OptionsArb.getString(7));
        this.checkBox_importsCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_importsCopyPaste, (String)OptionsArb.getString(8));
        this.checkBox_indentCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_indentCopyPaste, (String)OptionsArb.getString(9));
        this.checkBox_reformatCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_reformatCopyPaste, (String)OptionsArb.getString(10));
        this.checkBox_escapeStringPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_escapeStringPaste, (String)OptionsArb.getString(11));
        this.checkBox_middleButton = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_middleButton, (String)OptionsArb.getString(15));
        this.checkBox_lineLimit = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_lineLimit, (String)OptionsArb.getString(16));
        this.spinner_lineLimit = new JSpinner(new SpinnerNumberModel(100, 100, 99999, 1));
        this.spinner_lineLimit.setEditor(new JSpinner.NumberEditor(this.spinner_lineLimit));
        JLabel lineLimitLabelCharacters = new JLabel();
        ResourceUtils.resLabel((JLabel)lineLimitLabelCharacters, (Component)this.spinner_lineLimit, (String)OptionsArb.getString(17));
        Component[] completionDependents = new Component[]{this.spinner_lineLimit, lineLimitLabelCharacters};
        ItemSelectableTracker completionTracker = new ItemSelectableTracker((ItemSelectable)this.checkBox_lineLimit, completionDependents);
        this.checkBox_lineLimit.addItemListener((ItemListener)completionTracker);
        this.setLayout((LayoutManager)new MigLayout("ins 0, nogrid, gapy 2, alignx leading, aligny top"));
        this.add(this.checkBox_autoIndent, "wrap");
        this.add(this.checkBox_autoSurroundSelection, "wrap");
        this.add(this.checkBox_useBlockOnSelection, "wrap");
        this.add(this.checkBox_useSmartHome, "wrap");
        this.add(this.checkBox_useSmartEnd, "wrap");
        this.add(this.checkBox_useJumpScroll, "wrap");
        this.add(this.checkBox_useCaseForWord, "wrap");
        this.add(this.checkBox_cutCopyLine, "wrap");
        this.add(this.checkBox_importsCopyPaste, "wrap");
        this.add(this.checkBox_indentCopyPaste, "wrap");
        this.add(this.checkBox_reformatCopyPaste, "wrap");
        this.add(this.checkBox_escapeStringPaste, "wrap");
        this.add(this.checkBox_middleButton, "wrap");
        this.add(this.checkBox_lineLimit, "");
        this.add(lineLimitLabelCharacters, "newline, gapleft 24, width 44");
        this.add(this.spinner_lineLimit, "");
    }
}

