/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.Selection;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipOrientation;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;

final class EditorOffsetLabel
extends JLabel {
    private BasicEditorPane editor;
    private Hoverable hoverable = new Hoverable(){

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            InfoTipHover infoTipHover = new InfoTipHover(EditorOffsetLabel.this.createHoverContent(), InfoTipStyles.DEFAULT, (JComponent)EditorOffsetLabel.this, new Rectangle(0, 0, EditorOffsetLabel.this.getWidth(), EditorOffsetLabel.this.getHeight()), HoverFlavor.getFlavor((String)"info"));
            infoTipHover.setOrientation(InfoTipOrientation.TOP_BOTTOM);
            infoTipHover.showHover();
            return infoTipHover;
        }
    };

    EditorOffsetLabel(BasicEditorPane editor) {
        this.editor = editor;
        editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                EditorOffsetLabel.this.updateLabel();
            }
        });
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("editable")) {
                    EditorOffsetLabel.this.updateLabel();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditorOffsetLabel.this.editor.isShowing()) {
                    EditorOffsetLabel.this.updateLabel();
                }
            }
        });
        this.updateLabel();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IdeAction action = IdeAction.find((String)"Ide.GOTO_LINE_NUMBER_CMD_ID");
                try {
                    action.performAction(CodeEditor.getContext(EditorOffsetLabel.this.editor));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabel() {
        this.setIconTextGap(2);
        this.editor.getTextBuffer().readLock();
        try {
            int offset = this.editor.getCaretPosition();
            int line = this.editor.getLineFromOffset(offset) + 1;
            int col = offset - this.editor.getLineStartOffset(this.editor.getLineFromOffset(offset)) + 1;
            int selection = this.editor.getSelectionEnd() - this.editor.getSelectionStart();
            if (selection == 0) {
                this.setText(line + ":" + col);
            } else {
                this.setText(line + ":" + col + "/" + selection);
            }
            this.setIcon(this.editor.isEditable() ? null : OracleIcons.getIcon((String)"overlay/locked.png"));
        }
        finally {
            this.editor.getTextBuffer().readUnlock();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        HoverableRegistry.registerComponent((Component)this, (Hoverable)this.hoverable);
    }

    @Override
    public void removeNotify() {
        HoverableRegistry.unregisterComponent((Component)this, (Hoverable)this.hoverable);
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template createHoverContent() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0 4 4 4, gapx 10, gapy 4"));
        panel.setOpaque(false);
        this.editor.getTextBuffer().readLock();
        try {
            LineMap lm = this.editor.getTextBuffer().getLineMap();
            int pos = this.editor.getCaretPosition();
            panel.add((Component)new JLabel(CEditor.get("LOCATION")), "");
            panel.add((Component)new JLabel(pos + " (of " + this.editor.getTextBuffer().getLength() + ")"), "");
            panel.add((Component)new JLabel(CEditor.get("LINE")), "newline");
            panel.add((Component)new JLabel(this.editor.getLineFromOffset(pos) + 1 + " (of " + lm.getLineCount() + ")"), "");
            panel.add((Component)new JLabel(CEditor.get("COLUMN")), "newline");
            panel.add((Component)new JLabel("" + (pos - this.editor.getLineStartOffset(this.editor.getLineFromOffset(pos)) + 1)), "");
            panel.add((Component)new JLabel(CEditor.get("SELECTION")), "newline");
            panel.add((Component)new JLabel(CEditor.format("SELECTION_VALUE", this.editor.getSelectionStart(), this.editor.getSelectionEnd(), Math.abs(this.editor.getSelectionEnd() - this.editor.getSelectionStart()))), "");
            for (Selection sel : this.editor.getMultiSelections()) {
                panel.add(Box.createGlue(), "newLine");
                panel.add((Component)new JLabel(CEditor.format("SELECTION_VALUE", sel.getStart(), sel.getEnd(), Math.abs(sel.getStart() - sel.getEnd()))), "");
            }
            int longLine = 1;
            int chars = 0;
            for (int i = 0; i < lm.getLineCount(); ++i) {
                int lineChars = lm.getLineEndOffset(i) - lm.getLineStartOffset(i);
                if (lineChars <= chars) continue;
                chars = lineChars;
                longLine = i + 1;
            }
            panel.add((Component)new JLabel(CEditor.get("LONGEST_LINE")), "newline");
            panel.add((Component)new JLabel(CEditor.format("LONGEST_LINE_VALUE", longLine, chars)), "");
            String eolType = this.editor.getTextBuffer().getEOLType();
            String eolTypeText = "";
            eolTypeText = eolType == "\r\n" ? CEditorArb.getString(21) : (eolType == "\n" ? CEditorArb.getString(20) : CEditorArb.getString(19));
            panel.add((Component)new JLabel(CEditor.get("LINE_TERMINATOR")), "newline");
            panel.add((Component)new JLabel(eolTypeText), "");
            panel.add((Component)new JLabel(CEditor.get("STATE")), "newline");
            JLabel readOnlyLabel = new JLabel(this.editor.getTextBuffer().isReadOnly() ? CEditor.get("READONLY") : CEditor.get("WRITEABLE"));
            readOnlyLabel.setIcon(this.editor.isEditable() ? null : OracleIcons.getIcon((String)"overlay/locked.png"));
            readOnlyLabel.setHorizontalTextPosition(10);
            panel.add((Component)readOnlyLabel, "");
        }
        finally {
            this.editor.getTextBuffer().readUnlock();
        }
        return new BasicTemplate((JComponent)panel);
    }
}

