/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.explorer.BaseListGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.ContextMenuListener;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListDropHandler;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListHelper;
import oracle.bali.xml.gui.swing.explorer.XmlJList;
import oracle.bali.xml.gui.swing.explorer.XmlListCellRenderer;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import org.w3c.dom.Node;

public class SwingListGui
extends BaseListGui
implements ComponentXmlGui<JList> {
    private boolean _working = false;
    private XmlJList _list = null;
    private final ListHelper _listHelper = new ListHelper();
    private final Set<Node> _highlightedNodes = new HashSet<Node>(4);
    private static final Logger _LOGGER = Logger.getLogger(SwingListGui.class.getName());

    public SwingListGui(XmlView view) {
        super(view);
    }

    @Override
    public final JList getComponent() {
        if (this._list == null) {
            this._list = new XmlJList(this);
            this._configureList();
            this._working = true;
            try {
                this._syncSelectionFromModel();
            }
            finally {
                this._working = false;
            }
        }
        return this._list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHighlightedNodes(Collection<? extends Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            this._highlightedNodes.clear();
            return;
        }
        this.getView().acquireReadLock();
        try {
            Set<Node> set = this._highlightedNodes;
            synchronized (set) {
                this._highlightedNodes.clear();
                for (Node node : nodes) {
                    if (this.getView().isInModelDocumentHierarchy(node)) {
                        this._highlightedNodes.add(node);
                        continue;
                    }
                    _LOGGER.log(Level.WARNING, "setHighlightedNodes passed node not in document hierarchy: {0}. It was ignored.", node);
                }
            }
        }
        finally {
            this.getView().releaseReadLock();
        }
        if (this._list != null) {
            this._list.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Rectangle> getHighlightedRectangles() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("getHighlightedRectangles must be called on event thread");
        }
        if (this._list == null) {
            return Collections.emptySet();
        }
        this.getView().acquireReadLock();
        try {
            Set<Node> set = this._highlightedNodes;
            synchronized (set) {
                HashSet<Rectangle> ret = new HashSet<Rectangle>(this._highlightedNodes.size());
                for (Node n : this._highlightedNodes) {
                    Rectangle rect;
                    int index = this.getIndexForNode(n);
                    if (index < 0 || (rect = this._list.getCellBounds(index, index)) == null) continue;
                    ret.add(rect);
                }
                HashSet<Rectangle> hashSet = ret;
                return hashSet;
            }
        }
        finally {
            this.getView().releaseReadLock();
        }
    }

    protected void showPopupMenu(MouseEvent event, int clickedRow) {
        new ContextMenuListener(this._list, (XmlGui)this).mouseReleased(event);
    }

    protected boolean invokeDefaultAction(InputEvent event, int clickedRow) {
        return false;
    }

    protected final void paintCursorOrDropPosition(JList list, Graphics g) {
        this._listHelper.paintCursorOrDropPosition(list, g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleModelChangeEvent(XmlModelEvent event) {
        Set<Node> set = this._highlightedNodes;
        synchronized (set) {
            if (!this._highlightedNodes.isEmpty()) {
                Node[] oldHighlight;
                for (Node node : oldHighlight = this._highlightedNodes.toArray(new Node[this._highlightedNodes.size()])) {
                    if (this.getView().isInModelDocumentHierarchy(node)) continue;
                    this._highlightedNodes.remove(node);
                    Node remapped = this.getView().remapNode(node);
                    if (remapped == null) continue;
                    this._highlightedNodes.add(remapped);
                }
            }
        }
        super.handleModelChangeEvent(event);
    }

    SwingTreeListHelper<SwingListGui, JList> __getHelper() {
        return this._listHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean __isNodeHighlighted(Node node) {
        Set<Node> set = this._highlightedNodes;
        synchronized (set) {
            return this._highlightedNodes.contains(node);
        }
    }

    private void _configureList() {
        this._list.setDragEnabled(true);
        XmlListCellRenderer cellRenderer = new XmlListCellRenderer(this, this._list.getCellRenderer());
        this._list.setCellRenderer(cellRenderer);
        Component bogus = cellRenderer.getListCellRendererComponent((JList)this._list, "bogus", 0, true, true);
        this._list.setFixedCellHeight(bogus.getPreferredSize().height);
        SelectionCoordinator sc = new SelectionCoordinator();
        this.addModelListener((XmlModelListener)sc);
        this._list.addListSelectionListener(sc);
        SwingTreeListDropHandler<JList> dropHandler = new SwingTreeListDropHandler<JList>(this._listHelper);
        this._list.setDropTarget(new DropTarget(this._list, dropHandler));
    }

    private void _syncSelectionToModel() {
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) {
                int[] indices = SwingListGui.this._list.getSelectedIndices();
                ArrayList<Node> nodes = new ArrayList<Node>(indices.length);
                for (int i : indices) {
                    Node node = SwingListGui.this.getNodeForIndex(i);
                    if (node == null) continue;
                    nodes.add(node);
                }
                Selection selection = model.getSelection();
                selection.set(nodes);
                int leadRow = SwingListGui.this._list.getLeadSelectionIndex();
                Node leadNode = SwingListGui.this.getNodeForIndex(leadRow);
                if (leadNode != null) {
                    selection.setCursorLocation(DomPositionFactory.createInsideOrAfterPosition((Node)leadNode));
                }
            }
        }.run((AbstractModel)this.getView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _syncSelectionFromModel() {
        int[] selectedIndices;
        this.getView().acquireReadLock();
        try {
            Selection selection = this.getView().getSelection();
            selectedIndices = new int[selection.getSelectedNodesCount()];
            Iterator itor = selection.getSelectedNodes();
            int i = 0;
            while (itor.hasNext()) {
                Node node = (Node)itor.next();
                selectedIndices[i] = this.getIndexForNode(node);
                ++i;
            }
        }
        finally {
            this.getView().releaseReadLock();
        }
        this._list.setSelectedIndices(selectedIndices);
    }

    private class ListHelper
    extends SwingTreeListHelper<SwingListGui, JList> {
        ListHelper() {
            super(SwingListGui.this);
        }

        @Override
        protected int getRowIfVisible(JList list, Node node) {
            int index = SwingListGui.this.getIndexForNode(node);
            return index;
        }

        @Override
        protected Rectangle getBoundsIfVisible(JList list, int row) {
            Rectangle bounds = list.getCellBounds(row, row);
            if (bounds != null && list.getVisibleRect().intersects(bounds)) {
                return bounds;
            }
            return null;
        }

        @Override
        protected Node getNodeAt(JList tree, int x, int y) {
            int row = tree.locationToIndex(new Point(x, y));
            if (row >= 0) {
                return SwingListGui.this.getNodeForIndex(row);
            }
            return null;
        }

        @Override
        protected int getRowCount(JList component) {
            return component.getModel().getSize();
        }

        @Override
        protected Node getNodeForRow(JList component, int row) {
            return SwingListGui.this.getNodeForIndex(row);
        }

        protected void regularProcessMouseEvent(JList list, MouseEvent event) {
            ((XmlJList)list).__regularProcessMouseEvent(event);
        }

        protected void regularProcessMouseMotionEvent(JList list, MouseEvent event) {
            ((XmlJList)list).__regularProcessMouseMotionEvent(event);
        }

        @Override
        protected int getRowAt(JList component, int x, int y) {
            return component.locationToIndex(new Point(x, y));
        }

        @Override
        protected void regularProcessMouseEvent(MouseEvent event) {
            ((XmlJList)event.getComponent()).__regularProcessMouseEvent(event);
        }

        @Override
        protected void regularProcessMouseMotionEvent(MouseEvent event) {
            ((XmlJList)event.getComponent()).__regularProcessMouseMotionEvent(event);
        }

        @Override
        protected boolean invokeDefaultAction(InputEvent e, int clickedRow) {
            return SwingListGui.this.invokeDefaultAction(e, clickedRow);
        }

        @Override
        protected void showPopupMenu(MouseEvent e, int clickedRow) {
            SwingListGui.this.showPopupMenu(e, clickedRow);
        }

        @Override
        protected int getLeadSelectionRow(JList component) {
            return component.getLeadSelectionIndex();
        }
    }

    private class SelectionCoordinator
    extends XmlModelAdapter
    implements ListSelectionListener {
        private SelectionCoordinator() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!(SwingListGui.this._working || e.getValueIsAdjusting() || SwingListGui.this.getListModel().isProcessingXmlModelEvent())) {
                SwingListGui.this._working = true;
                try {
                    SwingListGui.this._syncSelectionToModel();
                }
                finally {
                    SwingListGui.this._working = false;
                }
            }
        }

        public void modelChanged(XmlModelEvent event) {
            if (!SwingListGui.this._working && event.isSelectionChanged()) {
                SwingListGui.this._working = true;
                try {
                    SwingListGui.this._syncSelectionFromModel();
                }
                finally {
                    SwingListGui.this._working = false;
                }
            }
            if (event.getDropLocationPropertyChange() != null || event.getCursorLocationPropertyChange() != null) {
                SwingListGui.this._list.repaint();
            }
        }
    }
}

