/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.tooltip;

import java.util.List;
import javax.swing.ListModel;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightData;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.editor.insight.tooltip.data.ValueTypeTooltipDataItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.SimpleType;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.editor.insight.TooltipDataItemListModel;

public class ValueTypeTooltipInsightData
extends XMLTooltipInsightData {
    private XMLTooltipInsightProvider _insight;
    private TooltipDataItemListModel _listModel;
    private InsightLocation _insightLocation;
    private TooltipDataItem[] _insightDataList;

    protected ValueTypeTooltipInsightData(XMLTooltipInsightProvider insight, InsightLocation insightLocation) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this._fillDataList();
    }

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    @Override
    public void updateData() {
        int endOffset;
        int startOffset;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        for (startOffset = caretOffset - 1; startOffset >= 0 && textBuffer.getChar(startOffset) != '=' && textBuffer.getChar(startOffset) != '\"'; --startOffset) {
        }
        for (endOffset = ++startOffset; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '=' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>' && textBuffer.getChar(endOffset) != '\"'; ++endOffset) {
        }
        if (caretOffset < startOffset || caretOffset > endOffset) {
            this._clearData();
            return;
        }
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new TooltipDataItem[0];
        }
        this._listModel = null;
    }

    private TooltipDataItemListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new TooltipDataItemListModel(this._insightDataList);
        }
        return this._listModel;
    }

    private void _fillDataList() {
        ValueTypeTooltipDataItem item = null;
        List declarations = this._insightLocation.getElementDeclarations();
        if (declarations.size() > 0) {
            int caretPosition = this._insight.getCaretPosition();
            int lastIndex = declarations.size() - 1;
            ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastIndex);
            ResolvedName attrName = null;
            AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
            int attrIndex = InsightUtils.getAttributeAtCaretPosition(attributes, caretPosition);
            if (attrIndex != -1) {
                attrName = attributes.getResolvedName(attrIndex);
            }
            if (attrName != null) {
                SimpleType attType;
                AttributeDef attributeDef;
                ElementDef parentElementDef;
                String namespace = attrName.getNamespace();
                String localName = attrName.getLocalName();
                if (localName != null && localName.length() > 0 && (parentElementDef = InsightUtils.getElementDef(this._insight.getGrammarResolver(), this._insight.getGrammarProvider(), declarations, lastIndex)) != null && (attributeDef = parentElementDef.getAttributeDefByName(namespace, localName)) != null && (attType = attributeDef.getType()) != null && attType.getName() != null) {
                    item = new ValueTypeTooltipDataItem(attType);
                }
            }
        }
        if (item == null) {
            this._insightDataList = new TooltipDataItem[0];
        } else {
            this._insightDataList = new TooltipDataItem[1];
            this._insightDataList[0] = item;
        }
    }
}

