/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.javatools.ui.Components;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public final class MiniSearchDialog {
    public static final String ACTION_DISMISSED = "miniSearchDialogDismissed";
    private GhostPalette ghostPanel;
    private final SearchField searchField = new SearchField();
    private final JLabel messageLabel = new JLabel();
    private JPanel basePanel;
    private String lastSearchText;
    private final PalettePosition palettePosition = new PalettePosition();
    private final Collection<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();

    public MiniSearchDialog() {
        this.messageLabel.setHorizontalTextPosition(2);
        this.messageLabel.putClientProperty(UIConstants.INSTRUCTION_LABEL, true);
        this.searchField.getTextField().setColumns(30);
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchField.setNotifyOnEmptySearch(true);
        this.searchField.setAutoFind(true);
        this.searchField.putClientProperty(UIConstants.VETO_HIERARCHY_CONVERSION, Boolean.TRUE);
        this.basePanel = new JPanel(new BorderLayout(0, 2));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniSearchDialog.this.ghostPalette().hidePanel();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.searchField.registerKeyboardAction(actionListener, stroke, 2);
        this.searchField.getTextField().registerKeyboardAction(actionListener, stroke, 0);
    }

    public void addActionListener(ActionListener a) {
        this.actionListeners.add(a);
    }

    public void removeActionListener(ActionListener e) {
        this.actionListeners.remove(e);
    }

    public JPanel getBasePanel() {
        return this.basePanel;
    }

    private void fireActionPerformed(String actionId) {
        ActionEvent event = new ActionEvent(this, 1001, actionId);
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(event);
        }
    }

    private GhostPalette createGhostPalette() {
        GhostPalette palette = new GhostPalette();
        palette.setHideOnLoseFocus(true);
        palette.setMinimumSize(new Dimension(200, 75));
        this.basePanel.add((Component)this.searchField, "North");
        this.basePanel.add((Component)this.messageLabel, "South");
        palette.setLayout(new BorderLayout());
        palette.add((Component)this.basePanel, "Center");
        return palette;
    }

    public GhostPalette ghostPalette() {
        if (this.ghostPanel != null) {
            return this.ghostPanel;
        }
        this.ghostPanel = this.createGhostPalette();
        this.ghostPanel.addAncestorListener(new AncestorRemovedListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                MiniSearchDialog.this.fireActionPerformed(MiniSearchDialog.ACTION_DISMISSED);
                MiniSearchDialog.this.ghostPanel.removeAncestorListener(this);
                MiniSearchDialog.this.ghostPanel = null;
            }
        });
        return this.ghostPanel;
    }

    public void addSearchListener(SearchListener l) {
        this.searchField.addSearchListener(l);
    }

    public void removeSearchListener(SearchListener l) {
        this.searchField.removeSearchListener(l);
    }

    public void setTypingDelay(SearchField.TypingDelay delay) {
        this.searchField.setTypingDelay(delay);
    }

    public void setSearchText(String searchText) {
        this.searchField.setText(searchText, true);
    }

    public void setStyle(SearchField.Style style) {
        this.searchField.setStyle(style);
    }

    public void setPreferredLocation(Location location) {
        this.palettePosition.preferredLocation = location;
    }

    public void installFindNextKeyStroke(KeyStroke keyStroke) {
        this.searchField.installFindNextKeyStroke(keyStroke);
    }

    public void installFindPreviousKeyStroke(KeyStroke keyStroke) {
        this.searchField.installFindPreviousKeyStroke(keyStroke);
    }

    public void show(JComponent targetComponent) {
        GhostPalette palette = this.ghostPalette();
        if (palette.isShowing()) {
            this.searchField.requestFocus();
            return;
        }
        if (!targetComponent.isShowing()) {
            return;
        }
        this.setMessage("");
        if (this.lastSearchText != null) {
            this.searchField.setText(this.lastSearchText);
        }
        this.searchField.getTextField().selectAll();
        palette.pack();
        this.palettePosition.position(palette, targetComponent);
        JLayeredPane lp = Components.findLayeredPane(targetComponent);
        if (lp != null) {
            palette.show(Components.findLayeredPane(targetComponent), false, true);
        }
    }

    public void setTitle(String title) {
        this.ghostPalette().setTitle(title);
    }

    public void setMessage(String text) {
        if (text == "") {
            text = " ";
        }
        this.messageLabel.setText(text);
    }

    private static class PalettePosition {
        private Point lastLocation;
        private Location preferredLocation = Location.BELOW;

        private PalettePosition() {
        }

        public void position(final GhostPalette palette, JComponent targetComponent) {
            if (this.lastLocation != null) {
                this.lastLocation.x = Math.max(this.lastLocation.x, 0);
                this.lastLocation.y = Math.max(this.lastLocation.y, 0);
                palette.setLocation(this.lastLocation);
            } else {
                Container parentComp;
                Rectangle visibleRect = new Rectangle();
                targetComponent.computeVisibleRect(visibleRect);
                Point componentOrigin = targetComponent.getLocationOnScreen();
                if ((componentOrigin.x < 0 || componentOrigin.y < 0) && targetComponent.getParent() != null && (parentComp = targetComponent.getParent()) instanceof JViewport) {
                    componentOrigin = parentComp.getLocationOnScreen();
                }
                Point location = new Point();
                if (this.preferredLocation == Location.BELOW) {
                    this.positionBelow(location, componentOrigin, visibleRect);
                } else if (this.preferredLocation == Location.ABOVE) {
                    this.positionAbove(palette, location, componentOrigin);
                } else if (this.preferredLocation == Location.CENTERED) {
                    this.positionCentered(palette, location, componentOrigin, visibleRect);
                }
                location.x = Math.max(location.x, 0);
                location.y = Math.max(location.y, 0);
                palette.setLocation(location);
            }
            palette.addAncestorListener(new AncestorRemovedListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    palette.removeAncestorListener(this);
                    lastLocation = palette.getLocation();
                }
            });
        }

        private void positionCentered(GhostPalette palette, Point point, Point origin, Rectangle visibleRect) {
            point.x = Math.max(0, origin.x + visibleRect.width / 2 - palette.getWidth() / 2);
            point.y = Math.max(0, origin.y + visibleRect.height / 2 - palette.getHeight() / 2);
        }

        private void positionBelow(Point point, Point origin, Rectangle visibleRect) {
            point.x = origin.x;
            point.y = origin.y + visibleRect.y + visibleRect.height;
        }

        private void positionAbove(GhostPalette palette, Point point, Point origin) {
            point.x = origin.x;
            point.y = origin.y - palette.getHeight() - 10;
        }
    }

    public static enum Location {
        ABOVE,
        BELOW,
        CENTERED;

    }

    private static abstract class AncestorRemovedListener
    implements AncestorListener {
        private AncestorRemovedListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

