/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticToggleButtonUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.plaf.theme.ThemedButtonUI;
import oracle.javatools.ui.themes.Themes;

public final class ThemedToggleButtonUI
extends PlasticToggleButtonUI {
    private static final int _CORNER_INSET = 3;
    private static final ThemedButtonUI _INSTANCE = new ThemedButtonUI();

    public static ComponentUI createUI(JComponent component) {
        return _INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (Themes.isThemed()) {
            b.setRolloverEnabled(true);
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                b.setBorder(new ButtonBorder(border.getBorderInsets(b)));
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (Themes.isThemed() && c.isOpaque() && !this.isToolBarButton(b) && b.isContentAreaFilled() && c.getBackground() instanceof UIResource) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            this.paintThemeBackground(g, c);
            this.paint(g, c);
            return;
        }
        super.update(g, c);
    }

    protected void paintThemeBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        String state = this._getState(b);
        Themes.getActiveTheme().getStateProperties("commandbutton.center", state).getPainter("bg").paint(g, 3, 0, b.getWidth() - 6, b.getHeight());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (!Themes.isThemed()) {
            super.paintButtonPressed(g, b);
        }
    }

    private String _getState(AbstractButton b) {
        String state = "default";
        if (!b.isEnabled()) {
            state = "disabled";
        }
        if (b.getModel().isArmed() && b.getModel().isPressed()) {
            state = "down";
        } else if (b.getModel().isRollover()) {
            state = "over";
        } else if (b.isFocusPainted() && b.hasFocus()) {
            state = "focus";
        } else if (b.getModel().isSelected()) {
            state = "selected";
        }
        return state;
    }

    private static void drawInnerButtonDecoration(Graphics g, int x, int y, int w, int h, Color baseColor) {
        Color lightColor = ThemedToggleButtonUI.translucentColor(baseColor, 90);
        Color mediumColor = ThemedToggleButtonUI.translucentColor(baseColor, 120);
        Color darkColor = ThemedToggleButtonUI.translucentColor(baseColor, 200);
        g.translate(x, y);
        g.setColor(lightColor);
        g.fillRect(2, 1, w - 4, 1);
        g.setColor(mediumColor);
        g.fillRect(1, 2, 1, h - 4);
        g.fillRect(w - 2, 2, 1, h - 4);
        ThemedToggleButtonUI.drawRect(g, 2, 2, w - 5, h - 5);
        g.setColor(darkColor);
        g.fillRect(2, h - 2, w - 4, 1);
        g.translate(-x, -y);
    }

    private static void drawRect(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w + 1, 1);
        g.fillRect(x, y + 1, 1, h);
        g.fillRect(x + 1, y + h, w, 1);
        g.fillRect(x + w, y + 1, 1, h);
    }

    private static Color translucentColor(Color baseColor, int alpha) {
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private Insets _inset;

        public ButtonBorder(Insets inset) {
            this._inset = inset;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            String state = ThemedToggleButtonUI.this._getState(b);
            Themes.getActiveTheme().getStateProperties("commandbutton.edge1", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
            Themes.getActiveTheme().getStateProperties("commandbutton.edge2", state).getPainter("bg").paint(g, 0, 0, b.getWidth(), b.getHeight());
            if (model.isEnabled() && (!model.isPressed() || !model.isArmed()) && !b.getModel().isSelected() && b.isFocusPainted() && b.hasFocus()) {
                ThemedToggleButtonUI.drawInnerButtonDecoration(g, x, y, w, h, PlasticLookAndFeel.getFocusColor());
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this._inset;
        }
    }
}

