/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class FlatToolBarUI
extends ToolBarUI {
    private final ToolBarUI _delegate = (ToolBarUI)UIManager.getUI(new JToolBar());
    private final Map<AbstractButton, Map<String, Object>> _oldButtonProperties = new HashMap<AbstractButton, Map<String, Object>>();
    private ContainerListener _containerListener;
    private final PropertyChangeListener _buttonPropertyChangeListener = new ButtonChangeListener();

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this._delegate.contains(c, x, y);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this._delegate.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this._delegate.getAccessibleChildrenCount(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this._delegate.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this._delegate.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this._delegate.getPreferredSize(c);
    }

    @Override
    public void installUI(JComponent c) {
        this._delegate.installUI(c);
        JToolBar toolBar = (JToolBar)c;
        this.installDefaults(toolBar);
        this.installListeners(toolBar);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this._delegate.paint(g, c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this._delegate.uninstallUI(c);
        JToolBar toolBar = (JToolBar)c;
        this.uninstallListeners(toolBar);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this._delegate.update(g, c);
    }

    private void installDefaults(JToolBar toolBar) {
        if (toolBar.getBorder() == null || toolBar.getBorder() instanceof UIResource) {
            toolBar.setBorder(BorderFactory.createEmptyBorder());
        }
        toolBar.setOpaque(false);
        toolBar.setRollover(false);
    }

    private void installListeners(JToolBar toolBar) {
        this._containerListener = new ToolBarContainerListener();
        toolBar.addContainerListener(this._containerListener);
    }

    private void uninstallListeners(JToolBar toolBar) {
        toolBar.removeContainerListener(this._containerListener);
        this._containerListener = null;
    }

    private void customizeButton(AbstractButton button) {
        HashMap<String, Object> buttonProperties = new HashMap<String, Object>();
        buttonProperties.put("border", button.getBorder());
        buttonProperties.put("borderPainted", button.isBorderPainted());
        buttonProperties.put("contentAreaFilled", button.isContentAreaFilled());
        buttonProperties.put("opaque", button.isOpaque());
        buttonProperties.put("cursor", button.getCursor());
        this._oldButtonProperties.put(button, buttonProperties);
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        IconicButtonUI.updateCursor(button);
        button.addPropertyChangeListener("enabled", this._buttonPropertyChangeListener);
    }

    private void decustomizeButton(AbstractButton button) {
        button.removePropertyChangeListener("enabled", this._buttonPropertyChangeListener);
    }

    private static final class ButtonChangeListener
    implements PropertyChangeListener {
        private ButtonChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IconicButtonUI.updateCursor((AbstractButton)evt.getSource());
        }
    }

    private class ToolBarContainerListener
    implements ContainerListener {
        private ToolBarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof AbstractButton) {
                FlatToolBarUI.this.customizeButton((AbstractButton)e.getChild());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof AbstractButton) {
                FlatToolBarUI.this.decustomizeButton((AbstractButton)e.getChild());
            }
        }
    }
}

