/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.builders.BasicBuilder;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.BuiltListImpl;
import oracle.javatools.ui.builders.SearchableList;
import oracle.javatools.ui.list.GenericCheckListCellRenderer;
import oracle.javatools.ui.list.ListChecker;
import oracle.javatools.ui.list.ListEditor;
import oracle.javatools.ui.list.ReflectiveCheckListCellRenderer;
import oracle.javatools.ui.list.ReflectiveListCellRenderer;
import oracle.javatools.ui.list.RolloverRenderer;
import oracle.javatools.ui.list.SimpleListModel;

public final class ListBuilder<T>
extends BasicBuilder<T> {
    private ListInstructions listInstructions;

    @Override
    protected BasicBuilder.Instructions createInstructions() {
        this.listInstructions = new ListInstructions();
        return this.listInstructions;
    }

    public void setModel(T[] array) {
        for (T t : array) {
            this.listInstructions.list.add(t);
        }
    }

    public void setModel(List<? extends T> list) {
        this.listInstructions.list.addAll(list);
    }

    public void setVisibleRows(int visibleRows) {
        this.listInstructions.visibleRows = visibleRows;
    }

    public void setReorderable(boolean reorderable) {
        this.listInstructions.reorder = reorderable;
    }

    public void setSorter(Comparator<T> comparator) {
        this.listInstructions.sorted = true;
        this.listInstructions.comparator = comparator;
    }

    public void setHint(String hint) {
        this.listInstructions.hint = hint;
    }

    public void setSortable(boolean sortable) {
        this.listInstructions.sorted = sortable;
    }

    public void setEditable(boolean editable, boolean createDefaultButtons) {
        this.listInstructions.editable = editable;
        this.listInstructions.editableDefaultButtons = createDefaultButtons;
        if (createDefaultButtons) {
            this.listInstructions.titlebar = true;
        }
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.listInstructions.renderer = renderer;
    }

    public void setRenderUsingMethod(String methodName) {
        this.listInstructions.renderUsingMethod = methodName;
    }

    public void setActionsDefault(DefaultAction defaultAction, ActionListener listener) {
        this.instructions.titlebar = true;
        this.listInstructions.defaultActionMap.put(defaultAction, listener);
    }

    public void setIconFromMethod(String methodName) {
        this.listInstructions.iconFromMethod = methodName;
    }

    public void setSelectionMode(int selectionMode) {
        this.listInstructions.selectionMode = selectionMode;
    }

    public BuiltList<T> build() {
        if (this.listInstructions.sorted && this.listInstructions.list != null) {
            Collections.sort(this.listInstructions.list, this.listInstructions.comparator);
        }
        final SimpleListModel model = new SimpleListModel(this.listInstructions.list);
        final SearchableList list = new SearchableList(model);
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                final int i0 = e.getIndex0();
                final int i1 = e.getIndex1();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (list.getSelectionMode() == 0) {
                            list.setSelectionInterval(i0, i0);
                        } else {
                            list.setSelectionInterval(i0, i1);
                        }
                    }
                });
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                final int sel = Math.min(e.getIndex0(), list.getModel().getSize() - 1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        list.setSelectedIndex(sel);
                    }
                });
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        list.setVisibleRowCount(this.listInstructions.visibleRows);
        if (this.listInstructions.checkedItems != null) {
            new ListChecker(list, this.listInstructions.checkedItems);
        }
        if (this.listInstructions.editable) {
            final ListEditor listEditor = new ListEditor(list);
            if (this.listInstructions.editableDefaultButtons) {
                this.listInstructions.defaultActionMap.put(DefaultAction.ADD, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row = model.getSize();
                        model.insertAt(row, "");
                        list.getSelectionModel().setSelectionInterval(row, row);
                        listEditor.edit(row);
                    }
                });
                this.listInstructions.defaultActionMap.put(DefaultAction.DELETE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.removeIndices(list.getSelectedIndices());
                    }
                });
            }
        }
        list.setSelectionMode(this.listInstructions.selectionMode);
        this.buildRenderer(list);
        this.buildInitialSelection(list);
        if (this.listInstructions.doubleClickListener != null) {
            list.addMouseListener(new DoubleClickL(this.listInstructions.doubleClickListener));
        }
        BuiltListImpl builtList = new BuiltListImpl(list, this.listInstructions);
        this.buildToolbar(builtList);
        this.buildSelectionEnabled(list);
        builtList.getEmptyTextLayer().setText(this.listInstructions.emptyText);
        builtList.getEmptyTextLayer().setFont(this.listInstructions.emptyTextFont);
        return builtList;
    }

    private void buildRenderer(JList<T> list) {
        ListCellRenderer<Object> renderer = null;
        if (this.listInstructions.renderer != null) {
            renderer = this.listInstructions.renderer;
        } else if (this.listInstructions.checkedItems != null) {
            renderer = this.listInstructions.renderUsingMethod == null ? new GenericCheckListCellRenderer<T>(){

                @Override
                public void formatCheckBox(JCheckBox checkBox, JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                    checkBox.setText(value.toString());
                    checkBox.setSelected(ListBuilder.this.listInstructions.checkedItems.contains(value));
                }
            } : new ReflectiveCheckListCellRenderer<T>(this.listInstructions.renderUsingMethod){

                @Override
                public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                    JCheckBox cb = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    cb.setSelected(ListBuilder.this.listInstructions.checkedItems.contains(value));
                    return cb;
                }
            };
        } else if (this.listInstructions.renderUsingMethod != null) {
            renderer = new ReflectiveListCellRenderer(this.listInstructions.renderUsingMethod);
        }
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        if (this.listInstructions.rollover && !(renderer instanceof RolloverRenderer)) {
            renderer = new RolloverRenderer(list, renderer);
        }
        if (renderer instanceof JLabel) {
            ((JLabel)((Object)renderer)).setMinimumSize(new Dimension(4, 16));
        }
        list.setCellRenderer(renderer);
    }

    private void buildInitialSelection(JList list) {
        if (list.getModel().getSize() > 0) {
            if (this.listInstructions.selection != null) {
                for (Object t : this.listInstructions.selection) {
                    for (int i = 0; i < list.getModel().getSize(); ++i) {
                        if (!list.getModel().getElementAt(i).equals(t)) continue;
                        list.addSelectionInterval(i, i);
                    }
                }
            } else {
                list.setSelectedIndex(0);
            }
        }
    }

    private void buildSelectionEnabled(JList list) {
        if (this.listInstructions.selectionEnabledComponents.isEmpty() && this.listInstructions.selectionEnabledActions.isEmpty()) {
            return;
        }
        list.addListSelectionListener(new EnabledSelectionL(this.listInstructions.selectionEnabledComponents, this.listInstructions.selectionEnabledActions));
        for (JComponent component : this.listInstructions.selectionEnabledComponents) {
            component.setEnabled(list.getSelectedIndex() != -1);
        }
        for (Action action : this.listInstructions.selectionEnabledActions) {
            action.setEnabled(list.getSelectedIndex() != -1);
        }
    }

    protected void buildToolbar(BuiltList builtList) {
        if (this.instructions.titlebar && !this.listInstructions.defaultActionMap.isEmpty()) {
            ControlBar controlBar = builtList.getComponentWithTitlebar().getControlBar();
            for (DefaultAction defaultAction : DefaultAction.values()) {
                if (!this.listInstructions.defaultActionMap.containsKey((Object)defaultAction)) continue;
                final Action action = defaultAction.buildAction(this.listInstructions.defaultActionMap.get((Object)defaultAction));
                controlBar.add(action);
                if (defaultAction.isSelectionEnabled()) {
                    this.setSelectionEnabledAction(action);
                }
                final JList list = builtList.getJList();
                list.addPropertyChangeListener("enabled", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        action.setEnabled(list.isEnabled());
                    }
                });
            }
        }
        super.buildToolbar(builtList);
    }

    final class ListInstructions
    extends BasicBuilder.Instructions {
        List<T> list = new ArrayList();
        int selectionMode = 0;
        boolean reorder = false;
        ListCellRenderer<T> renderer = null;
        int visibleRows = 8;
        boolean editable = false;
        boolean editableDefaultButtons = false;
        String hint;
        String renderUsingMethod;
        String iconFromMethod;
        boolean sorted;
        Comparator<T> comparator;
        private Map<DefaultAction, ActionListener> defaultActionMap = new HashMap<DefaultAction, ActionListener>();

        ListInstructions() {
        }
    }

    public static enum DefaultAction {
        ADD,
        NEW,
        EDIT,
        DELETE,
        REMOVE,
        BROWSE,
        CLEAR;


        protected String getTooltip() {
            switch (this) {
                case ADD: {
                    return UIBundle.get("TOOLBAR_ADD_ACTION_TOOLTIP");
                }
                case DELETE: {
                    return UIBundle.get("TOOLBAR_DELETE_ACTION_TOOLTIP");
                }
                case NEW: {
                    return UIBundle.get("TOOLBAR_NEW_ACTION_TOOLTIP");
                }
                case EDIT: {
                    return UIBundle.get("TOOLBAR_EDIT_ACTION_TOOLTIP");
                }
                case REMOVE: {
                    return UIBundle.get("TOOLBAR_REMOVE_ACTION_TOOLTIP");
                }
                case CLEAR: {
                    return UIBundle.get("TOOLBAR_CLEAR_ACTION_TOOLTIP");
                }
                case BROWSE: {
                    return UIBundle.get("TOOLBAR_BROWSE_ACTION_TOOLTIP");
                }
            }
            return null;
        }

        protected Icon getIcon() {
            switch (this) {
                case ADD: {
                    return OracleIcons.getIcon((String)"add.png");
                }
                case NEW: {
                    return OracleIcons.getIcon((String)"add.png");
                }
                case DELETE: {
                    return OracleIcons.getIcon((String)"delete.png");
                }
                case REMOVE: {
                    return OracleIcons.getIcon((String)"delete.png");
                }
                case BROWSE: {
                    return OracleIcons.getIcon((String)"lov.png");
                }
                case EDIT: {
                    return OracleIcons.getIcon((String)"edit.png");
                }
                case CLEAR: {
                    return OracleIcons.getIcon((String)"clear.png");
                }
            }
            return null;
        }

        protected boolean isSelectionEnabled() {
            switch (this) {
                case DELETE: 
                case EDIT: 
                case REMOVE: {
                    return true;
                }
            }
            return false;
        }

        protected Action buildAction(final ActionListener listener) {
            AbstractAction action = new AbstractAction(null, this.getIcon()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    e = new ActionEvent(e.getSource(), e.getID(), this.toString());
                    listener.actionPerformed(e);
                }
            };
            action.putValue("ShortDescription", this.getTooltip());
            return action;
        }
    }

    private static class DoubleClickL
    extends MouseAdapter {
        private ActionListener listener;

        private DoubleClickL(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            JList list;
            if (e.getClickCount() == 2 && (list = (JList)e.getSource()).getCellBounds(i = list.locationToIndex(e.getPoint()), i).contains(e.getPoint())) {
                this.listener.actionPerformed(new ActionEvent(list, 1001, "Double Click"));
            }
        }
    }

    private static class EnabledSelectionL
    implements ListSelectionListener {
        private Collection<JComponent> components;
        private Collection<Action> actions;

        private EnabledSelectionL(Collection<JComponent> components, Collection<Action> actions) {
            this.components = components;
            this.actions = actions;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList list = (JList)e.getSource();
            for (JComponent component : this.components) {
                component.setEnabled(list.isEnabled() && list.getSelectedIndex() != -1);
            }
            for (Action action : this.actions) {
                action.setEnabled(list.isEnabled() && list.getSelectedIndex() != -1);
            }
        }
    }
}

