/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class ShadowGradient
implements PaintContext {
    private Color _color;
    private int _shadeSize;
    private Rectangle _rect;
    private double _multiplier;

    ShadowGradient(Rectangle rect, Color color, int shadeSize, double shadeIntensity) {
        this._shadeSize = shadeSize;
        this._color = color;
        this._rect = rect;
        this._multiplier = shadeIntensity * 255.0 / (double)this._shadeSize;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int width, int height) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(width, height);
        int rectX = this._rect.x;
        int rectY = this._rect.y;
        int rectWidth = this._rect.width;
        int rectHeight = this._rect.height;
        int red = this._color.getRed();
        int green = this._color.getGreen();
        int blue = this._color.getBlue();
        int[] data = new int[width * height * 4];
        int dataPos = 0;
        for (int yPos = 0; yPos < height; ++yPos) {
            int thisY = y + yPos;
            for (int xPos = 0; xPos < width; ++xPos) {
                int thisX = x + xPos;
                int outcode = this._rect.outcode(thisX, thisY);
                double alpha = ((double)this._shadeSize - (switch (outcode) {
                    case 0 -> 0.0;
                    case 3 -> Math.min((double)this._shadeSize, Point.distance(rectX, rectY, thisX, thisY));
                    case 2 -> rectY - thisY;
                    case 6 -> Math.min((double)this._shadeSize, Point.distance(rectX + rectWidth, rectY, thisX, thisY));
                    case 1 -> rectX - thisX;
                    case 4 -> thisX - (rectX + rectWidth);
                    case 9 -> Math.min((double)this._shadeSize, Point.distance(rectX, rectY + rectHeight, thisX, thisY));
                    case 8 -> thisY - (rectY + rectHeight);
                    case 12 -> Math.min((double)this._shadeSize, Point.distance(rectX + rectWidth, rectY + rectHeight, thisX, thisY));
                    default -> 0.0;
                })) * this._multiplier;
                int base = dataPos++ << 2;
                data[base + 0] = red;
                data[base + 1] = green;
                data[base + 2] = blue;
                data[base + 3] = (int)alpha;
            }
        }
        raster.setPixels(0, 0, width, height, data);
        return raster;
    }
}

