/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.util.Pair;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Namespace;

class GenerationSettings {
    private final Context context;
    private final Namespace attributes;
    private final List<Pair<Character, String>> escapesList;

    GenerationSettings(Context context, Namespace namespace, String string) {
        this.context = context;
        this.attributes = namespace;
        if (string != null) {
            int n;
            this.escapesList = new ArrayList<Pair<Character, String>>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n2 = stringTokenizer.countTokens();
            if (n2 != 2 * (n = n2 / 2)) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "an odd number of substitution components specified: ''{0}", string);
            }
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() > 1) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "escapes key should be a single character: ''{0}", string2);
                }
                String string3 = stringTokenizer.nextToken();
                this.escapesList.add((Pair<Character, String>)new Pair((Object)Character.valueOf(string2.charAt(0)), (Object)string3));
            }
        } else {
            this.escapesList = null;
        }
    }

    Context getContext() {
        return this.context;
    }

    Namespace getAttributes() {
        return this.attributes;
    }

    String processEscapes(String string) {
        if (this.escapesList != null) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                boolean bl = false;
                for (Pair<Character, String> pair : this.escapesList) {
                    if (c != ((Character)pair.getKey()).charValue()) continue;
                    stringBuilder.append((String)pair.getValue());
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

