/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commitgraph;

import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.HistoryGraphEntryProducer;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.historygraph.HighLightListener;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCommitHistoryGraph;
import oracle.jdevimpl.vcs.git.commitgraph.GITCommitGraphMenuListener;
import oracle.jdevimpl.vcs.git.commitgraph.GITGraphController;
import oracle.jdevimpl.vcs.git.commitgraph.GITHighLightListener;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITHistoryGraphEntryProducer
implements HistoryGraphEntryProducer {
    public static final String GIT_SYNC_MENU = "git.sync-graph-commit-history";
    private GITCommitGraphMenuListener _menuListener;
    private GITGraphController _controller;
    private GITHighLightListener _highLightListener;

    public GraphNode[] produceEntries(URL url, LocalDate ldate) throws VCSException {
        GitClient client = null;
        try {
            URL root = GITUtil.getRootContaining(url);
            ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            SearchCriteria sc = new SearchCriteria();
            sc.setFollowRenames(true);
            sc.setIncludeMerges(true);
            sc.setFrom(Date.from(ldate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            sc.setFiles(new File[]{new File(root.getPath())});
            GitRevisionInfo[] infos = client.log(sc, false, monitor);
            HashMap<String, GraphNode> gdata = new HashMap<String, GraphNode>();
            GitRevisionInfo head = client.log("HEAD", (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_ERROR", URLFileSystem.getPlatformPathName((URL)url)), monitor.getError());
            }
            for (GitRevisionInfo info : infos) {
                GraphNode gNode = new GraphNode(info.getRevision(), Long.valueOf(info.getCommitTime()));
                gNode.setAuthor(info.getAuthor().getName());
                gNode.setDescription(info.getFullMessage());
                if (info.getRevision().equals(head.getRevision())) {
                    gNode.setHead(true);
                }
                gdata.put(info.getRevision(), gNode);
                nodes.add(gNode);
            }
            for (GitRevisionInfo info : infos) {
                String rev = info.getRevision();
                GraphNode node = (GraphNode)gdata.get(rev);
                for (String parent : info.getParents()) {
                    GraphNode pNode = (GraphNode)gdata.get(parent);
                    if (pNode == null) continue;
                    node.addParent(pNode);
                }
            }
            GitRevisionInfo[] gitRevisionInfoArray = nodes.toArray(new GraphNode[0]);
            return gitRevisionInfoArray;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCommitHistoryGraph.class.getName()).warning("Commit Hist Graph " + e.getMessage());
            throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_ERROR", URLFileSystem.getPlatformPathName((URL)url)), e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public URL[] getURLs(URL root, String revision) throws VCSException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            SearchCriteria sc = new SearchCriteria();
            sc.setRevisionFrom(revision);
            sc.setRevisionTo(revision);
            sc.setFiles(new File[]{new File(root.getPath())});
            GitRevisionInfo[] infos = client.log(sc, false, monitor);
            if (monitor.getError() != null) {
                throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_FILES_ERROR", revision), monitor.getError());
            }
            if (infos.length >= 1) {
                Map<File, GitRevisionInfo.GitFileInfo> files = infos[0].getModifiedFiles();
                ArrayList urls = new ArrayList();
                files.keySet().forEach(e -> urls.add(URLFactory.newFileURL((File)e.getAbsoluteFile())));
                URL[] uRLArray = urls.toArray(new URL[0]);
                return uRLArray;
            }
        }
        catch (GitException e2) {
            GITProfile.getQualifiedLogger(GITOperationCommitHistoryGraph.class.getName()).warning("Commit History Graph " + e2.getMessage());
            throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_FILES_ERROR", revision), e2.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    public String getBranchLabelFor(URL root, GraphNode node) throws VCSException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            SearchCriteria sc = new SearchCriteria();
            sc.setRevisionFrom(node.getRevId());
            sc.setRevisionTo(node.getRevId());
            GitRevisionInfo[] infos = client.log(sc, true, monitor);
            if (monitor.getError() != null) {
                throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_LABEL_ERROR", node.getRevId()), monitor.getError());
            }
            for (GitRevisionInfo info : infos) {
                Map<String, GitBranch> branches = info.getBranches();
                for (String key : branches.keySet()) {
                    GitBranch branch = branches.get(key);
                    if (branch.isRemote()) continue;
                    String string = branch.getName();
                    return string;
                }
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCommitHistoryGraph.class.getName()).warning("Commit History Graph " + e.getMessage());
            throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_LABEL_ERROR", node.getRevId()), e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    public String getCommitLabel(URL root) throws VCSException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branch");
            Map<String, GitBranch> branches = client.getBranches(false, monitor);
            if (monitor.getError() != null) {
                throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_COMMIT_ERROR", URLFileSystem.getPlatformPathName((URL)root)), monitor.getError());
            }
            for (String key : branches.keySet()) {
                GitBranch branch = branches.get(key);
                if (!branch.isActive()) continue;
                if (branch.getTrackedBranch() != null) {
                    monitor.setOperation("log");
                    int activeDiff = this.getCommitDiff(client, branch.getTrackedBranch().getName(), branch.getName(), monitor);
                    if (monitor.getError() != null) {
                        throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_COMMIT_ERROR", URLFileSystem.getPlatformPathName((URL)root)), monitor.getError());
                    }
                    int trackDiff = this.getCommitDiff(client, branch.getName(), branch.getTrackedBranch().getName(), monitor);
                    if (monitor.getError() != null) {
                        throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_COMMIT_ERROR", URLFileSystem.getPlatformPathName((URL)root)), monitor.getError());
                    }
                    if (activeDiff > 0 && trackDiff > 0) {
                        StringBuilder sb = new StringBuilder(Resource.format("BRANCH_LABEL", branch.getName(), branch.getTrackedBranch().getName()));
                        sb.append(Resource.format("BRANCH_LABEL_INFO1", activeDiff, trackDiff));
                        String string = sb.toString();
                        return string;
                    }
                    if (activeDiff < 1) {
                        String sb = Resource.format("BRANCH_LABEL", branch.getName(), branch.getTrackedBranch().getName());
                        return sb;
                    }
                    StringBuilder sb = new StringBuilder(Resource.format("BRANCH_LABEL", branch.getName(), branch.getTrackedBranch().getName()));
                    sb.append(Resource.format("BRANCH_LABEL_INFO3", activeDiff));
                    String string = sb.toString();
                    return string;
                }
                String string = Resource.format("BRANCH_LABEL_NO_TRACK", branch.getName());
                return string;
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCommitHistoryGraph.class.getName()).warning("Commit History Graph " + e.getMessage());
            throw new VCSDetailException(Resource.get("HISTORY_GRAPH_ERROR_TITLE"), Resource.format("HISTORY_GRAPH_COMMIT_ERROR", URLFileSystem.getPlatformPathName((URL)root)), e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return "";
    }

    private int getCommitDiff(GitClient client, String from, String to, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitRevisionInfo[] info;
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionFrom(from);
        sc.setRevisionTo(to);
        GitRevisionInfo revisionInfo = client.log(from, (ProgressMonitor)monitor);
        for (GitRevisionInfo rInfo : info = client.log(sc, false, monitor)) {
            if (!rInfo.getRevision().equals(revisionInfo.getRevision())) continue;
            return info.length - 1;
        }
        return info.length;
    }

    public ContextMenuListener getContextMenuListener() {
        if (this._menuListener == null) {
            this._menuListener = new GITCommitGraphMenuListener();
        }
        return this._menuListener;
    }

    public HighLightListener getHighLightListener() {
        if (this._highLightListener == null) {
            this._highLightListener = new GITHighLightListener();
        }
        return this._highLightListener;
    }

    private Controller getController() {
        if (this._controller == null) {
            this._controller = new GITGraphController();
        }
        return this._controller;
    }
}

