/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITFileListener;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITCheckoutCustomizer;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITOperationCheckout
extends GITExtendedAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.checkout";
    private URL _root;

    public GITOperationCheckout() {
        super(COMMAND_ID);
    }

    public GITOperationCheckout(String command) {
        super(command);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getLocatableFromNavOrProfile(profile);
    }

    protected String getDialogTitle() {
        return Resource.get("CHECKOUT_DLG_TITLE");
    }

    protected String getHelpTopicId() {
        return "f1_git_checkout_revision_html";
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        try {
            Locatable[] locatables = this.getOperands(this.getProfile());
            if (locatables.length > 0) {
                this._root = locatables[0].getURL();
                String branch = null;
                if (locatables[0] instanceof GITExtendedAbstractOperation.GITNode) {
                    branch = ((GITExtendedAbstractOperation.GITNode)locatables[0])._branch;
                }
                Map<String, Object> defaultOpts = this.getBranchRevisionOptions(this._root, branch, false);
                GITCheckoutCustomizer customizer = new GITCheckoutCustomizer();
                customizer.setOptions(defaultOpts);
                return customizer;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITOperationCheckout.class.getName()).log(Level.WARNING, "Checkout Operation failed ", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String createBranch = (String)options.get("Git-create-branch");
        String revision = (String)options.get("Git-use-revision");
        String branch = (String)options.get("Git-use-branch");
        String tag = (String)options.get("Git-use-tag");
        URL root = (URL)options.get("Git-local-root");
        String branchName = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CHECKOUT_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("CHECK_OUT_PROGRESS_TITLE"), (Object)Resource.get("CHECK_OUT_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        progress.start();
        try {
            if (!createBranch.isEmpty()) {
                branchName = this.createBranch(createBranch, revision, cancellable, monitor);
                if (cancellable.isCancelled()) {
                    throw new VCSCancelException();
                }
            }
            String string = branch = branch == null ? tag : branch;
            String chBranch = branchName != null ? branchName : (branchName == null && GITUtil.isLatest(root, branch, revision) ? branch : revision);
            Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
            Collection<URL> process = this.checkout(chBranch, cancellable, monitor);
            if (cancellable.isCancelled()) {
                throw new VCSCancelException();
            }
            processed.addAll(process);
            commandState.setProperty("git.structure-changed", process);
            commandState.setProperty("Git.label-change", this.getProjectUrls());
        }
        finally {
            monitor.logCompleted();
            progress.finish();
        }
        return true;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Project[] prjs;
        super.postInvoke(profile, commandState);
        for (Project prj : prjs = VCSModelUtils.findCachedProjects()) {
            profile.getPolicyStatusCache().clear(prj.getURL());
        }
    }

    private Collection<URL> checkout(String branchName, VCSCancellable cancel, GITCommandProgressMonitor monitor) throws GITProcessException {
        GitClient client = null;
        monitor.setLog(true);
        monitor.setCancellable(cancel);
        GITFileListener listener = new GITFileListener();
        try {
            client = GITClientAdaptor.getClient(this._root);
            client.addNotificationListener(listener);
            client.checkoutRevision(branchName, true, monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CHECKOUT_ERROR"), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCheckout.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CHECKOUT_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.removeNotificationListener(listener);
                client.release();
            }
        }
        return listener.getProcessedFiles();
    }

    private String createBranch(String branchName, String revision, VCSCancellable cancel, GITCommandProgressMonitor monitor) throws Exception {
        monitor.setLog(true);
        monitor.setCancellable(cancel);
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(this._root);
            GitBranch gBranch = client.createBranch(branchName, revision, monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("CHECKOUT_CREATE_BRANCH_FAILED", branchName), monitor.getError());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITRepositoryNavigator.getInstance().updateNavigator(GITOperationCheckout.this._root, false);
                }
            });
            String string = gBranch.getName();
            return string;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCheckout.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.format("CHECKOUT_CREATE_BRANCH_FAILED", branchName), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private Collection<URL> getProjectUrls() {
        ArrayList<URL> prjUrl = new ArrayList<URL>();
        if (Ide.getActiveWorkspace() != null && Ide.getActiveWorkspace().isOpen()) {
            Collection projects = Ide.getActiveWorkspace().projects();
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                prjUrl.add(((Project)it.next()).getURL());
            }
        }
        return prjUrl;
    }
}

