/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITOverlayItemProducer;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITRunnable;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;

public abstract class GITAbstractOperation
extends ActionCommand {
    public static final String COMMIT_NOT_STAGE = "commit-not-staged";
    public static final String USER_DETAILS = "user-details";
    public static final String COMMIT_AUTHOR = "commit-author";
    public static final String COMMIT_COMMITER = "commit-commiter";
    public static final String REM_AUTHORS = "remember-authors";
    public static final String REM_COMMITERS = "remember-commiters";
    protected static final String PROPERTY_STRUCTURE_CHANGED = "git.structure-changed";
    protected static final String PROPERTY_LABEL_CHANGE = "Git.label-change";
    private URLFilter _ignoreFilter;

    protected GITAbstractOperation(String commandId) {
        super(commandId);
    }

    protected GITAbstractOperation(String commandId, VCSCommandStyle style) {
        super(commandId);
        this.initializeCommandStyle(style);
    }

    protected GITAbstractOperation(String commandId, int type, VCSCommandStyle style) {
        super(commandId, type);
        this.initializeCommandStyle(style);
    }

    protected GITAbstractOperation(String commandId, int type, String name, VCSCommandStyle style) {
        super(commandId, type, name);
        this.initializeCommandStyle(style);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        VCSDirectoryInvokable invokable = this.createDirectoryInvokable(profile, commandState, options);
        invokable.setProgressMonitor(this.createProgressMonitor(parentUi));
        return invokable.runInvokable();
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        VCSDirectoryInvokable invokable = this.createDirectoryInvokable(profile, commandState, options);
        return invokable.runInvokable();
    }

    protected VCSDirectoryInvokable createDirectoryInvokable(VCSProfile profile, CommandState commandState, Map options) {
        return null;
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return null;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        this.setCommandSpecificCustomizerOptions(profile, customizer);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                return GITAbstractOperation.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), null, (Component)VCSComponents.createFileListerComponent((Collection)nodes, (TableCellRenderer)this.createFileListerRenderer()), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        return dialog;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        String hint = this.getDialogHint();
        JEWTDialog dialog = this.createOperationDialogImpl(nodes, customizer, commandState);
        if (hint != null && !hint.isEmpty()) {
            DialogHeader header = new DialogHeader();
            header.setHeaderDescription(hint);
            dialog.setDialogHeader((Component)header);
        }
        return dialog;
    }

    protected TableCellRenderer createFileListerRenderer() {
        return null;
    }

    protected Node[] getCachedNodesForRecursiveContext() throws Exception {
        return VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])this.getOperands(this.getProfile()))));
    }

    protected void closeMissingNodes(Object[] nodes) throws IOException {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = (Node)nodes[i];
            URL url = VCSModelUtils.getLocatableURL((Object)node);
            if (url == null || URLFileSystem.exists((URL)url) || !node.isOpen()) continue;
            node.close();
        }
    }

    protected final Locatable[] getChangeListWindowOperands() throws Exception {
        Context context = Context.newIdeContext();
        context.setSelection(((ChangeListWindow)this.getContext().getView()).getContextChangeList().getElements());
        Collection filtered = this.getActionInfo().getFilteredSelection(context);
        return VCSModelUtils.findOrCreateNodes((URL[])VCSModelUtils.convertNodesToURLs((Collection)filtered));
    }

    protected int saveDirtyNodesUI(Locatable[] locatables) throws Exception {
        try {
            if (!this.saveDirtyNodes(locatables)) {
                return 1;
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ioe, (String)IdeUtil.getProgramName(), (String)ioe.getMessage(), null);
            return -1;
        }
        return 0;
    }

    protected void setProcessedUrls(CommandState command, URL[] urls) {
        Collection<URL> cl = this.getProcessedUrlsNotifier(command);
        for (URL url : urls) {
            cl.add(url);
        }
    }

    protected Collection<URL> getProcessedUrlsNotifier(CommandState commandState) {
        ArrayList cl = (ArrayList)commandState.getProperty("git.processed.urls");
        if (cl == null) {
            cl = new ArrayList();
            commandState.setProperty("git.processed.urls", cl);
        }
        return cl;
    }

    protected void postInvoke(VCSProfile profile, final CommandState commandState) throws Exception {
        Collection eventUrls;
        if (commandState == null) {
            return;
        }
        Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
        if (processed.isEmpty()) {
            super.postInvoke(profile, commandState);
            return;
        }
        URL[] urls = processed.toArray(new URL[processed.size()]);
        profile.getPolicyStatusCache().clear(urls);
        Collection lblUrl = (Collection)commandState.getProperty(PROPERTY_LABEL_CHANGE);
        if (lblUrl != null) {
            URL[] lUrls = lblUrl.toArray(new URL[lblUrl.size()]);
            profile.getPolicyStatusCache().clear(lUrls);
            GITOverlayItemProducer.clearVersion(lUrls);
        }
        if (processed.size() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffers((Map)commandState.getTimestampMap());
                }
            });
        }
        if ((eventUrls = (Collection)commandState.getProperty(PROPERTY_STRUCTURE_CHANGED)) != null && !eventUrls.isEmpty()) {
            this.fireFileStructureChanged(eventUrls.toArray(new URL[0]));
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    protected Locatable[] getRootOperand(VCSProfile profile) throws Exception {
        Locatable[] loc = super.getOperands(profile);
        if (loc.length > 0) {
            URL root = GITUtil.getRootContaining(loc[0].getURL());
            Node node = new Node(root){

                public Icon getIcon() {
                    return OracleIcons.getIcon((String)"folder.png");
                }
            };
            return new Locatable[]{node};
        }
        return loc;
    }

    protected URL getGitClientRoot(VCSProfile profile) throws Exception {
        URL url;
        Locatable[] locatables = this.getOperands(profile);
        if (locatables.length == 0) {
            if (this.getContext().getNode() != null) {
                url = GITNavURLFileSystemHelper.fromNavigatorURL(this.getContext().getNode().getURL());
                if (this.getContext().getNode() instanceof GITRemote) {
                    return url;
                }
            } else {
                url = this.getContext().getWorkspace().getURL();
            }
        } else {
            url = locatables[0].getURL();
        }
        URL root = GITUtil.getRootContaining(url);
        return root;
    }

    protected String getCurrentBranch(URL url) throws GITProcessException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
            monitor.setLog(false);
            Map<String, GitBranch> branches = client.getBranches(false, monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CURRENT_BRANCH_ERROR"), monitor.getError());
            }
            GitBranch activeBranch = GITUtil.getActiveBranch(branches);
            String string = activeBranch == null || activeBranch.getName().equals("(no branch)") ? null : activeBranch.getName();
            return string;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITAbstractOperation.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CURRENT_BRANCH_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected Collection<Locatable> findFolders(VCSProfile profile) {
        Locatable[] loctable = VCSContextUtils.getContextLocatables((Context)this.context, (URLFilter)profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT"));
        ArrayList<Locatable> locs = new ArrayList<Locatable>();
        for (Locatable loc : loctable) {
            if (!URLFileSystem.isDirectoryPath((URL)loc.getURL())) continue;
            locs.add(loc);
        }
        return locs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<Locatable> getFilteredCollection(URL[] root, GITStatusFilter filter, VCSCancellable cancel) throws Exception {
        ArrayList<Locatable> locatables = new ArrayList<Locatable>();
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root[0]);
            Collection<File> files = GITUtil.convertURLToFile(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
            monitor.setCancellable(cancel);
            monitor.setLog(false);
            Map<File, GitStatus> stats = client.getStatus(files.toArray(new File[0]), monitor);
            for (File file : stats.keySet()) {
                GitStatus stat = stats.get(file);
                URL url = URLFactory.newFileURL((File)file);
                if ((!filter.useGlobalIgnore() || !filter.accept(stat) || this.getIgnoreFilter().accept(url)) && (filter.useGlobalIgnore() || !filter.accept(stat))) continue;
                locatables.add((Locatable)NodeFactory.findOrCreate((URL)url));
            }
            ArrayList<Locatable> arrayList = locatables;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected void updateProgress(IndeterminateProgressMonitor progress, String msg) {
        if (progress != null) {
            progress.getPanel().setNote(msg);
        }
    }

    protected void getFilteredCollectionWithProgress(Collection<Locatable> locs, Collection<Locatable> locurls, GITStatusFilter filter, String title, String msg) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Locatable loc : locurls) {
            urls.add(loc.getURL());
        }
        this.getFilteredCollectionWithProgress(locs, urls.toArray(new URL[0]), filter, title, msg);
    }

    protected void getFilteredCollectionWithProgress(final Collection<Locatable> locs, final URL[] urls, final GITStatusFilter filter, String title, String msg) throws Exception {
        GITRunnable run = new GITRunnable(){

            @Override
            public void runImpl() throws Exception {
                locs.addAll(GITAbstractOperation.this.getFilteredCollection(urls, filter, this.getCancellable()));
            }
        };
        final ProgressBar progress = new ProgressBar((Component)Ide.getMainWindow(), title, (Runnable)run, true);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.hasUserCancelled();
            }
        };
        progress.setCancelable(true);
        run.setProgress(progress);
        run.setCancellable(cancellable);
        progress.start(msg, "", 500);
        if (run.hasException()) {
            throw run.getException();
        }
        if (progress.hasUserCancelled()) {
            locs.clear();
            throw new VCSCancelException();
        }
    }

    protected int saveNodesIfDirty(Locatable[] locatables) throws Exception {
        try {
            if (!this.saveDirtyNodes(locatables)) {
                return 1;
            }
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ioe, (String)IdeUtil.getProgramName(), (String)ioe.getMessage(), null);
            return -1;
        }
        return 0;
    }

    protected boolean saveURL(URL ignoreURL) throws Exception {
        Node node = NodeFactory.find((URL)ignoreURL);
        if (node == null) {
            return true;
        }
        Locatable[] save = new Locatable[]{node};
        return this.saveNodesIfDirty(save) == 0;
    }

    private URLFilter getIgnoreFilter() {
        if (this._ignoreFilter == null) {
            this._ignoreFilter = new IgnoreFilter();
        }
        return this._ignoreFilter;
    }

    protected Collection<URL> getModifiedFiles(GITCommandProgressMonitor monitor, GitClient client, URL root) throws GitException {
        Map<File, GitStatus> status = client.getStatus(new File[]{new File(root.getPath())}, monitor);
        HashSet<URL> updated = new HashSet<URL>();
        for (File file : status.keySet()) {
            GitStatus gStat = status.get(file);
            if (gStat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_NORMAL) || GlobalIgnoreList.isGloballyIgnored((URL)URLFactory.newFileURL((File)file))) continue;
            updated.add(URLFactory.newFileURL((File)file));
        }
        return updated;
    }

    private class IgnoreFilter
    implements URLFilter {
        private IgnoreFilter() {
        }

        public boolean accept(URL url) {
            if (GlobalIgnoreList.isGloballyIgnored((URL)url)) {
                return true;
            }
            String value = System.getProperty("git-candidate-include-class");
            return value == null && (URLFileSystem.hasSuffix((URL)url, (String)".class") || url.getPath().contains("/classes/"));
        }
    }

    protected abstract class DirectoryInvokable
    extends VCSDirectoryInvokable {
        DirectoryInvokable(VCSDirectoryInvokableState state) {
            super((VCSInvokableState)state, 10, false);
        }
    }
}

