/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartController;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizard;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;

public class DbCartDropListener
implements DropTargetListener {
    JEWTDialog _dialog;
    private boolean _isAdd = false;
    private URL _dataUrl;
    private URL _stateUrl;
    private int _stateType;

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            DataFlavor[] dataFlavorArray;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
                Object object;
                if (dataFlavor.isFlavorJavaFileListType()) {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (object != null) {
                        var9_10 = object.iterator();
                        while (var9_10.hasNext()) {
                            var10_11 = (File)var9_10.next();
                            this.handleFileDropped(((File)var10_11).toURI().toURL());
                        }
                    }
                } else if (dataFlavor.equals(TransferableContext.contextFlavor) && (object = transferable.getTransferData(dataFlavor)) instanceof TransferableContext) {
                    var9_10 = (TransferableContext)transferable.getTransferData(dataFlavor);
                    for (Object object2 : var10_11 = var9_10.getContext().getSelection()) {
                        Object object3;
                        Object object4;
                        if (object2 instanceof ObjectNode || object2 instanceof PlSqlNode) {
                            Connection connection;
                            object4 = (DatabaseNode)object2;
                            object3 = object2 instanceof ObjectNode ? ((ObjectNode)object2).getConnectionName() : (object2 instanceof PlSqlNode ? ((PlSqlNode)object2).getConnectionName() : "");
                            DDLTypes dDLTypes = new DDLTypes();
                            dDLTypes.setApex(true);
                            dDLTypes.setApexPage(false);
                            dDLTypes.setShowApex(true);
                            dDLTypes.setShowApexPage(false);
                            DBObject dBObject = new DBObject((Element)object2);
                            String string = dBObject.getObjectType();
                            if (dDLTypes.isSupportedType(string)) {
                                DbCartUtil.getTableModel().addRow(new DBObject((Element)object4), (String)object3);
                            } else {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, DbCartAddinArb.format("DROP_TYPE_ERROR", string, dBObject.getObjectName()));
                            }
                            if (!string.equals("PACKAGE") || !ExtractReconciler.isExistsObject((Connection)(connection = Connections.getInstance().getConnection((String)object3)), (String)dBObject.getSchemaName(), (String)dBObject.getObjectName(), (String)(string + " BODY"))) continue;
                            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)object3, null, (String)dBObject.getSchemaName(), (String)"PACKAGE+BODY");
                            URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)dBObject.getObjectName());
                            DbCartUtil.getTableModel().addRow(new DBObject(uRL2), (String)object3);
                            continue;
                        }
                        if (!(object2 instanceof TextNode)) continue;
                        object3 = (TextNode)object2;
                        object4 = object3.getURL();
                        this.handleFileDropped((URL)object4);
                    }
                }
                DbCartController.getInstance().toggleToolbar();
            }
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    private void handleFileDropped(URL uRL) {
        if (!URLFileSystem.isDirectory((URL)uRL) && URLFileSystem.isLocal((URL)uRL) && DbCartUtil.isCartFileType(uRL) && this.showFileDropped(uRL)) {
            ExtractObject extractObject = DbCartUtil.getTableModel().addDataFileRow(uRL);
            int n = DbCartUtil.getTableModel().getRowCount() - 1;
            extractObject.setConfigUrl(this._stateUrl);
            DataWizard dataWizard = new DataWizard();
            Context context = new Context();
            context.setProperty("DATA_WIZARD_CONFIG_URL", (Object)this._stateUrl);
            context.setProperty("DATA_WIZARD_FILE_URL", (Object)this._dataUrl);
            context.setProperty("DATA_WIZARD_CONFIG_TYPE", (Object)this._stateType);
            context.setProperty("DATA_WIZARD_IS_CART", (Object)true);
            context.setProperty("DATA_WIZARD_IS_DROP", (Object)true);
            context.setProperty("DATA_WIZARD_EXTRACT_OBJECT", (Object)extractObject);
            dataWizard.setContext(context);
            if (!dataWizard.runDialog()) {
                DbCartUtil.getTableModel().removeRow(n);
            }
        }
    }

    private boolean showFileDropped(URL uRL) {
        int n;
        this._isAdd = false;
        this._dataUrl = null;
        String string = uRL.getFile();
        String string2 = string.substring((n = string.lastIndexOf(".")) + 1);
        if (string2.equals("sdimp")) {
            this._stateType = 1;
            this._stateUrl = uRL;
            return true;
        }
        this._dataUrl = uRL;
        String string3 = string.substring(0, n) + "_" + string.substring(n + 1, string.length()) + ".sdimp";
        File file = new File(string3);
        boolean bl = file.exists();
        String string4 = file.getParent();
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        jTextPane.setText(DbCartAddinArb.format("STATE_INSTRUCTIONS", uRL.toExternalForm()));
        final JRadioButton jRadioButton = new JRadioButton();
        JRadioButton jRadioButton2 = new JRadioButton();
        JRadioButton jRadioButton3 = new JRadioButton();
        jRadioButton3.setEnabled(false);
        JLabel jLabel = new JLabel(DbCartAddinArb.getString("STATE_OPTION"));
        ResourceUtils.resButton((AbstractButton)jRadioButton, (String)DbCartAddinArb.getString("STATE_SELECTED"));
        ResourceUtils.resButton((AbstractButton)jRadioButton2, (String)DbCartAddinArb.getString("STATE_NEW"));
        ResourceUtils.resButton((AbstractButton)jRadioButton3, (String)DbCartAddinArb.getString("AUTO_CONFIG"));
        jRadioButton3.setToolTipText(DbCartAddinArb.getString("AUTO_CONFIG_TIP"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        final URLFileChooser.URLFileChooserPanel uRLFileChooserPanel = URLFileChooser.createURLFileChooserPanel((int)0, (String)"", (boolean)false, (boolean)false);
        uRLFileChooserPanel.setPathContext(this.getClass().getName() + "_configChooser");
        uRLFileChooserPanel.clearChooseableURLFilters();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(DataImportArb.getString((String)"CONFIG_FILE_TYPE"), "sdimp");
        uRLFileChooserPanel.setFileFilter((FileFilter)fileNameExtensionFilter);
        File file2 = new File(string4);
        if (!file2.exists()) {
            string4 = System.getProperty("user.home");
            file2 = new File(string4);
        }
        uRLFileChooserPanel.setText(string4);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (jRadioButton.isSelected()) {
                    uRLFileChooserPanel.setEnabled(true);
                } else {
                    uRLFileChooserPanel.setEnabled(false);
                }
            }
        };
        jRadioButton.addItemListener(itemListener);
        jRadioButton2.addItemListener(itemListener);
        jRadioButton3.addItemListener(itemListener);
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        if (bl) {
            try {
                uRLFileChooserPanel.setSelectedURL(file.toURI().toURL());
                jRadioButton.setSelected(true);
            }
            catch (Exception exception) {
                jRadioButton2.setSelected(true);
            }
        } else {
            jRadioButton2.setSelected(true);
        }
        jPanel.add((Component)jRadioButton, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        jPanel2.add((Component)uRLFileChooserPanel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jRadioButton2, LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        JPanel jPanel3 = LayoutControl.GBC.createSubPanel((Component)jPanel);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        JPanel jPanel4 = LayoutControl.GBC.createPanel();
        jPanel4.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel4.add((Component)jPanel3, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SUB_PANEL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel4, (int)2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "Center");
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel5, "f1_choose_config_html");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel5, null, (String)DbCartAddinArb.getString("CHOOSE_STATE_FILE"), (int)7);
        Dimension dimension = jPanel4.getPreferredSize();
        int n2 = (int)dimension.getHeight() + 200;
        int n3 = (int)dimension.getWidth() + 300;
        jEWTDialog.setSize(n3, n2);
        jEWTDialog.setPreferredSize(n3, n2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.runDialog();
        if (jEWTDialog.isOked()) {
            this._isAdd = true;
            if (jRadioButton.isSelected()) {
                this._stateType = 1;
                try {
                    this._stateUrl = uRLFileChooserPanel.getSelectedURL();
                }
                catch (Exception exception) {}
            } else if (jRadioButton2.isSelected()) {
                this._stateType = 1;
                this._stateUrl = null;
            } else {
                this._stateType = 3;
            }
            jEWTDialog.dispose();
        }
        return this._isAdd;
    }
}

