/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.UpdateableUI;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.options.Settings;

public class DataTypeCellEditor
extends JDialog {
    private final String KEY_ESCAPE = "ESCAPE";
    public static final String EMPTY_STRING = "";
    private JTextArea textArea;
    private boolean cancel = false;
    private DesignObject designObject;
    private JScrollPane sp;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JCheckBox chbReference;
    private JPanel dataTypeAdditionalPanel;
    private JComboBox cbUnits;
    private JPanel sizeAndUnitsPanel;
    private JPanel precisionAndScalePanel;
    private JPanel referencePanel;
    private JPanel dataTypePanel;
    private JComboBox cbDatatype;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List currentPreferredDomainList = new ArrayList();
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private Domain currentSelectedDomain = null;
    private boolean initialUseDomainPreferredList = true;
    private boolean initialUseLogicalTypePreferredList = true;
    private LogicalDatatype currentSelectedLogical = null;
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(DataTypeCellEditor.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DataTypeCellEditor.this.cancel = true;
            DataTypeCellEditor.this.close();
        }
    };

    public DataTypeCellEditor(Dialog owner, int row, int col, JTable table, final UpdateableUI updateable) {
        super(owner);
        int h;
        int w;
        this.appView = ApplicationView.getInstance();
        this.setUndecorated(true);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent arg0) {
                if (!DataTypeCellEditor.this.cancel) {
                    DataTypeCellEditor.this.setDataType();
                    if (updateable != null) {
                        updateable.update(DataTypeCellEditor.this.designObject);
                    }
                    DataTypeCellEditor.this.close();
                }
            }
        });
        Object element = table.getValueAt(row, col);
        if (element instanceof ContainedObjectWithDomain) {
            this.designObject = (ContainedObjectWithDomain)table.getValueAt(row, col);
        } else if (element instanceof TypeElement) {
            this.designObject = (TypeElement)table.getValueAt(row, col);
        }
        final Point p = table.getLocationOnScreen();
        final Rectangle rec = table.getCellRect(row, col, true);
        this.initDataTypePanel();
        this.initProperties();
        Settings.DialogSettings ds = this.appView.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            w = this.getMinimumWidth();
            h = this.getMinimumHeight();
            this.setBounds(p.x + rec.x, p.y + rec.y, w, h);
        } else {
            w = Math.max(rec.width, ds.rec.width);
            h = Math.max(60, ds.rec.height);
            this.setBounds(p.x + rec.x, p.y + rec.y, w, h);
        }
        this.getContentPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = DataTypeCellEditor.this.sp.getWidth();
                int h = DataTypeCellEditor.this.sp.getHeight();
                w = Math.max(DataTypeCellEditor.this.getMinimumWidth(), w);
                h = Math.max(DataTypeCellEditor.this.getMinimumHeight(), h);
                DataTypeCellEditor.this.setBounds(p.x + rec.x, p.y + rec.y, w, h);
            }
        });
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
    }

    public void initProperties() {
        if (this.designObject instanceof ContainedObjectWithDomain) {
            short use = ((ContainedObjectWithDomain)this.designObject).getUse();
            switch (use) {
                case 0: {
                    this.rbDomain.setSelected(true);
                    break;
                }
                case 1: {
                    this.rbLogical.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbDistinct.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbStructured.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbCollection.setSelected(true);
                    break;
                }
                default: {
                    this.rbDomain.setSelected(true);
                    break;
                }
            }
        } else if (this.designObject instanceof TypeElement) {
            TypeElement te = (TypeElement)this.designObject;
            if (te.getType() instanceof Domain) {
                this.rbDomain.setSelected(true);
            } else if (te.getType() instanceof LogicalDatatype) {
                this.rbLogical.setSelected(true);
            } else if (te.getType() instanceof DistinctType) {
                this.rbDistinct.setSelected(true);
            } else if (te.getType() instanceof StructuredType) {
                this.rbStructured.setSelected(true);
            } else if (te.getType() instanceof CollectionType) {
                this.rbCollection.setSelected(true);
            } else {
                this.rbDomain.setSelected(true);
            }
        }
    }

    private void initDataTypePanel() {
        RBListener l = new RBListener();
        this.rbDomain = new JRadioButton("Domain");
        this.rbLogical = new JRadioButton("Logical");
        this.rbDistinct = new JRadioButton("Distinct");
        this.rbStructured = new JRadioButton("Structured");
        this.rbCollection = new JRadioButton("Collection");
        this.rbDomain.addItemListener(l);
        this.rbLogical.addItemListener(l);
        this.rbDistinct.addItemListener(l);
        this.rbStructured.addItemListener(l);
        this.rbCollection.addItemListener(l);
        ButtonGroup datatypeGroup = new ButtonGroup();
        datatypeGroup.add(this.rbDomain);
        datatypeGroup.add(this.rbLogical);
        datatypeGroup.add(this.rbDistinct);
        datatypeGroup.add(this.rbStructured);
        datatypeGroup.add(this.rbCollection);
        JPanel pnRadioGroup = new JPanel(new GridLayout(2, 3, 6, 0));
        pnRadioGroup.add(this.rbDomain);
        pnRadioGroup.add(this.rbLogical);
        pnRadioGroup.add(this.rbDistinct);
        pnRadioGroup.add(this.rbStructured);
        pnRadioGroup.add(this.rbCollection);
        this.sizeAndUnitsPanel = new JPanel((LayoutManager)new MigLayout(EMPTY_STRING, "[70!][100!]", "0[]10[]0"));
        this.precisionAndScalePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_STRING, "[70!][100!]", "0[]10[]0"));
        this.referencePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_STRING, "[70!][100!]", "0[]0"));
        JLabel lbType = new JLabel("Type");
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setMaximumRowCount(20);
        JLabel lbPreferred = new JLabel("Preferred");
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        JLabel lbSize = new JLabel(AbstractPropertiesDialog.LB_SIZE);
        this.ifDTSize = new JTextField();
        JLabel lbUnits = new JLabel("Units");
        lbUnits.setHorizontalAlignment(2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.sizeAndUnitsPanel.add(lbSize);
        this.sizeAndUnitsPanel.add((Component)this.ifDTSize, new CC().grow().wrap());
        this.sizeAndUnitsPanel.add(lbUnits);
        this.sizeAndUnitsPanel.add((Component)this.cbUnits, new CC().width("60!"));
        ActionListener cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeCellEditor.this.updateDataTypePanelOptions();
            }
        };
        this.cbDatatype.addActionListener(cbDatatypeActionListener);
        JLabel lbPrecision = new JLabel(AbstractPropertiesDialog.LB_PRECISION);
        lbPrecision.setHorizontalAlignment(2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setAllowAsterisks(true);
        JLabel lbScale = new JLabel(AbstractPropertiesDialog.LB_SCALE);
        lbScale.setHorizontalAlignment(2);
        this.ifDTScale = new JIntegerField();
        this.precisionAndScalePanel.add(lbPrecision);
        this.precisionAndScalePanel.add((Component)this.ifDTPrecision, new CC().grow().wrap());
        this.precisionAndScalePanel.add(lbScale);
        this.precisionAndScalePanel.add((Component)this.ifDTScale, new CC().grow());
        this.chbReference = new JCheckBox("Reference");
        this.referencePanel.add(new JLabel());
        this.referencePanel.add(this.chbReference);
        this.dataTypePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_STRING, "[70!][]", "10[]10[]0"));
        this.dataTypePanel.setBorder(BorderFactory.createEtchedBorder());
        this.dataTypePanel.add(new JLabel());
        this.dataTypePanel.add((Component)pnRadioGroup, new CC().spanX().wrap());
        this.dataTypePanel.add(lbType);
        this.dataTypePanel.add((Component)this.cbDatatype, new CC().width("180!"));
        this.dataTypePanel.add(lbPreferred);
        this.dataTypePanel.add((Component)this.chbUsePreferredList, new CC().wrap());
        this.dataTypeAdditionalPanel = new JPanel((LayoutManager)new MigLayout(EMPTY_STRING, "0[110!][120!]0", "0[]0[]0"));
        this.sp = new JScrollPane(this.dataTypePanel);
        this.getContentPane().add(this.sp);
    }

    private void updateDataTypePanelOptions() {
        block55: {
            try {
                this.ifDTSize.setText(EMPTY_STRING);
                this.ifDTPrecision.setText(EMPTY_STRING);
                this.ifDTScale.setText(EMPTY_STRING);
                this.cbUnits.setSelectedIndex(0);
                this.cbUnits.setEnabled(false);
                this.dataTypePanel.remove(this.dataTypeAdditionalPanel);
                this.dataTypePanel.updateUI();
                this.dataTypeAdditionalPanel.removeAll();
                this.dataTypeAdditionalPanel.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
                Object obj = this.cbDatatype.getSelectedItem();
                if (obj == null) break block55;
                if (obj instanceof LogicalDatatype) {
                    String size;
                    LogicalDatatype selected = (LogicalDatatype)obj;
                    Map defaults = selected.getLTDefaultValues();
                    if (defaults != null) {
                        this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                        this.sizeDefaultValue = (String)defaults.get("size_default_value");
                        this.scaleDefaultValue = (String)defaults.get("scale_default_value");
                    }
                    Map<String, String> m = selected.getToPhysical();
                    MDDataType datatype = null;
                    if (this.designObject instanceof ContainedObjectWithDomain) {
                        datatype = selected.createDataType(((ContainedObjectWithDomain)this.designObject).getContainerWithKeyObject().getSelectedRDBMSType().getName(), m);
                    } else if (this.designObject instanceof TypeElement) {
                        datatype = selected.createDataType(((TypeElement)this.designObject).getStructuredType().getSelectedRDBMSType().getName(), m);
                    }
                    if (datatype instanceof MDImplicitSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                        this.ifDTPrecision.setEnabled(false);
                        this.ifDTScale.setText(this.scaleDefaultValue);
                        this.ifDTScale.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = false;
                    } else if (datatype instanceof MDPackedSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                        try {
                            if (datatype.getPrecision() != 0) {
                                this.ifDTPrecision.setText(datatype.getPrecisionStr());
                            }
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.getScale() != 0) {
                                this.ifDTScale.setText(EMPTY_STRING + datatype.getScale());
                            }
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    } else {
                        try {
                            if (datatype.hasSize()) {
                                if (!datatype.getSize().equalsIgnoreCase("0")) {
                                    this.cbUnits.setEnabled(true);
                                    size = datatype.getSize();
                                    String[] parts_n = size.split(" ");
                                    this.ifDTSize.setText(parts_n[0]);
                                    if (parts_n.length == 2) {
                                        this.cbUnits.setSelectedItem(parts_n[1]);
                                    }
                                } else {
                                    this.ifDTSize.setText(this.sizeDefaultValue);
                                    this.cbUnits.setEnabled(true);
                                }
                                this.ifDTSize.setEnabled(true);
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.sizeAndUnitsPanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = true;
                                this.precisionEnabled = false;
                            } else {
                                this.ifDTSize.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTSize.setEnabled(false);
                        }
                        try {
                            if (datatype.hasPrecision()) {
                                if (datatype.getPrecision() != 0) {
                                    this.ifDTPrecision.setText(datatype.getPrecisionStr());
                                }
                                this.ifDTPrecision.setEnabled(true);
                                if (this.ifDTPrecision.getText().trim().length() == 0) {
                                    this.ifDTPrecision.setText(this.precisionDefaultValue);
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTPrecision.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.hasScale()) {
                                if (datatype.getScale() != 0) {
                                    this.ifDTScale.setText(EMPTY_STRING + datatype.getScale());
                                }
                                this.ifDTScale.setEnabled(true);
                                if (this.ifDTScale.getText().trim().length() == 0) {
                                    this.ifDTScale.setText(this.scaleDefaultValue);
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTScale.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    }
                    size = EMPTY_STRING;
                    String precision = EMPTY_STRING;
                    String scale = EMPTY_STRING;
                    if (this.designObject instanceof ContainedObjectWithDomain) {
                        ContainedObjectWithDomain co = (ContainedObjectWithDomain)this.designObject;
                        size = co.getDataTypeParameter("size");
                        precision = co.getDataTypeParameter("precision");
                        scale = co.getDataTypeParameter("scale");
                        String units = EMPTY_STRING;
                        String[] parts_n = size.split(" ");
                        if (parts_n.length == 2) {
                            size = parts_n[0];
                            units = parts_n[1];
                        }
                        if (this.ifDTSize.isEnabled()) {
                            try {
                                this.ifDTSize.setText(size != null && size != EMPTY_STRING ? size : null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.ifDTPrecision.isEnabled()) {
                            try {
                                this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != EMPTY_STRING ? precision : null));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.ifDTScale.isEnabled()) {
                            try {
                                this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != EMPTY_STRING ? scale : null));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.cbUnits.isEnabled()) {
                            this.cbUnits.setSelectedItem(units);
                        }
                        break block55;
                    }
                    if (this.designObject instanceof TypeElement) {
                        TypeElement te = (TypeElement)this.designObject;
                        size = te.getSize();
                        precision = Integer.toString(te.getPrecision());
                        scale = Integer.toString(te.getScale());
                    }
                    break block55;
                }
                if (obj instanceof StructuredType) {
                    this.dataTypeAdditionalPanel.removeAll();
                    if (this.designObject instanceof ContainedObjectWithDomain) {
                        this.chbReference.setSelected(((ContainedObjectWithDomain)this.designObject).isReference());
                    } else if (this.designObject instanceof TypeElement) {
                        this.chbReference.setSelected(((TypeElement)this.designObject).isReference());
                    }
                    this.dataTypeAdditionalPanel.add(this.referencePanel);
                    this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                    this.dataTypePanel.updateUI();
                }
            }
            catch (Exception e) {
                LOGGER.error("updateLogicalDatatypeOptions() ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeComboBox_COD() {
        block58: {
            try {
                ContainedObjectWithDomain cod = (ContainedObjectWithDomain)this.designObject;
                this.cbDatatype.removeAllItems();
                this.dataTypePanel.updateUI();
                if (this.rbDomain.isSelected()) {
                    Domain selDomain = null;
                    if (this.designObject != null) {
                        selDomain = cod.getDomain();
                    }
                    if (selDomain == null) {
                        selDomain = this.designObject.getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.appView.getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain domain : pDomains) {
                                if (selDomain == null) continue;
                                if (!domain.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        boolean currentAdded = false;
                        for (Object e : allPreferredDomains) {
                            if (e == this.currentSelectedDomain) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        if (this.currentSelectedDomain != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedDomain);
                        }
                        this.appView.getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.designObject.getDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.appView.getSettings().setUsePreferredDomains(false);
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    break block58;
                }
                if (this.rbLogical.isSelected()) {
                    try {
                        this.selLogicalDatatype = null;
                        if (this.designObject != null) {
                            this.selLogicalDatatype = cod.getLogicalDatatype();
                        }
                        if (this.initialUseLogicalTypePreferredList) {
                            this.chbUsePreferredList.setSelected(this.appView.getSettings().isUsePreferredLogicalTypes());
                            this.initialUseLogicalTypePreferredList = false;
                        }
                        if (this.chbUsePreferredList.isSelected()) {
                            ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                            List pLogicalDatatypes = this.getCurrentPreferredLogicalDatatypes();
                            allPreferredLogicalDatatypes.addAll(pLogicalDatatypes);
                            if (pLogicalDatatypes.size() > 0) {
                                for (LogicalDatatype ldt : pLogicalDatatypes) {
                                    if (this.selLogicalDatatype == null) continue;
                                    if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                        this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                        continue;
                                    }
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                        this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                    }
                                    break;
                                }
                            } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            }
                            allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                            boolean currentAdded = false;
                            for (Object e : allPreferredLogicalDatatypes) {
                                if (e == this.currentSelectedLogical) {
                                    currentAdded = true;
                                }
                                this.cbDatatype.addItem(e);
                                if (this.logicalDefaultDataType == null) {
                                    this.logicalDefaultDataType = e;
                                }
                                if (!e.toString().equalsIgnoreCase("unknown")) continue;
                                this.logicalDefaultDataType = e;
                            }
                            if (this.currentSelectedLogical != null && !currentAdded) {
                                this.cbDatatype.addItem(this.currentSelectedLogical);
                            }
                            this.appView.getSettings().setUsePreferredLogicalTypes(true);
                            break block58;
                        }
                        Iterator it = this.designObject.getDesign().getLogicalDatatypeSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = obj;
                        }
                        this.appView.getSettings().setUsePreferredLogicalTypes(false);
                        break block58;
                    }
                    finally {
                        this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    }
                }
                if (this.rbDistinct.isSelected()) {
                    Iterator it = this.designObject.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    DistinctType selDistinctType = null;
                    if (this.designObject != null) {
                        selDistinctType = cod.getDistinctType();
                    }
                    if (selDistinctType != null) {
                        this.cbDatatype.setSelectedItem(selDistinctType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbStructured.isSelected()) {
                    Iterator it = this.designObject.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    StructuredType selStructuredType = null;
                    if (this.designObject != null) {
                        selStructuredType = cod.getStructuredType();
                    }
                    if (selStructuredType != null) {
                        this.cbDatatype.setSelectedItem(selStructuredType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbCollection.isSelected()) {
                    Iterator it = this.designObject.getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    CollectionType selCollectionType = null;
                    if (this.designObject != null) {
                        selCollectionType = cod.getCollectionType();
                    }
                    if (selCollectionType != null) {
                        this.cbDatatype.setSelectedItem(selCollectionType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("updateDTComboBox_COD() ", e);
            }
        }
    }

    private void updateDataTypeComboBox_TE() {
        try {
            TypeElement te = (TypeElement)this.designObject;
            this.cbDatatype.removeAllItems();
            this.dataTypePanel.updateUI();
            if (this.rbDomain.isSelected()) {
                Domain selDomain = null;
                if (te != null) {
                    selDomain = te.getDomain();
                }
                if (selDomain == null) {
                    selDomain = te.getDesign().getDomainSet().getDefaultDomain();
                }
                if (this.initialUseDomainPreferredList) {
                    this.chbUsePreferredList.setSelected(this.appView.getSettings().isUsePreferredDomains());
                    this.initialUseDomainPreferredList = false;
                }
                if (this.chbUsePreferredList.isSelected()) {
                    ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                    List pDomains = this.getCurrentPreferredDomains();
                    allPreferredDomains.addAll(pDomains);
                    if (pDomains.size() > 0) {
                        for (Domain ldt : pDomains) {
                            if (selDomain == null) continue;
                            if (!ldt.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                this.additionalPreferredDomains.add(selDomain);
                                continue;
                            }
                            if (this.additionalPreferredDomains.contains(selDomain)) {
                                this.additionalPreferredDomains.remove(selDomain);
                            }
                            break;
                        }
                    } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                        this.additionalPreferredDomains.add(selDomain);
                    }
                    allPreferredDomains.addAll(this.additionalPreferredDomains);
                    boolean currentAdded = false;
                    for (Object e : allPreferredDomains) {
                        if (e == this.currentSelectedDomain) {
                            currentAdded = true;
                        }
                        this.cbDatatype.addItem(e);
                        if (this.domainDefaultDataType == null) {
                            this.domainDefaultDataType = e;
                        }
                        if (!e.toString().equalsIgnoreCase("unknown")) continue;
                        this.domainDefaultDataType = e;
                    }
                    if (this.currentSelectedDomain != null && !currentAdded) {
                        this.cbDatatype.addItem(this.currentSelectedDomain);
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    this.appView.getSettings().setUsePreferredDomains(true);
                } else {
                    Iterator it = te.getDesign().getDomainSet().iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        this.cbDatatype.addItem(obj);
                        if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                        this.domainDefaultDataType = obj;
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    this.appView.getSettings().setUsePreferredDomains(false);
                }
            } else if (this.rbLogical.isSelected()) {
                String size = EMPTY_STRING;
                int precision = 0;
                int scale = 0;
                String units = EMPTY_STRING;
                this.selLogicalDatatype = null;
                if (te != null) {
                    if (te.getType() instanceof Domain) {
                        this.selLogicalDatatype = ((Domain)te.getType()).getLogicalDatatype();
                    } else if (te.getType() instanceof LogicalDatatype) {
                        this.selLogicalDatatype = (LogicalDatatype)te.getType();
                    }
                    size = te.getSize();
                    precision = te.getPrecision();
                    scale = te.getScale();
                    units = te.getUnits();
                }
                if (this.initialUseLogicalTypePreferredList) {
                    this.chbUsePreferredList.setSelected(this.appView.getSettings().isUsePreferredLogicalTypes());
                    this.initialUseLogicalTypePreferredList = false;
                }
                if (this.chbUsePreferredList.isSelected()) {
                    ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                    List list = this.getCurrentPreferredLogicalDatatypes();
                    allPreferredLogicalDatatypes.addAll(list);
                    if (list.size() > 0) {
                        for (LogicalDatatype ldt : list) {
                            if (this.selLogicalDatatype == null) continue;
                            if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                continue;
                            }
                            if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                            }
                            break;
                        }
                    } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                        this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                    }
                    allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                    boolean currentAdded = false;
                    for (Object e : allPreferredLogicalDatatypes) {
                        if (e == this.currentSelectedLogical) {
                            currentAdded = true;
                        }
                        this.cbDatatype.addItem(e);
                        if (this.logicalDefaultDataType == null) {
                            this.logicalDefaultDataType = e;
                        }
                        if (!e.toString().equalsIgnoreCase("unknown")) continue;
                        this.logicalDefaultDataType = e;
                    }
                    if (this.currentSelectedLogical != null && !currentAdded) {
                        this.cbDatatype.addItem(this.currentSelectedLogical);
                    }
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    this.appView.getSettings().setUsePreferredLogicalTypes(true);
                } else {
                    Iterator it = te.getDesign().getLogicalDatatypeSet().iterator();
                    while (it.hasNext()) {
                        Object e = it.next();
                        this.cbDatatype.addItem(e);
                        if (!e.toString().equalsIgnoreCase("unknown")) continue;
                        this.logicalDefaultDataType = e;
                    }
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    this.appView.getSettings().setUsePreferredLogicalTypes(false);
                }
                if (this.ifDTSize.isEnabled() && !size.equals(EMPTY_STRING)) {
                    try {
                        this.ifDTSize.setText(size);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTPrecision.isEnabled() && precision > 0) {
                    try {
                        this.ifDTPrecision.setValue((long)precision);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTScale.isEnabled() && scale > 0) {
                    try {
                        this.ifDTScale.setValue((long)scale);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.cbUnits.isEnabled()) {
                    this.cbUnits.setSelectedItem(units);
                }
            } else if (this.rbDistinct.isSelected()) {
                Iterator it = te.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
                this.cbDatatype.setSelectedItem(te.getType());
            } else if (this.rbStructured.isSelected()) {
                Iterator it = te.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
                this.cbDatatype.setSelectedItem(te.getType());
                this.chbReference.setSelected(te.isReference());
            } else if (this.rbCollection.isSelected()) {
                Iterator it = te.getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
                this.cbDatatype.setSelectedItem(te.getType());
            }
            this.cbDatatype.updateUI();
        }
        catch (Exception e) {
            LOGGER.error("updateDTComboBox_TE() ", e);
        }
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.designObject.getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.appView.getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.designObject.getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.appView.getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.appView.getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    private void setDataType() {
        if (this.designObject instanceof ContainedObjectWithDomain) {
            ContainedObjectWithDomain co = (ContainedObjectWithDomain)this.designObject;
            if (this.rbDomain.isSelected()) {
                Object datatype = this.cbDatatype.getSelectedItem();
                if (datatype instanceof Domain) {
                    Domain domain = (Domain)datatype;
                    co.setUse((short)0);
                    if (co.getDomain() != domain) {
                        co.setDomain(domain);
                        if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                            co.setUseDomainConstraints(true);
                        }
                    }
                }
            } else if (this.rbLogical.isSelected()) {
                int scaleDefaultValue;
                co.setDataTypeParameter("size", EMPTY_STRING);
                co.setDataTypeParameter("precision", EMPTY_STRING);
                co.setDataTypeParameter("scale", EMPTY_STRING);
                co.setUse((short)1);
                co.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                String pdf = (String)defaults.get("precision_default_value");
                if (pdf == null) {
                    pdf = EMPTY_STRING;
                }
                String sizeDefaultValue = (String)defaults.get("size_default_value");
                String scdf = (String)defaults.get("scale_default_value");
                int n = scaleDefaultValue = scdf != EMPTY_STRING && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String size = this.ifDTSize.getText();
                    if (!size.equals(EMPTY_STRING) && !size.equals(sizeDefaultValue)) {
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            co.setDataTypeParameter("size", size + " " + this.cbUnits.getSelectedItem());
                        } else {
                            co.setDataTypeParameter("size", size);
                        }
                    } else {
                        co.setDataTypeParameter("size", EMPTY_STRING);
                        co.setDataTypeParameter("precision", EMPTY_STRING);
                        co.setDataTypeParameter("scale", EMPTY_STRING);
                    }
                } else if (this.precisionEnabled) {
                    co.setDataTypeParameter("size", EMPTY_STRING);
                    if (!pdf.equals(this.ifDTPrecision.getText())) {
                        co.setDataTypeParameter("precision", this.ifDTPrecision.getText());
                    } else {
                        co.setDataTypeParameter("precision", EMPTY_STRING);
                    }
                    if (this.ifDTScale.getIntValue() != scaleDefaultValue) {
                        co.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                    } else {
                        co.setDataTypeParameter("scale", EMPTY_STRING);
                    }
                }
            } else if (this.rbDistinct.isSelected()) {
                co.setUse((short)2);
                co.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                if (co.getUse() != 3 || co.isReference() != this.chbReference.isSelected() || co.getStructuredType() == null || !co.getStructuredType().equals(this.cbDatatype.getSelectedItem())) {
                    co.setUse((short)3);
                    co.setReference(this.chbReference.isSelected());
                    co.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
                }
            } else if (this.rbCollection.isSelected()) {
                co.setUse((short)4);
                co.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
            }
        } else if (this.designObject instanceof TypeElement) {
            TypeElement te = (TypeElement)this.designObject;
            if (this.rbDomain.isSelected()) {
                te.setType((Domain)this.cbDatatype.getSelectedItem());
            } else if (this.rbLogical.isSelected()) {
                int scaleDefaultValueInt;
                String pdf;
                te.setType((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                defaults.clear();
                if (this.cbDatatype.getSelectedItem() != null) {
                    defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                }
                int precisionDefaultValueInt = (pdf = (String)defaults.get("precision_default_value")) != EMPTY_STRING && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
                String sizeDefaultValue = (String)defaults.get("size_default_value");
                String scdf = (String)defaults.get("scale_default_value");
                int n = scaleDefaultValueInt = scdf != EMPTY_STRING && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String size = this.ifDTSize.getText();
                    if (!size.equals(EMPTY_STRING) && !size.equals(sizeDefaultValue)) {
                        te.setSize(this.ifDTSize.getText());
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            te.setUnits((String)this.cbUnits.getSelectedItem());
                        }
                    } else {
                        te.setSize(EMPTY_STRING);
                    }
                    te.setPrecision(0);
                    te.setScale(0);
                } else if (this.precisionEnabled) {
                    te.setSize(EMPTY_STRING);
                    if (this.ifDTPrecision.getIntValue() != precisionDefaultValueInt || this.ifDTScale.getIntValue() != scaleDefaultValueInt) {
                        te.setPrecision(this.ifDTPrecision.getIntValue());
                        te.setScale(this.ifDTScale.getIntValue());
                    } else {
                        te.setPrecision(0);
                        te.setScale(0);
                    }
                } else {
                    te.setSize(EMPTY_STRING);
                    te.setPrecision(0);
                    te.setScale(0);
                }
            } else if (this.rbDistinct.isSelected()) {
                te.setType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                te.setType((StructuredType)this.cbDatatype.getSelectedItem());
                te.setReference(this.chbReference.isSelected());
            } else if (this.rbCollection.isSelected()) {
                te.setType((CollectionType)this.cbDatatype.getSelectedItem());
            }
        }
    }

    protected int getMinimumWidth() {
        return 350;
    }

    protected int getMinimumHeight() {
        return 170;
    }

    private class RBListener
    implements ItemListener {
        private RBListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (DataTypeCellEditor.this.designObject instanceof ContainedObjectWithDomain) {
                    DataTypeCellEditor.this.updateDataTypeComboBox_COD();
                } else if (DataTypeCellEditor.this.designObject instanceof TypeElement) {
                    DataTypeCellEditor.this.updateDataTypeComboBox_TE();
                }
                DataTypeCellEditor.this.cbDatatype.updateUI();
            }
            catch (Exception e1) {
                LOGGER.error("RBListener", e1);
            }
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataTypeCellEditor.this.rbDomain.isSelected() || DataTypeCellEditor.this.rbLogical.isSelected()) {
                if (DataTypeCellEditor.this.designObject instanceof ContainedObjectWithDomain) {
                    DataTypeCellEditor.this.updateDataTypeComboBox_COD();
                } else if (DataTypeCellEditor.this.designObject instanceof TypeElement) {
                    DataTypeCellEditor.this.updateDataTypeComboBox_TE();
                }
            }
        }
    }
}

