/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.cwddesigner;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.cwddesigner.CWDDesignObj;
import oracle.dbtools.crest.imports.cwddesigner.CWDExtractionController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.wizards.CustomWizard;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.cwddesigner.CWDOptionDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class CWDExtractionWizard
extends CustomWizard {
    private static final Font fontGrey = new Font("Dialog", 2, 12);
    private static final Font fontBlue = new Font("Dialog", 1, 12);
    private static final String DESCRIPTION_1 = Messages.getString("CWDExtractionWizard.SelectLogicalRelationalModelsToImport");
    private static final String DESCRIPTION_4 = Messages.getString("CWDExtractionWizard.ViewSummaryGenerateDesign");
    private static final String FIRST_PAGE = "FIRST_PAGE";
    private static final String FOURTH_PAGE = "FOURTH_PAGE";
    private static final Logger LOGGER = new Logger(CWDExtractionWizard.class);
    private int taskNbr = 1;
    private JPanel pnMain;
    protected JPanel firstPanel;
    private CardLayout cardLayout = new CardLayout();
    private JTextArea taDescription;
    private JLabel lbTask1;
    private String designName;
    private List lsModels = new ArrayList();
    private JTable tbModels;
    private CWDExtractionController controller;
    private Object[] relationals;
    private List lsTables = new ArrayList();
    protected JTabbedPane tpane;
    private JTable tbTables;
    private JTable tbViews;
    private List lsViews = new ArrayList();
    private JTable tbTypes;
    private List lsTypes = new ArrayList();
    private JLabel taSummary;
    private Object importFile;
    private JTable tbEntities;
    private List lsEntities = new ArrayList();
    private String prefix = "";
    private JPanel fourthPanel;
    private JLabel lbTask4;
    private List lsSubViews = new ArrayList();
    private JTable tbSubViews;

    public CWDExtractionWizard(ApplicationView view, String name) {
        super(view);
        this.designName = name;
    }

    public CWDExtractionWizard(ApplicationView view, File importFile) {
        super(view);
        this.importFile = importFile;
        this.relationals = view.getCurrentDesign().getRelationalDesigns().toArray();
        this.prefix = this.getController().getCustomPrefix();
        this.loadTempDesign();
        this.pnMain.setLayout(this.cardLayout);
        this.firstPanel = this.initFirstTab();
        this.pnMain.add((Component)this.firstPanel, FIRST_PAGE);
        this.fourthPanel = this.initFourthTab();
        this.pnMain.add((Component)this.fourthPanel, FOURTH_PAGE);
        this.handleButtons();
    }

    private void loadTempDesign() {
        try {
            this.getController().loadTempDesign((File)this.getImportFile());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CWDExtractionWizard.UnableToGenerateDesign"), Messages.getString("CWDExtractionWizard.ErrorGenerateDesign"), 0);
            this.doClose();
        }
    }

    private ApplicationView getApplicationView() {
        return this.view;
    }

    @Override
    protected JPanel initMainPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnBanner = new JPanel(new BorderLayout());
        pnBanner.setBackground(Color.WHITE);
        ImageIcon imageIcon = (ImageIcon)GUIConfiguration.getInstance().getIcon("DBM_WIZARD_BANNER");
        pnBanner.add((Component)new JLabel(imageIcon), "West");
        this.taDescription = new JTextArea();
        this.taDescription.setEditable(false);
        this.taDescription.setFont(fontBlue);
        this.taDescription.setBackground(Color.WHITE);
        JPanel pnRight = new JPanel(new FlowLayout(1, 0, 25));
        pnRight.setBackground(Color.WHITE);
        pnRight.add(this.taDescription);
        pnBanner.add((Component)pnRight, "Center");
        jpanel.add((Component)pnBanner, "North");
        JPanel pnTasks = new JPanel(new GridLayout(0, 1));
        pnTasks.setBackground(Color.WHITE);
        pnTasks.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.lbTask1 = new JLabel(Messages.getString("CWDExtractionWizard.SelectModelsToImport"));
        this.lbTask4 = new JLabel(Messages.getString("CWDExtractionWizard.GenerateDesign"));
        pnTasks.add(this.lbTask1);
        pnTasks.add(this.lbTask4);
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.add(new JLabel());
        pnTasks.setPreferredSize(new Dimension(200, 350));
        jpanel.add((Component)pnTasks, "West");
        this.pnMain = new JPanel();
        this.pnMain.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pnMain.setPreferredSize(new Dimension(530, 350));
        jpanel.add((Component)this.pnMain, "Center");
        return jpanel;
    }

    public JPanel initFirstTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsModels = this.initDPObject();
        this.tbModels = new JTable(new DesignPartModel(this.lsModels));
        this.tbModels.setSelectionMode(0);
        TableColumn column = this.tbModels.getColumnModel().getColumn(0);
        column.setPreferredWidth(10);
        column = this.tbModels.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.tbModels.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        column.setCellEditor(new DesignPartComboBoxEditor(this.relationals));
        JScrollPane sp = new JScrollPane(this.tbModels);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        bnSelectAll.setMnemonic(83);
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.lsModels) {
                    odObject.setSelected(true);
                }
                CWDExtractionWizard.this.tbModels.updateUI();
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        JButton bnDeselectAll = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        bnDeselectAll.setMnemonic(68);
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.lsModels) {
                    odObject.setSelected(false);
                }
                CWDExtractionWizard.this.tbModels.updateUI();
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        jpanel.add((Component)pn1, "South");
        this.tbModels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
        });
        this.tbModels.updateUI();
        return jpanel;
    }

    private boolean hasModelSelected() {
        for (CWDDesignObj obj : this.lsModels) {
            if (!obj.isSelected()) continue;
            return true;
        }
        return false;
    }

    private List initDPObject() {
        return this.getController().getDPObject();
    }

    public JPanel initSecondTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tbSubViews = new JTable(new ObjectModel(this.lsSubViews));
        this.tbSubViews.setRowHeight(18);
        this.tbSubViews.setSelectionMode(0);
        TableColumn column = this.tbSubViews.getColumnModel().getColumn(0);
        column.setPreferredWidth(10);
        column = this.tbSubViews.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        column = this.tbSubViews.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        JScrollPane sp = new JScrollPane(this.tbSubViews);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        bnSelectAll.setMnemonic(83);
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.lsSubViews) {
                    odObject.setSelected(true);
                }
                CWDExtractionWizard.this.tbSubViews.updateUI();
            }
        });
        JButton bnDeselectAll = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        bnDeselectAll.setMnemonic(68);
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.lsSubViews) {
                    odObject.setSelected(false);
                }
                CWDExtractionWizard.this.tbSubViews.updateUI();
            }
        });
        Dimension dim = new Dimension(120, 25);
        bnSelectAll.setPreferredSize(dim);
        bnDeselectAll.setPreferredSize(dim);
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        jpanel.add((Component)pn1, "South");
        this.tbSubViews.updateUI();
        return jpanel;
    }

    public JPanel initThirdTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.add((Component)this.getTabbedPane(), "Center");
        this.addTabs();
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = new JButton(Messages.getString("CWDExtractionWizard.SelectAll"));
        bnSelectAll.setMnemonic(83);
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.getCurrentList()) {
                    odObject.setSelected(true);
                }
                CWDExtractionWizard.this.updateTables();
            }
        });
        JButton bnDeselectAll = new JButton(Messages.getString("CWDExtractionWizard.DeselectAll"));
        bnDeselectAll.setMnemonic(68);
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (CWDDesignObj odObject : CWDExtractionWizard.this.getCurrentList()) {
                    odObject.setSelected(false);
                }
                CWDExtractionWizard.this.updateTables();
            }
        });
        JButton bnOptions = new JButton(Messages.getString("CWDExtractionWizard.Options"));
        bnOptions.setMnemonic(79);
        bnOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CWDOptionDialog dialog = new CWDOptionDialog(CWDExtractionWizard.this.getApplicationView());
                dialog.initProperties(CWDExtractionWizard.this.prefix);
                int result = dialog.showDialog();
                if (result == 1) {
                    CWDExtractionWizard.this.getController().setCustomPrefix(dialog.getCustomPrefix());
                }
            }
        });
        Dimension dim = new Dimension(120, 25);
        bnSelectAll.setPreferredSize(dim);
        bnDeselectAll.setPreferredSize(dim);
        bnOptions.setPreferredSize(dim);
        pn1.add(bnSelectAll);
        pn1.add(bnDeselectAll);
        pn1.add(bnOptions);
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    protected JPanel initFourthTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.taSummary = new JLabel();
        this.taSummary.setFont(this.taSummary.getFont().deriveFont(0));
        this.taSummary.setVerticalAlignment(1);
        jpanel.add((Component)this.taSummary, "Center");
        jpanel.add((Component)new JPanel(), "East");
        jpanel.add((Component)new JPanel(), "West");
        jpanel.add((Component)new JPanel(), "North");
        jpanel.add((Component)new JPanel(), "South");
        return jpanel;
    }

    private void updateTables() {
    }

    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsEntities;
            }
            case 2: {
                return this.lsViews;
            }
            case 3: {
                return this.lsTypes;
            }
        }
        return this.lsTables;
    }

    protected void addTabs() {
        this.tbTables = this.addTab(this.tbTables, Messages.getString("CWDExtractionWizard.Tables"), new ObjectModel(this.lsTables));
        this.tbEntities = this.addTab(this.tbEntities, Messages.getString("CWDExtractionWizard.Entities"), new ObjectModel(this.lsEntities));
        this.tbViews = this.addTab(this.tbViews, Messages.getString("CWDExtractionWizard.Views"), new ObjectModel(this.lsViews));
        this.tbTypes = this.addTab(this.tbTypes, Messages.getString("CWDExtractionWizard.DataTypes"), new DataTypeModel(this.lsTypes));
    }

    protected JTable addTab(JTable table, String name, AbstractTableModel model) {
        table = new JTable(model);
        table.setSelectionMode(0);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(10);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(130);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(130);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    private void handleButtons() {
        this.handleLabels();
        this.handleDescription();
        switch (this.taskNbr) {
            case 1: {
                this.bnBack.setEnabled(false);
                this.bnNext.setEnabled(this.hasModelSelected());
                this.bnFinish.setEnabled(false);
                this.bnCancel.setEnabled(true);
                break;
            }
            case 2: {
                this.bnBack.setEnabled(true);
                this.bnNext.setEnabled(false);
                this.bnFinish.setEnabled(true);
                this.bnCancel.setEnabled(true);
            }
        }
    }

    private void handleLabels() {
        switch (this.taskNbr) {
            case 1: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask4);
                break;
            }
            case 2: {
                this.setBlackLabel(this.lbTask1);
                this.setBlueLabel(this.lbTask4);
                break;
            }
            default: {
                this.setBlueLabel(this.lbTask1);
                this.setGreyLabel(this.lbTask4);
            }
        }
    }

    private void setGreyLabel(JLabel label) {
        label.setForeground(Color.LIGHT_GRAY);
        label.setFont(fontGrey);
    }

    private void setBlueLabel(JLabel label) {
        label.setForeground(Color.BLUE);
        label.setFont(fontBlue);
    }

    private void setBlackLabel(JLabel label) {
        label.setForeground(Color.BLACK);
        label.setFont(fontBlue);
    }

    private void handleDescription() {
        switch (this.taskNbr) {
            case 1: {
                this.taDescription.setText(DESCRIPTION_1);
                break;
            }
            case 2: {
                this.taDescription.setText(DESCRIPTION_4);
                break;
            }
            default: {
                this.taDescription.setText(DESCRIPTION_1);
            }
        }
    }

    @Override
    protected String getCaption() {
        return Messages.getString("CWDExtractionWizard.DataModelingDesignImportWizard");
    }

    @Override
    protected void doBack() {
        --this.taskNbr;
        try {
            if (this.performTask(false)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 1: {
                        this.cardLayout.show(this.pnMain, FIRST_PAGE);
                        break;
                    }
                    case 2: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                ++this.taskNbr;
            }
        }
        catch (Throwable e) {
            ++this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("CWDExtractionWizard.Error"), 0);
            LOGGER.error(e);
        }
    }

    private boolean performTask(boolean next) {
        switch (this.taskNbr) {
            case 2: {
                this.initSubViews(next);
                return this.getSummary();
            }
        }
        return true;
    }

    private Map getSummaryList() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (CWDDesignObj odObject : this.getSelectedObjects()) {
            if (!odObject.isSelected()) continue;
            if (map.containsKey(odObject.getType())) {
                Integer value = (Integer)map.get(odObject.getType());
                int count = value;
                map.put(odObject.getType(), new Integer(++count));
                continue;
            }
            map.put(odObject.getType(), new Integer(1));
        }
        return map;
    }

    private String addTableRow(String col1, String col2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td width=\"150\">");
        buffer.append("<p>");
        buffer.append(col1);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("<td width=\"60\" align=\"right\">");
        buffer.append("<p>");
        buffer.append(col2);
        buffer.append("</p>");
        buffer.append("</td>");
        buffer.append("</tr>");
        return buffer.toString();
    }

    private boolean getSummary() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<body>");
        buffer.append("<p>");
        buffer.append("<b>");
        buffer.append(Messages.getString("CWDExtractionWizard.ModelsImported"));
        buffer.append("</b>");
        buffer.append("</p>");
        buffer.append("<table border=\"0\" width=\"170\">");
        Map map = this.getSummaryList();
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String objType = (String)keys[i];
            Integer count = (Integer)map.get(keys[i]);
            buffer.append(this.addTableRow(objType, count.toString()));
        }
        buffer.append("</table>");
        buffer.append("</body>");
        buffer.append("</html>");
        this.taSummary.setText(buffer.toString());
        return true;
    }

    public CWDExtractionController getController() {
        if (this.controller == null) {
            this.controller = new CWDExtractionController(this.view);
        }
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initSubViews(boolean next) {
        if (next) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                try {
                    ApplicationView.loading = true;
                    List dbObjects = this.getController().loadDesign(this.getSelectedModels());
                    if (dbObjects.size() > 0) {
                        this.initSpecificObjects(dbObjects);
                    }
                    this.updateTables();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(this, e.getMessage());
                    LOGGER.error(e);
                    this.updateTables();
                    boolean bl = false;
                    ApplicationView.loading = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                ApplicationView.loading = false;
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    public boolean initModels(boolean next) {
        return this.getModels(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getModels(boolean next) {
        if (next) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.clearAll();
                try {
                    List dbObjects = this.getController().loadDesign(this.getSelectedModels());
                    if (dbObjects.size() > 0) {
                        this.initSpecificObjects(dbObjects);
                    }
                    this.updateTables();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    MessageDialogs.showErrorMessage(this, e.getMessage());
                    LOGGER.error(e);
                    this.updateTables();
                    boolean bl = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return bl;
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return true;
    }

    private void initSpecificObjects(List dbObjects) {
        this.clearAll();
    }

    private void clearAll() {
        this.lsSubViews.clear();
    }

    @Override
    protected void doNext() {
        ++this.taskNbr;
        try {
            if (this.performTask(true)) {
                this.handleButtons();
                switch (this.taskNbr) {
                    case 2: {
                        this.cardLayout.show(this.pnMain, FOURTH_PAGE);
                    }
                }
            } else {
                --this.taskNbr;
            }
        }
        catch (Throwable e) {
            --this.taskNbr;
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("CWDExtractionWizard.ErrorGenerateDesign"), 0);
            LOGGER.error(e);
        }
    }

    private List getSelectedModels() {
        ArrayList<CWDDesignObj> list = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj obj : this.lsModels) {
            if (!obj.isSelected()) continue;
            list.add(obj);
        }
        return list;
    }

    public List getSelectedObjects() {
        ArrayList<CWDDesignObj> list = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj odObject : this.lsModels) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (CWDDesignObj odObject : this.lsSubViews) {
            if (!odObject.isSelected()) continue;
            list.add(odObject);
        }
        return list;
    }

    public List getUnSelectedObjects() {
        ArrayList<CWDDesignObj> list = new ArrayList<CWDDesignObj>();
        for (CWDDesignObj odObject : this.lsModels) {
            if (odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (CWDDesignObj odObject : this.lsTables) {
            if (odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (CWDDesignObj odObject : this.lsEntities) {
            if (odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (CWDDesignObj odObject : this.lsViews) {
            if (odObject.isSelected()) continue;
            list.add(odObject);
        }
        for (CWDDesignObj odObject : this.lsTypes) {
            if (odObject.isSelected()) continue;
            list.add(odObject);
        }
        return list;
    }

    public List getAllObjects() {
        ArrayList list = new ArrayList();
        list.addAll(this.lsTables);
        list.addAll(this.lsViews);
        list.addAll(this.lsTypes);
        return list;
    }

    @Override
    protected void doFinish() {
        this.getController().initDesignHandler(this.lsModels, this.lsSubViews);
        this.dispose();
        this.getController().insertDesign();
    }

    @Override
    protected void doCancel() {
        this.dispose();
        this.getController().getExtractionHandler().clearCWDHObjects();
        this.getController().removeTempDesign();
    }

    protected void doClose() {
        this.dispose();
        this.getController().getExtractionHandler().clearCWDHObjects();
        this.getController().removeTempDesign();
    }

    public String getDesignName() {
        return this.designName;
    }

    public void setDesignName(String name) {
        this.designName = name;
    }

    public Object getImportFile() {
        return this.importFile;
    }

    public void setImportFile(Object importFile) {
        this.importFile = importFile;
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_CWD4ALL_DESIGN_WIZARD";
    }

    class DesignPartModel
    extends AbstractTableModel {
        List list;

        public DesignPartModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("CWDExtractionWizard.Model");
            }
            if (column == 2) {
                return Messages.getString("CWDExtractionWizard.ImportTo");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return true;
            }
            return rowIndex != 0 && (columnIndex == 1 || columnIndex == 2);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CWDDesignObj odObject = (CWDDesignObj)this.list.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getModel();
                }
                case 2: {
                    return odObject.getImportTo();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CWDDesignObj odObject;
            if (columnIndex == 0) {
                odObject = (CWDDesignObj)this.list.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
                CWDExtractionWizard.this.bnNext.setEnabled(CWDExtractionWizard.this.hasModelSelected());
            }
            if (columnIndex == 2) {
                odObject = (CWDDesignObj)this.list.get(rowIndex);
                odObject.setImportTo(aValue);
            }
        }
    }

    public class DesignPartComboBoxEditor
    extends DefaultCellEditor {
        private JComboBox cbox;

        public DesignPartComboBoxEditor(Object[] item) {
            super(new JComboBox<Object>(item));
            this.cbox = (JComboBox)this.getComponent();
            this.cbox.addItem(Messages.getString("CWDExtractionWizard.NewRelational"));
        }
    }

    class ObjectModel
    extends AbstractTableModel {
        List list;

        public ObjectModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("CWDExtractionWizard.Model");
            }
            if (column == 2) {
                return Messages.getString("CWDExtractionWizard.Name");
            }
            if (column == 3) {
                return Messages.getString("CWDExtractionWizard.Status");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return true;
            }
            return rowIndex != 0 && (columnIndex == 1 || columnIndex == 2);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CWDDesignObj odObject = (CWDDesignObj)this.list.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getModel();
                }
                case 2: {
                    return odObject.getObject();
                }
                case 3: {
                    return odObject.getStatus();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CWDDesignObj odObject;
            if (columnIndex == 0) {
                odObject = (CWDDesignObj)this.list.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
            }
            if (columnIndex == 2) {
                odObject = (CWDDesignObj)this.list.get(rowIndex);
                odObject.setImportTo(aValue);
            }
        }
    }

    class DataTypeModel
    extends AbstractTableModel {
        List list;

        public DataTypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("CWDExtractionWizard.Selected");
            }
            if (column == 1) {
                return Messages.getString("CWDExtractionWizard.Name");
            }
            if (column == 2) {
                return Messages.getString("CWDExtractionWizard.Type");
            }
            if (column == 3) {
                return Messages.getString("CWDExtractionWizard.Status");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CWDDesignObj odObject = (CWDDesignObj)this.list.get(row);
            switch (col) {
                case 0: {
                    return odObject.isSelected();
                }
                case 1: {
                    return odObject.getObject();
                }
                case 2: {
                    return odObject.getType();
                }
                case 3: {
                    return odObject.getStatus();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                CWDDesignObj odObject = (CWDDesignObj)this.list.get(rowIndex);
                odObject.setSelected((Boolean)aValue);
            }
        }
    }
}

