/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.awt.Color;
import java.awt.event.MouseEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class TVImpliedForeignKey
extends TVConnector {
    private ImpliedForeignKeySelection selectionWrapper = new ImpliedForeignKeySelection();
    private Color pathColorSelected = Color.red;
    private Color pathColorNormal = Color.black;
    public static float[] dashpattern = new float[]{2.0f, 6.0f};

    public TVImpliedForeignKey(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    public void addConnection() {
        if (this.edge == null) {
            ContainerView sourceTV = this.getImpliedForeignKey().getSourceTV(this.getDesignPartView());
            ContainerView targetTV = this.getImpliedForeignKey().getTargetTV(this.getDesignPartView());
            if (sourceTV != null && targetTV != null && sourceTV.getCellView() != null && targetTV.getCellView() != null) {
                ContainerDiagramCell source = (ContainerDiagramCell)sourceTV.getCellView().getCell();
                ContainerDiagramCell target = (ContainerDiagramCell)targetTV.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, this.pathColorNormal, this.getModel());
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                if (!ApplicationView.loading) {
                    this.edge.straightLine();
                }
            }
        }
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, true);
        }
    }

    private void resetEdgeParams(DefaultEdge edge, boolean repaint) {
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            if (ApplicationView.loading) {
                return this.getDesign().getRelationalDesign().getMainView();
            }
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public ImpliedForeignKey getImpliedForeignKey() {
        return (ImpliedForeignKey)this.getModel();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    protected void setPathColorNormal(Color color) {
        this.pathColorNormal = color;
    }

    protected void setPathColorSelected(Color color) {
        this.pathColorSelected = color;
    }

    protected Color getPathColorNormal() {
        return this.pathColorNormal;
    }

    protected Color getPathColorSelected() {
        return this.pathColorSelected;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent e) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Implied Foreign Key").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getModel().getDesign().getDesignLevelSettings().getDefaultLWCObject("Implied Foreign Key").getWidth();
    }

    class ImpliedForeignKeySelection
    implements SelectableObject {
        ImpliedForeignKeySelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVImpliedForeignKey.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

