/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.AbstractExporter;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.UnicodeFontMapper;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFilter;

public class PDFExporter
extends AbstractExporter {
    private static UnicodeFontMapper unicodeMapper = new UnicodeFontMapper();
    private static final Logger LOGGER = new Logger(PDFExporter.class);

    public PDFExporter(ApplicationView appView) {
        super(appView);
        this.getFilterList().add(new PDFFileFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Diagram diagram) {
        block5: {
            try {
                File file = this.getFile();
                if (file == null) break block5;
                String fileName = this.getFileName(file);
                TimeLog.log("Export Started");
                RepaintManager currentManager = RepaintManager.currentManager(diagram);
                currentManager.setDoubleBufferingEnabled(false);
                ProgressDialog monitor = new ProgressDialog(this.getAppView(), "", 0, 100, true, false);
                try {
                    monitor.setNote(Messages.getString("PDFExporter.SavingFileWait"));
                    monitor.setProgress(1);
                    PDFExporter.diagramToPDF(diagram, fileName);
                    TimeLog.log("Export End");
                }
                finally {
                    currentManager.setDoubleBufferingEnabled(true);
                    monitor.close();
                }
            }
            catch (Throwable e) {
                LOGGER.error("PDFExporter.export", e);
                MessageDialogs.showErrorMessage("Error occures while saving PDF file.", true);
            }
        }
    }

    public static void diagramToPDF(Diagram diagram, String fileName) throws Throwable {
        Dimension size = diagram.getPreferredScrollableViewportSize();
        float maxPDFSize = 14400.0f;
        float maxDiagramSize = (float)Math.max(size.getWidth() + 10.0, size.getHeight() + 10.0);
        float userUnit = 1.0f;
        float scale = 1.0f;
        if (maxDiagramSize > maxPDFSize) {
            scale = maxPDFSize / maxDiagramSize;
            userUnit = 1.0f / scale;
        }
        int width = (int)((size.getWidth() + 10.0) * (double)scale);
        int height = (int)((size.getHeight() + 10.0) * (double)scale);
        FileOutputStream output = new FileOutputStream(fileName);
        Document document = new Document(new Rectangle((float)width, (float)height));
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)output);
        writer.setPdfVersion('6');
        writer.setUserunit(userUnit);
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        document.newPage();
        PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)width, (float)height, (FontMapper)unicodeMapper);
        g2.scale(scale, scale);
        diagram.paint((Graphics)g2);
        g2.dispose();
        document.close();
        output.flush();
        ((OutputStream)output).close();
    }

    protected String getDefaultExtension() {
        return ".pdf";
    }

    @Override
    protected String getTitle() {
        return Messages.getString("PDFExporter.SaveAsPDF");
    }

    @Override
    protected boolean isSupportedExtension(String ext) {
        return ext.equals("pdf");
    }

    private class PDFFileFilter
    implements URLFilter {
        private PDFFileFilter() {
        }

        public boolean accept(URL url) {
            File file = new File(url.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String extension = AbstractExporter.getExtension(file);
            if (extension != null) {
                return PDFExporter.this.isSupportedExtension(extension);
            }
            return false;
        }

        public String toString() {
            return Messages.getString("PDFExporter.PDFFiles");
        }
    }
}

