/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.engineering.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class EngineringAdviserDialog
extends JDialog {
    JRadioButton rbKeep;
    JRadioButton rbChange;
    JCheckBox chSameForAll;

    public EngineringAdviserDialog(ApplicationView view, String sourceName, String targetName, boolean fromSourceToTarget) {
        super(view.getFrame());
        this.setTitle(Messages.getString("EngineringAdviserDialog.EngineeringAdviserDialog"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.getPanel(sourceName, targetName, fromSourceToTarget), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
        this.setModal(true);
    }

    private Component getPanel(String sourceName, String targetName, boolean fromSourceToTarget) {
        JPanel panel = new JPanel(new BorderLayout());
        JTextPane pane = new JTextPane();
        String text = fromSourceToTarget ? MessageFormat.format(Messages.getString("EngineringAdviserDialog.TargetObjectProperties"), targetName, sourceName) : MessageFormat.format(Messages.getString("EngineringAdviserDialog.SourceObjectProperties"), sourceName, targetName);
        pane.setText(text);
        pane.setEditable(false);
        pane.setBackground(panel.getBackground());
        pane.setFont(pane.getFont().deriveFont(1));
        JPanel jpanel1 = new JPanel();
        jpanel1.add(pane);
        panel.add((Component)jpanel1, "Center");
        JPanel pnOptions = new JPanel(new GridLayout(0, 1));
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("EngineringAdviserDialog.Options")));
        ButtonGroup group = new ButtonGroup();
        this.rbKeep = new JRadioButton(Messages.getString("EngineringAdviserDialog.KeepExistingValues"));
        this.rbKeep.setMnemonic(75);
        this.rbChange = new JRadioButton(Messages.getString("EngineringAdviserDialog.ChangeValues"));
        this.rbChange.setMnemonic(67);
        this.rbChange.setSelected(true);
        group.add(this.rbKeep);
        group.add(this.rbChange);
        pnOptions.add(this.rbKeep);
        pnOptions.add(this.rbChange);
        pnOptions.setPreferredSize(new Dimension(pane.getPreferredSize().width, 70));
        JPanel jpanel2 = new JPanel(new BorderLayout());
        JPanel jpanel3 = new JPanel();
        jpanel3.add(pnOptions);
        jpanel2.add((Component)jpanel3, "Center");
        this.chSameForAll = new JCheckBox(Messages.getString("EngineringAdviserDialog.ApplyForAll"));
        jpanel2.add((Component)this.chSameForAll, "South");
        panel.add((Component)jpanel2, "South");
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    protected JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton bnOK = new JButton(Messages.getString("EngineringAdviserDialog.OK"));
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractEngineering.keepExistingValues = EngineringAdviserDialog.this.rbKeep.isSelected();
                AbstractEngineering.useSameOptionForAll = EngineringAdviserDialog.this.chSameForAll.isSelected();
                EngineringAdviserDialog.this.dispose();
            }
        });
        bnOK.setPreferredSize(new Dimension(100, 25));
        buttonPanel.add(bnOK);
        return buttonPanel;
    }
}

