/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class UsedUDDTPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private UsedUserDefinedData usedUDDT;
    private JTextField tfDistinctType;
    private JTextField tfType;
    private JTextField tfNullSettings;
    private JComboBox cbDefault;
    private JComboBox cbRule;
    private JTextField tfDomain;
    private JButton buttonDomain;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JPanel panelExtProperties;
    private ExtPropertiesModel model;
    private ExtProperties extProperties;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfOwner;

    public UsedUDDTPropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.usedUDDT = (UsedUserDefinedData)object;
        this.setHeight(300);
        this.initDefaults();
        this.initRules();
        this.initCommentsView(100);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.usedUDDT.getName());
        if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.tfDistinctType.setText(this.usedUDDT.getDistinctTypeProxy().getName());
            this.tfNullSettings.setText(this.usedUDDT.getDistinctTypeProxy().getNullType());
        }
        this.cbDefault.setSelectedItem(this.usedUDDT.getDefaultObject());
        this.cbRule.setSelectedItem(this.usedUDDT.getRuleObject());
        if (this.usedUDDT.getUserDefinedType() != null) {
            this.tfDomain.setText(this.usedUDDT.getUserDefinedType().getDomain());
            this.tfNullSettings.setText(this.usedUDDT.getUserDefinedType().getNullType());
        }
        this.tfDistinctType.setEnabled(this.usedUDDT.isBaseOnDistinctType());
        this.buttonDomain.setEnabled(!this.usedUDDT.isBaseOnDistinctType());
        this.tfDomain.setEnabled(!this.usedUDDT.isBaseOnDistinctType());
        this.tfType.setText(this.usedUDDT.getDataTypeString());
        if (this.usedUDDT.getSchema() != null) {
            this.tfOwner.setText(this.usedUDDT.getSchema().getName());
        }
        if (this.usedUDDT.getExtPropsSet() != null) {
            Object[] props = this.usedUDDT.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        if (this.usedUDDT.isBaseOnDistinctType()) {
            this.insertDTComment();
        } else {
            this.insertDomainComment();
        }
    }

    private void insertDTComment() {
        this.comment = this.usedUDDT.getDistinctTypeProxy().getDistinctType().getComment();
        this.commentInRDBMS = this.usedUDDT.getDistinctTypeProxy().getDistinctType().getCommentInRDBMS();
        if (this.usedUDDT.getDistinctTypeProxy().isCommentChanged()) {
            this.getCommentsList().insert(this.usedUDDT.getDistinctTypeProxy().getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.usedUDDT.getDistinctTypeProxy().isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.usedUDDT.getDistinctTypeProxy().getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void insertDomainComment() {
        this.comment = this.usedUDDT.getUserDefinedType().getComment();
        this.commentInRDBMS = this.usedUDDT.getUserDefinedType().getCommentInRDBMS();
        this.taComments.insert(this.comment, 0);
        this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
    }

    @Override
    protected void setProperties() {
        this.usedUDDT.setName(this.tfName.getText());
        this.usedUDDT.setDefaultObject((DefaultSqlServer)this.cbDefault.getSelectedItem());
        this.usedUDDT.setRuleObject((RuleSqlServer)this.cbRule.getSelectedItem());
        Object[] propSet = this.model.getRows();
        this.usedUDDT.clear();
        String name = null;
        String value = null;
        for (int i = 0; i < propSet.length; ++i) {
            Object pr = propSet[i];
            if (!(pr instanceof String)) continue;
            StringTokenizer st = new StringTokenizer(pr.toString(), ",");
            if (st.hasMoreTokens()) {
                name = st.nextToken().trim();
            }
            if (!st.hasMoreTokens()) continue;
            value = st.nextToken().trim();
            this.usedUDDT.setProps(name);
            this.usedUDDT.setProps(value);
        }
        this.setDTComment();
    }

    private void setDTComment() {
        String commentText = this.getCommentsList().getText();
        if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
            if (this.usedUDDT.getDistinctTypeProxy() != null) {
                this.usedUDDT.getDistinctTypeProxy().setComment(commentText);
                this.usedUDDT.getDistinctTypeProxy().setCommentChanged(true);
            } else {
                this.usedUDDT.getUserDefinedType().setComment(commentText);
            }
        } else if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.usedUDDT.getDistinctTypeProxy().setComment("");
            this.usedUDDT.getDistinctTypeProxy().setCommentChanged(false);
        } else {
            this.usedUDDT.getUserDefinedType().setComment("");
        }
        String commentInRDBMSText = this.taCommentsInRDBMS.getText();
        if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
            if (this.usedUDDT.getDistinctTypeProxy() != null) {
                this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMS(commentInRDBMSText);
                this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMSChanged(true);
            } else {
                this.usedUDDT.getUserDefinedType().setCommentInRDBMS(commentInRDBMSText);
            }
        } else if (this.usedUDDT.getDistinctTypeProxy() != null) {
            this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMS("");
            this.usedUDDT.getDistinctTypeProxy().setCommentInRDBMSChanged(false);
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDistinctType();
        this.initOwner();
        this.initType();
        this.initNullSettings();
        this.initDomains();
    }

    private void initDistinctType() {
        JLabel lbDistinctType = new JLabel(Messages.getString("UsedUDDTPropertyDialog.DistinctType"));
        this.general.add(lbDistinctType);
        this.tfDistinctType = new JTextField();
        this.tfDistinctType.setEditable(false);
        this.setBG(this.tfDistinctType);
        this.tfDistinctType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDistinctType);
        this.setLabelConstraints(lbDistinctType, 50);
        this.setObjectConstraints(this.tfDistinctType, 50);
    }

    private void initDomains() {
        this.buttonDomain = new JButton("...");
        this.buttonDomain.setPreferredSize(new Dimension(30, 20));
        this.buttonDomain.setToolTipText(Messages.getString("UsedUDDTPropertyDialog.DomainProperties"));
        this.buttonDomain.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(this.buttonDomain);
        JLabel lbDistinctType = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Domain"));
        this.general.add(lbDistinctType);
        this.tfDomain = new JTextField();
        this.tfDomain.setEditable(false);
        this.setBG(this.tfDomain);
        this.tfDomain.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.tfDomain);
        this.setLabelConstraints(lbDistinctType, 80);
        this.setObjectConstraints(this.tfDomain, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.setObjectConstraints(this.buttonDomain, 80);
        this.buttonDomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Domain object = UsedUDDTPropertyDialog.this.usedUDDT.getUserDefinedType().getDomainObj();
                if (object != null && object instanceof Domain) {
                    Domain domain = object;
                    domain.showPropertyDialog();
                }
            }
        });
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Schema"));
        this.general.add(label);
        this.tfOwner = new JTextField();
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOwner.setEditable(false);
        this.general.add(this.tfOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initType() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Type"));
        this.general.add(label);
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.tfName.getPreferredSize());
        this.tfType.setEditable(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfType, 140);
    }

    private void initNullSettings() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.NullSettings"));
        this.general.add(label);
        this.tfNullSettings = new JTextField();
        this.tfNullSettings.setEditable(false);
        this.tfNullSettings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfNullSettings);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfNullSettings, 170);
    }

    private void initDefaults() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Default"));
        this.general.add(label);
        this.cbDefault = new JComboBox();
        this.fillComboItems(this.usedUDDT.getDatabase().getDefaults().toArray(), this.cbDefault);
        this.cbDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefault);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbDefault, 200);
    }

    private void initRules() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.Rule"));
        this.general.add(label);
        this.cbRule = new JComboBox();
        this.fillComboItems(this.usedUDDT.getDatabase().getRules().toArray(), this.cbRule);
        this.cbRule.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRule);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbRule, 230);
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("UsedUDDTPropertyDialog.Add"));
        this.bnRemoveProperty = new JButton(Messages.getString("UsedUDDTPropertyDialog.Remove"));
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 250);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 90, 250);
        UsedUDDTPropertyDialog.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UsedUDDTPropertyDialog.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 230));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(445, 240));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("UsedUDDTPropertyDialog.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 120);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(this.getPane().getPreferredSize().width - 25, 120));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 140);
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("UsedUDDTPropertyDialog.PropertyName"), Messages.getString("UsedUDDTPropertyDialog.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = UsedUDDTPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            UsedUDDTPropertyDialog.this.model.addRow(new Object[]{propertyName, propertyValue});
            UsedUDDTPropertyDialog.this.extProperties.updateUI();
            UsedUDDTPropertyDialog.this.extProperties.changeSelection(UsedUDDTPropertyDialog.this.model.getRowCount() - 1, 0, false, false);
            UsedUDDTPropertyDialog.this.extProperties.requestFocus();
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UsedUDDTPropertyDialog.this.model.getRowCount() >= 1) {
                for (int i = UsedUDDTPropertyDialog.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!UsedUDDTPropertyDialog.this.extProperties.isRowSelected(i)) continue;
                    UsedUDDTPropertyDialog.this.model.removeRow(i);
                }
                UsedUDDTPropertyDialog.this.extProperties.updateUI();
            }
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }
}

