/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LoginPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private LoginSqlServer login;
    private JComboBox cbAuthentication;
    private JComboBox cbDataBase;
    private JPasswordField passField;
    private JTextField tfLanguage;
    private JPanel pDBAccess;
    private JTable table;
    private UsersTableModel model;

    public LoginPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.login = (LoginSqlServer)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LoginPropertyDialogSqlServer.LoginProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAuthentication();
        this.initPassword();
        this.initDefaultDatabase();
        this.initDefaultLanguage();
    }

    @Override
    protected void addTabs() {
        this.initDBAccessView();
    }

    private void initDBAccessView() {
        this.pDBAccess = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("LoginPropertyDialogSqlServer.DatabaseAccess"), this.pDBAccess);
        this.table = new UsersTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(398, 142));
        JScrollPane pane = new JScrollPane(this.table);
        this.model = (UsersTableModel)this.table.getModel();
        this.setBG(this.table);
        this.pDBAccess.add(pane);
    }

    private void initAuthentication() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.Authentication"));
        this.general.add(label);
        this.cbAuthentication = new JComboBox<String>(LoginSqlServer.AUTH_CHOICES);
        this.setBG(this.cbAuthentication);
        this.cbAuthentication.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAuthentication.addActionListener(new AuthenticationListener());
        this.general.add(this.cbAuthentication);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbAuthentication, 50);
    }

    private void initPassword() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.Password"));
        this.general.add(label);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initDefaultDatabase() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.DefaultDatabase"));
        this.general.add(label);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        this.cbDataBase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDataBase, 110);
    }

    private void initDefaultLanguage() {
        JLabel label = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.DefaultLanguage"));
        this.general.add(label);
        this.tfLanguage = new JTextField();
        this.setBG(this.tfLanguage);
        this.tfLanguage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfLanguage);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfLanguage, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.login.getName());
        this.tfName.setText(this.login.getName());
        this.cbAuthentication.setSelectedItem(this.login.getAuthentication());
        this.passField.setText(this.login.decodePassword());
        if (this.login.getAuthentication().equals("SQL Server")) {
            this.passField.setEnabled(true);
        } else {
            this.passField.setEnabled(false);
        }
        for (DataBaseSqlServer db : this.getStorageDesign().getDataBaseSet()) {
            if (db.isNullInstance()) continue;
            this.cbDataBase.addItem(db);
        }
        this.cbDataBase.setSelectedItem(this.login.getDefaultDatabase());
        this.tfLanguage.setText(this.login.getLanguage());
        Iterator dbIterator = this.getStorageDesign().getDataBaseSet().iterator();
        boolean check = false;
        String name = "";
        while (dbIterator.hasNext()) {
            check = false;
            name = "";
            DataBaseSqlServer database = (DataBaseSqlServer)dbIterator.next();
            for (UserSqlServer user : this.getStorageDesign().getUserSet()) {
                if (user.getDatabase() != database || !this.login.getUserSet().contains(user.getName())) continue;
                check = true;
                name = user.getName();
                break;
            }
            this.model.addRow(new Object[]{check, database, name});
        }
        this.getCommentsList().insert(this.login.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.login != null) {
            this.login.setName(this.tfName.getText());
            this.login.setAuthentication((String)this.cbAuthentication.getSelectedItem());
            this.login.encodePassword(String.valueOf(this.passField.getPassword()));
            this.login.setDefaultDatabase((DataBaseSqlServer)this.cbDataBase.getSelectedItem());
            this.login.setLanguage(this.tfLanguage.getText());
            Object[] userSet = this.model.getUserColumn();
            this.login.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (ob == null || !(ob instanceof UserSqlServer)) continue;
                UserSqlServer user = (UserSqlServer)ob;
                this.login.setUsers(user.getName());
                StorageObjectCollection users = (StorageObjectCollection)user.getDatabase().getChild(3);
                if (!users.containsName(user.getName())) {
                    users.add(user);
                }
                if (this.getStorageDesign().getUserSet().contains(user)) continue;
                this.getStorageDesign().getUserSet().add(user);
            }
            this.login.setComment(this.getCommentsList().getText());
        }
    }

    class UsersTable
    extends JTable {
        UsersTableModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            tableColumn.getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
            for (int i = 1; i < 3; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new UsersTableCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(150);
                    continue;
                }
                column.setPreferredWidth(220);
            }
        }
    }

    class UsersTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("LoginPropertyDialogSqlServer.Permit"), Messages.getString("LoginPropertyDialogSqlServer.Database"), Messages.getString("LoginPropertyDialogSqlServer.User")};

        public UsersTableModel() {
            this.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!LoginPropertyDialogSqlServer.this.isEditable()) {
                return false;
            }
            return col == 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return null;
        }

        public Object[] getColumnData(int column) {
            int rowCount = LoginPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getUserColumn() {
            int rowCount = LoginPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || !((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                if (this.getValueAt(i, 2) instanceof UserSqlServer) {
                    data[i] = this.getValueAt(i, 2);
                    continue;
                }
                DataBaseSqlServer database = (DataBaseSqlServer)this.getValueAt(i, 1);
                UserSetSqlServer users = LoginPropertyDialogSqlServer.this.getStorageDesign().getUserSet();
                UserSqlServer user = (UserSqlServer)users.createElement(null);
                if (!((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) {
                    user.setName((String)this.getValueAt(i, 2));
                } else {
                    user.setName(LoginPropertyDialogSqlServer.this.login.getName());
                }
                user.setDatabase(database);
                user.setLogin(LoginPropertyDialogSqlServer.this.login);
                users.add(user);
                data[i] = user;
            }
            return data;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            try {
                int row = e.getFirstRow();
                int column = e.getColumn();
                UsersTableModel model = (UsersTableModel)e.getSource();
                Object data = model.getValueAt(row, column);
                if (data instanceof Boolean) {
                    Boolean state = (Boolean)data;
                    if (state.booleanValue()) {
                        if (LoginPropertyDialogSqlServer.this.table.getValueAt(row, 2) == null || LoginPropertyDialogSqlServer.this.table.getValueAt(row, 2) instanceof String && ((String)LoginPropertyDialogSqlServer.this.table.getValueAt(row, 2)).equalsIgnoreCase("")) {
                            DataBaseSqlServer db = (DataBaseSqlServer)LoginPropertyDialogSqlServer.this.table.getValueAt(row, 1);
                            Iterator users = LoginPropertyDialogSqlServer.this.getStorageDesign().getUserSet().iterator();
                            UserSqlServer user = null;
                            UserSqlServer tmp = null;
                            while (users.hasNext()) {
                                tmp = (UserSqlServer)users.next();
                                if (tmp.getDatabase() != db || tmp.getLogin() != LoginPropertyDialogSqlServer.this.login) continue;
                                user = tmp;
                                break;
                            }
                            if (user != null) {
                                LoginPropertyDialogSqlServer.this.table.setValueAt(user, row, 2);
                            } else {
                                LoginPropertyDialogSqlServer.this.table.setValueAt(LoginPropertyDialogSqlServer.this.login.getName(), row, 2);
                            }
                        }
                    } else {
                        LoginPropertyDialogSqlServer.this.table.setValueAt(null, row, 2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class AuthenticationListener
    implements ActionListener {
        private AuthenticationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)LoginPropertyDialogSqlServer.this.cbAuthentication.getSelectedItem()).equals("SQL Server")) {
                LoginPropertyDialogSqlServer.this.passField.setEnabled(true);
            } else {
                LoginPropertyDialogSqlServer.this.passField.setEnabled(false);
            }
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }
}

