/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectProcessesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private ApplicationView view;
    private List pList;
    private JList selectedProcessesList;
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    private DefaultListModel selectedProcessesModel;
    private JButton btnAddProcesses;
    private JButton btnRemoveProcesseses;
    protected JPanel generalPanel;
    protected JDialog dialog;

    public SelectProcessesDialog(ApplicationView view, List pList) {
        super(view);
        this.view = view;
        this.pList = pList;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(new Dimension(500, 350));
        this.allProcessesModel = new DefaultListModel();
        this.selectedProcessesModel = new DefaultListModel();
        this.init();
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.generalPanel.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
    }

    private void init() {
        this.initAllProcessesList();
        this.initProcessesButtons();
        this.initSelectedProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.pList.iterator();
        while (it.hasNext()) {
            this.selectedProcessesModel.addElement(it.next());
        }
        DataFlowDesign dfd = this.view.getCurrentDesign().getProcessModel().getDataFlowDesign().getTopLevelDataFlowDesign();
        for (Process next : dfd.getAllProcesses()) {
            if (this.pList.contains(next) || next.isComposite() || !next.isConnectedToStore()) continue;
            this.allProcessesModel.addElement(next);
        }
    }

    private void initAllProcessesList() {
        JPanel attributesList = new JPanel();
        attributesList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectProcessesDialog.Available")));
        this.allProcessesList = new JList(this.allProcessesModel);
        this.allProcessesList.setCellRenderer(new MyListCellRenderer());
        ListSelectionModel listSelectionModel = this.allProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllProcessListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allProcessesList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedProcessesList() {
        JPanel selectedList = new JPanel();
        selectedList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectProcessesDialog.Selected")));
        this.selectedProcessesList = new JList(this.selectedProcessesModel);
        this.selectedProcessesList.setCellRenderer(new MyListCellRenderer());
        ListSelectionModel listSelectionModel = this.selectedProcessesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedProcessListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedProcessesList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initProcessesButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddProcesses = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddProcesses.setPreferredSize(new Dimension(32, 32));
        this.btnAddProcesses.addActionListener(new AddProcessesActionListener());
        this.btnAddProcesses.setEnabled(false);
        this.btnAddProcesses.setToolTipText(Messages.getString("SelectProcessesDialog.Add"));
        this.btnRemoveProcesseses = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveProcesseses.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveProcesseses.setEnabled(false);
        this.btnRemoveProcesseses.addActionListener(new RemoveProcessesActionListener());
        this.btnRemoveProcesseses.setToolTipText(Messages.getString("SelectProcessesDialog.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddProcesses);
        verticalBox.add(this.btnRemoveProcesseses);
        verticalBox.add(Box.createVerticalGlue());
        this.generalPanel.add((Component)verticalBox, "Center");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectProcessesDialog.SelectProcessesConnectedToInfoStore"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectProcessesDialog.this.pList.clear();
            for (int i = 0; i < SelectProcessesDialog.this.selectedProcessesModel.size(); ++i) {
                Process process = (Process)SelectProcessesDialog.this.selectedProcessesModel.getElementAt(i);
                SelectProcessesDialog.this.pList.add(process);
            }
            SelectProcessesDialog.this.close();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectProcessesDialog.this.close();
        }
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp;
            if (value instanceof Process) {
                Process process = (Process)value;
                DataFlowDesign topdfd = ((DataFlowDesign)process.getDesignPart()).getTopLevelDataFlowDesign();
                String text = topdfd == null ? process.getProcessNumber() + " - " + process.getName() : process.getProcessNumber() + " - " + process.getName() + "  @" + topdfd.getName();
                comp = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
            } else {
                comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
            return comp;
        }
    }

    private class AllProcessListSelectionHandler
    implements ListSelectionListener {
        private AllProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.allProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnAddProcesses.setEnabled(true);
                }
            }
        }
    }

    private class SelectedProcessListSelectionHandler
    implements ListSelectionListener {
        private SelectedProcessListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectProcessesDialog.this.selectedProcessesList.getSelectedIndex() == -1) {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(false);
                } else {
                    SelectProcessesDialog.this.btnRemoveProcesseses.setEnabled(true);
                }
            }
        }
    }

    private class AddProcessesActionListener
    implements ActionListener {
        private AddProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectProcessesDialog.this.allProcessesModel.isEmpty()) {
                Object[] selectedObjects = SelectProcessesDialog.this.allProcessesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectProcessesDialog.this.selectedProcessesModel.contains(ob)) continue;
                    SelectProcessesDialog.this.selectedProcessesModel.addElement(ob);
                    SelectProcessesDialog.this.allProcessesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveProcessesActionListener
    implements ActionListener {
        private RemoveProcessesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectProcessesDialog.this.selectedProcessesModel.isEmpty()) {
                Object[] selectedObjects = SelectProcessesDialog.this.selectedProcessesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectProcessesDialog.this.allProcessesModel.contains(ob)) continue;
                    SelectProcessesDialog.this.allProcessesModel.addElement(ob);
                    SelectProcessesDialog.this.selectedProcessesModel.removeElement(ob);
                }
            }
        }
    }
}

