/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.Messages;

public class InOutParamsPropertiesDialogEx
extends AbstractPropertiesDialog {
    private InOutParams inOutParams;
    private JComboBox cbType;
    private List paramsList;
    private JPanel pnParameters;
    private JTable edTable;
    private String DEFAULT_NAME = Messages.getString("InOutParamsPropertiesDialogEx.Param");
    private int paramCounter = 0;

    public InOutParamsPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbType = new JLabel(Messages.getString("InOutParamsPropertiesDialogEx.Multiplicity"));
        lbType.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(InOutParams.MULTIPLICITY_TYPES_DISPLAY);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
    }

    @Override
    public String getCaption() {
        return Messages.getString("InOutParamsPropertiesDialogEx.TaskParameters");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof InOutParams) {
            this.inOutParams = (InOutParams)object;
            this.tfName.setText(this.inOutParams.getName());
            this.tfName.setEnabled(false);
            this.taComments.setText(this.inOutParams.getComment());
            this.taNotes.setText(this.inOutParams.getNotes());
            this.cbType.setSelectedItem(this.translate(this.inOutParams.getParametersMultiplicity(), InOutParams.MULTIPLICITY_TYPES_INTERNAL, InOutParams.MULTIPLICITY_TYPES_DISPLAY));
            this.paramsList.addAll(this.inOutParams.getParams());
            this.initDynamicProperties();
        }
    }

    private JPanel getParametersPanel() {
        if (this.pnParameters == null) {
            this.pnParameters = this.createPage(Messages.getString("InOutParamsPropertiesDialogEx.Parameters"));
            this.paramsList = new ArrayList();
            this.edTable = new JTable(new ParametersModel());
            this.edTable.setSelectionMode(0);
            this.setUpLogicalTypeColumn(this.edTable.getColumnModel().getColumn(1));
            JScrollPane scrollpane = new JScrollPane(this.edTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ParameterObject param = new ParameterObject(InOutParamsPropertiesDialogEx.this.inOutParams.getDesignPart());
                        param.setLogicalDatatype(InOutParamsPropertiesDialogEx.this.inOutParams.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        param.setName(InOutParamsPropertiesDialogEx.this.generateParamName());
                        InOutParamsPropertiesDialogEx.this.paramsList.add(param);
                        InOutParamsPropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = InOutParamsPropertiesDialogEx.this.edTable.getSelectedRow();
                        if (objectNumber != -1 && InOutParamsPropertiesDialogEx.this.paramsList.size() > 0 && objectNumber < InOutParamsPropertiesDialogEx.this.paramsList.size()) {
                            InOutParamsPropertiesDialogEx.this.paramsList.remove(objectNumber);
                            InOutParamsPropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
                buttonGeneral.add(toolBar);
            }
            scrollpane.setPreferredSize(new Dimension(325, 200));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnParameters.add(aPanel);
        }
        return this.pnParameters;
    }

    @Override
    protected void setProperties() {
        int col = this.edTable.getEditingColumn();
        int row = this.edTable.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.edTable.getCellEditor(row, col).stopCellEditing();
        }
        this.inOutParams.setName(this.tfName.getText());
        this.inOutParams.setComment(this.taComments.getText());
        this.inOutParams.setNotes(this.taNotes.getText());
        this.inOutParams.getParams().clear();
        for (ParameterObject param : this.paramsList) {
            this.inOutParams.addParam(param);
        }
        this.inOutParams.setParametersMultiplicity(this.translate((String)this.cbType.getSelectedItem(), InOutParams.MULTIPLICITY_TYPES_DISPLAY, InOutParams.MULTIPLICITY_TYPES_INTERNAL));
        InOutParamsPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.inOutParams.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.inOutParams.setProperty(dp.getName(), dp.getValue());
        }
        this.inOutParams.getDesignPart().setDirty(true);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getParametersPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void setUpLogicalTypeColumn(TableColumn attrColumn) {
        JComboBox<Object> comboBox = new JComboBox<Object>(this.getDesignObject().getDesign().getLogicalDatatypeSet().toArray());
        attrColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(Messages.getString("InOutParamsPropertiesDialogEx.ClickForLogicalTypes"));
        attrColumn.setCellRenderer(renderer);
    }

    protected String generateParamName() {
        String name = this.inOutParams.getInOutType().equalsIgnoreCase("Input") ? MessageFormat.format(Messages.getString("InOutParamsPropertiesDialogEx.In"), this.DEFAULT_NAME) : MessageFormat.format(Messages.getString("InOutParamsPropertiesDialogEx.Out"), this.DEFAULT_NAME);
        int newNumber = 0;
        int lastNumber = this.paramsList.size();
        if (lastNumber != 0) {
            newNumber = this.paramCounter = lastNumber + 1;
        } else {
            ++this.paramCounter;
            newNumber = this.paramCounter;
        }
        String paramName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.paramExists(paramName)) {
            newNumber = ++this.paramCounter;
            paramName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return paramName;
    }

    private boolean paramExists(String name) {
        for (int i = 0; i < this.paramsList.size(); ++i) {
            DesignObject param = (DesignObject)this.paramsList.get(i);
            if (!name.equalsIgnoreCase(param.getName())) continue;
            return true;
        }
        return false;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ParametersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return InOutParamsPropertiesDialogEx.this.paramsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("InOutParamsPropertiesDialogEx.Parameter");
            }
            return Messages.getString("InOutParamsPropertiesDialogEx.LogicalType");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return InOutParamsPropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ParameterObject param = (ParameterObject)InOutParamsPropertiesDialogEx.this.paramsList.get(row);
            if (col == 0) {
                return param.getName();
            }
            return param.getLogicalDatatype();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ParameterObject param = (ParameterObject)InOutParamsPropertiesDialogEx.this.paramsList.get(row);
            if (col == 0) {
                param.setName((String)value);
            } else if (col == 1) {
                param.setLogicalDatatype((LogicalDatatype)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

