/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.MessageDialogs;

public class SQLStatementsDialog
extends JDialog {
    private SQLAccessToAW sqlAW;
    private JTabbedPane tabbedPane = new JTabbedPane();
    String BTN_OK = Messages.getString("SQLStatementsDialog.OK");
    String BTN_APPLY = Messages.getString("SQLStatementsDialog.Apply");
    String BTN_CANCEL = Messages.getString("SQLStatementsDialog.Cancel");
    private JButton bnCancel;
    String KEY_ESCAPE = "ESCAPE";
    private List dimList = new ArrayList();
    private boolean readOnly = false;
    private JTable dimTable;
    private JButton btnUp;
    private JButton btnDown;
    JTextArea selPane;
    JCheckBox chFormatted;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLStatementsDialog.this.bnCancel.doClick();
        }
    };

    public SQLStatementsDialog(ApplicationView view, SQLAccessToAW sqlAW, boolean readOnly) {
        super(view.getFrame());
        sqlAW.verifyDefinitions();
        this.sqlAW = sqlAW;
        this.readOnly = readOnly;
        this.setModal(true);
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.tabbedPane.setPreferredSize(new Dimension(650, 470));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel bottomPanel = new JPanel();
        if (!readOnly) {
            JButton bnOK = new JButton(this.BTN_OK);
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            this.getRootPane().setDefaultButton(bnOK);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bottomPanel.add(bnOK);
        }
        this.bnCancel = new JButton(!readOnly ? this.BTN_CANCEL : Messages.getString("SQLStatementsDialog.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(this.bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(this.KEY_ESCAPE), this.KEY_ESCAPE);
        c.getActionMap().put(this.KEY_ESCAPE, this.escape);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.initProperties();
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(true);
        this.tabbedPane.addChangeListener(new QueryGenerator());
    }

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 3);
        window.setLocation(newLocation);
    }

    public String getCaption() {
        return MessageFormat.format(Messages.getString("SQLStatementsDialog.AttributesOrderSQLStatements"), this.sqlAW.getName());
    }

    private void initProperties() {
        this.initAttributes();
        this.initSQLTab();
    }

    private void initAttributes() {
        this.dimList.addAll(this.sqlAW.getOutSQLAttributes());
        this.dimTable = new JTable(new DimensionTableModel());
        this.dimTable.setSelectionMode(1);
        this.dimTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() != 2 || (row = SQLStatementsDialog.this.dimTable.getSelectedRow()) != -1) {
                    // empty if block
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane();
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        if (!this.readOnly) {
            this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.btnUp.setToolTipText(Messages.getString("SQLStatementsDialog.MoveUp"));
            this.btnUp.addActionListener(new MoveUpAction2());
            this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.btnDown.setToolTipText(Messages.getString("SQLStatementsDialog.MoveDown"));
            this.btnDown.addActionListener(new MoveDownAction2());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnUp);
            toolBar.add(this.btnDown);
            buttonGeneral.add(toolBar);
        }
        JPanel pPanel = new JPanel(new BorderLayout());
        pPanel.add((Component)buttonGeneral, "North");
        pPanel.add((Component)scrollpane, "Center");
        scrollpane.getViewport().add((Component)this.dimTable, null);
        scrollpane.setPreferredSize(new Dimension(630, 400));
        this.tabbedPane.addTab(Messages.getString("SQLStatementsDialog.AttributesOrder"), pPanel);
    }

    private void initSQLTab() {
        this.chFormatted = new JCheckBox(Messages.getString("SQLStatementsDialog.ShowFormattedLimitMap"));
        this.chFormatted.setSelected(true);
        this.chFormatted.setEnabled(!this.readOnly);
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.chFormatted);
        JPanel queryPanel = new JPanel(new BorderLayout());
        this.selPane = new JTextArea();
        this.selPane.setEditable(!this.readOnly);
        JScrollPane sp = new JScrollPane(this.selPane);
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        queryPanel.add((Component)toolBar, "North");
        queryPanel.add((Component)sp, "Center");
        this.tabbedPane.addTab(Messages.getString("SQLStatementsDialog.SQLStatements"), queryPanel);
        this.chFormatted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLStatementsDialog.this.makeQuery();
            }
        });
    }

    private void setProperties() {
        int col = this.dimTable.getEditingColumn();
        int row = this.dimTable.getEditingRow();
        if (col > -1 && row > -1) {
            this.dimTable.getCellEditor(row, col).stopCellEditing();
        }
        this.sqlAW.getOutSQLAttributes().clear();
        for (int i = 0; i < this.dimList.size(); ++i) {
            SQLAttribute sqla = (SQLAttribute)this.dimList.get(i);
            sqla.setOutPosition(i);
            this.sqlAW.getOutSQLAttributes().add(sqla);
        }
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public boolean moveToIndex(Object object, int index) {
        if (this.dimList.contains(object) && this.dimList.size() > index && index >= 0) {
            this.dimList.remove(object);
            this.dimList.add(index, object);
            return true;
        }
        return false;
    }

    private void makeQuery() {
        boolean formatted = this.chFormatted.isSelected();
        String text = this.sqlAW.getSQLText(formatted, this.dimList);
        this.selPane.setText(text);
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLStatementsDialog.this.setProperties();
            SQLStatementsDialog.this.dispose();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLStatementsDialog.this.dispose();
        }
    }

    class QueryGenerator
    implements ChangeListener {
        QueryGenerator() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == SQLStatementsDialog.this.tabbedPane && SQLStatementsDialog.this.tabbedPane.getSelectedIndex() == 1) {
                SQLStatementsDialog.this.makeQuery();
            }
        }
    }

    private class DimensionTableModel
    extends AbstractTableModel {
        String[] names = new String[]{Messages.getString("SQLStatementsDialog.Name"), Messages.getString("SQLStatementsDialog.Type"), Messages.getString("SQLStatementsDialog.AWName"), Messages.getString("SQLStatementsDialog.Dimension"), Messages.getString("SQLStatementsDialog.Level"), Messages.getString("SQLStatementsDialog.DataType")};

        private DimensionTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public int getRowCount() {
            return SQLStatementsDialog.this.dimList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.names[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (SQLStatementsDialog.this.readOnly) {
                return false;
            }
            if (columnIndex == 0) {
                SQLAttribute sqla = (SQLAttribute)SQLStatementsDialog.this.dimList.get(rowIndex);
                return sqla.isNameEditable();
            }
            return columnIndex == 5;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            SQLAttribute sqla = (SQLAttribute)SQLStatementsDialog.this.dimList.get(row);
            if (col == 0) {
                sqla.setName((String)value);
            } else if (col == 5) {
                sqla.setDataType((String)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAttribute sqla = (SQLAttribute)SQLStatementsDialog.this.dimList.get(row);
            if (col == 0) {
                return sqla.getName();
            }
            if (col == 1) {
                return sqla.getType();
            }
            if (col == 2) {
                return sqla.getSQLAWName();
            }
            if (col == 3) {
                return sqla.getDimensionName();
            }
            if (col == 4) {
                return sqla.getLevelName();
            }
            if (col == 5) {
                return sqla.getDataType();
            }
            return new Integer(row * col);
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = SQLStatementsDialog.this.dimTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = SQLStatementsDialog.this.dimList.get(objectNumber);
                    SQLStatementsDialog.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                SQLStatementsDialog.this.dimTable.getSelectionModel().setSelectionInterval(selection[0], selection[selection.length - 1]);
                SQLStatementsDialog.this.dimTable.updateUI();
            }
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = SQLStatementsDialog.this.dimTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < SQLStatementsDialog.this.dimList.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = SQLStatementsDialog.this.dimList.get(objectNumber);
                    SQLStatementsDialog.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                SQLStatementsDialog.this.dimTable.getSelectionModel().setSelectionInterval(selection[0], selection[selection.length - 1]);
                SQLStatementsDialog.this.dimTable.updateUI();
            }
        }
    }
}

