/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractNamingStandards;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.options.Settings;

public class AttributesNamingStandards
extends AbstractNamingStandards {
    protected JCheckBox chbPrimaryIdentifier;
    protected JCheckBox chbRelationAttributes;
    protected Entity entity;
    protected LogicalDesign logical;
    protected ApplyAttributesNamingStandards applyAttributesNamingStandards;

    public AttributesNamingStandards(ApplicationView appView, LogicalDesign logical) {
        super(appView);
        this.logical = logical;
    }

    public AttributesNamingStandards(ApplicationView appView, Entity entity) {
        super(appView);
        this.entity = entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void apply() {
        Settings settings = this.getApplicationView().getSettings();
        this.applyAttributesNamingStandards = new ApplyAttributesNamingStandards(settings, this.chbPrimaryIdentifier.isSelected(), this.chbRelationAttributes.isSelected());
        if (settings.isKeepFKNamesSynchronized() && this.chbRelationAttributes.isSelected()) {
            MessageDialogs.showWarningMessage(Messages.getString("ApplyAttributesNamingStandards.KeepAsNameOfOriginatingAttribute"));
        }
        if (this.logical != null) {
            try {
                ApplicationView.canLogging = false;
                Set<Attribute> firstReferencingAttributes = this.getFirstLevelAttributes();
                for (Attribute firstReferencingAttribute : firstReferencingAttributes) {
                    this.applyAttributesNamingStandards(firstReferencingAttribute);
                }
                if (!this.chbPrimaryIdentifier.isSelected()) return;
                Iterator it = this.logical.getEntitySet().iterator();
                while (it.hasNext()) {
                    Entity ent = (Entity)it.next();
                    this.applyAttributesNamingStandards.applyToPrimaryIdentifier(ent);
                }
                return;
            }
            finally {
                ApplicationView.canLogging = true;
                this.logical.sortCollections();
            }
        } else {
            this.applyAttributesNamingStandards.apply(this.entity);
        }
    }

    protected void applyAttributesNamingStandards(Attribute attribute) {
        for (Attribute referencingAttribute : this.getReferencingAttributes(attribute)) {
            this.applyAttributesNamingStandards(referencingAttribute);
        }
    }

    protected Set<Attribute> getReferencingAttributes(Attribute attribute) {
        HashSet<Attribute> result = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Attribute attr = (Attribute)iterator.next();
            if (attr.getDelegate() != attribute) continue;
            result.add(attr);
        }
        return result;
    }

    protected Set<Attribute> getAllFKAttributes() {
        HashSet<Attribute> result = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            result.add((Attribute)iterator.next());
        }
        return result;
    }

    private Set<Attribute> getFirstLevelAttributes() {
        HashSet<Attribute> result = new HashSet<Attribute>();
        Iterator iterator = this.logical.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.isFKAttribute() || attribute.getDelegate().isFKAttribute()) continue;
            result.add(attribute);
        }
        return result;
    }

    @Override
    protected String getDialogTitle() {
        return Messages.getString("AttributesNamingStandards.ApplyNamingStandards");
    }

    @Override
    protected Dimension getDialogPreferredSize() {
        return new Dimension(300, 100);
    }

    @Override
    protected JPanel initGeneralPanel() {
        JPanel generalPanel = super.initGeneralPanel();
        this.chbPrimaryIdentifier = new JCheckBox(Messages.getString("AttributesNamingStandards.PrimaryIdentifier"), true);
        this.chbRelationAttributes = new JCheckBox(Messages.getString("AttributesNamingStandards.RelationAttributes"), true);
        this.generalPanelContents.add(this.chbPrimaryIdentifier);
        this.generalPanelContents.add(this.chbRelationAttributes);
        return generalPanel;
    }

    @Override
    public Design getDesign() {
        if (this.logical != null) {
            return this.logical.getDesign();
        }
        if (this.entity != null) {
            return this.entity.getDesign();
        }
        return super.getDesign();
    }
}

