/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.io.InputStream;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLModelIDObject;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractRXMLStorageDesign;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenericRXMLStorageObject
extends AbstractRXMLModelIDObject {
    private Class baseClass = StorageObject.class;
    private Class wrappeeClass = StorageObject.class;
    private String relativePath = "";
    private AbstractRXMLStorageDesign storageDesignReader;
    private static final Logger LOGGER = new Logger(GenericRXMLStorageObject.class);

    public GenericRXMLStorageObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    public void setBaseClass(Class baseClass) {
        this.baseClass = baseClass;
    }

    public void setWrappeeClass(Class wrappeeClass) {
        if (!StorageObject.class.isAssignableFrom(wrappeeClass)) {
            throw new IllegalArgumentException("wrappee class should be a StorageObject subclass");
        }
        this.wrappeeClass = wrappeeClass;
    }

    protected Class getBaseClass() {
        return this.baseClass;
    }

    protected Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    public void setRelativePath(String path) {
        this.relativePath = path;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public String getRelativePath(Object request) {
        return this.getRelativePath((ReadRequest)request);
    }

    public String getRelativePath(ReadRequest request) {
        StoragePathTranslator.WRITE_OPERATION = false;
        return StoragePathTranslator.getPath(request.getStorageObject());
    }

    @Override
    public String getFilename(Object request) {
        return this.getFilename((ReadRequest)request);
    }

    public String getFilename(ReadRequest request) {
        return request.getObjectName();
    }

    @Override
    public boolean canRead(Object request) {
        if (request instanceof ReadRequest) {
            return this.canRead((ReadRequest)request);
        }
        if (request instanceof StorageObject) {
            return this.getWrappeeClass().isAssignableFrom(request.getClass());
        }
        return false;
    }

    public boolean canRead(ReadRequest request) {
        if (request.getStorageObject() == null) {
            return false;
        }
        return this.getWrappeeClass().isAssignableFrom(request.getStorageObject().getClass());
    }

    @Override
    public Object recreateObject(Object request, Design design, boolean tryReadWriteLocking) {
        design.getAppView().setCurrentDesign(design);
        ReadRequest readRequest = (ReadRequest)request;
        InputStream is = this.getInputStreamFor(request);
        if (is != null) {
            try {
                Document doc = GenericRXMLStorageObject.parse(is, this.getFilename(request), design);
                boolean hasLock = false;
                if (doc == null) {
                    LOGGER.error("doc null for id/name: <" + request + ">");
                    return null;
                }
                Object result = this.recreateObject(doc, readRequest, hasLock);
                return result;
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("Error recreating StorageObject from XML: *****  id/name: <" + request + "> *****");
                return null;
            }
        }
        return null;
    }

    public Object recreateObject(Document doc, ReadRequest request, boolean hasLock) {
        StoragePathTranslator.WRITE_OPERATION = false;
        Element root = doc.getDocumentElement();
        Element objInfo = GenericRXMLStorageObject.getFirstChildByTagName(root, "object");
        StorageObject storageObject = request.getStorageObject();
        this.readBasicObjectInfo(objInfo, storageObject, hasLock);
        Element propertiesElm = GenericRXMLStorageObject.getFirstChildByTagName(root, "properties");
        if (propertiesElm == null) {
            propertiesElm = GenericRXMLStorageObject.getFirstChildByTagName(objInfo, "properties");
        }
        this.readWrappedProperties(propertiesElm, storageObject);
        this.readObjectInfo(objInfo, storageObject, hasLock);
        storageObject.setPersisted(true);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(StoragePathTranslator.getPath(storageObject)).append('/').append(storageObject.getObjectID()).append(".dmd");
        storageObject.setFilePath(buffer.toString());
        StorageDesign stdes = storageObject.getStorageDesign();
        String type = storageObject.getObjectTypeName();
        if (stdes.getLoadedVersion() > 2.1f && "Table".equalsIgnoreCase(type) && storageObject instanceof TableProxy) {
            this.readTableElements((TableProxy)storageObject, root, stdes);
            this.readSAC_StorageObjects((TableProxy)storageObject, root, stdes);
        }
        storageObject.setDirty(false);
        return storageObject;
    }

    private void readTableElements(TableProxy tp, Element root, StorageDesign stDes) {
        Element keysElem;
        NodeList objectElements;
        int length;
        Element columnsElem = GenericRXMLStorageObject.getFirstChildByTagName(root, "columns");
        if (columnsElem != null && (length = (objectElements = columnsElem.getElementsByTagName("Column")).getLength()) > 0) {
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                this.recreateContainedStorageObject(elm, stDes, tp, false);
            }
        }
        if ((keysElem = GenericRXMLStorageObject.getFirstChildByTagName(root, "keys_and_indexes")) != null) {
            Element elm;
            NodeList objectElements2 = keysElem.getElementsByTagName("PrimaryKey");
            int length2 = objectElements2.getLength();
            if (length2 > 0) {
                for (int i = 0; i < length2; ++i) {
                    elm = (Element)objectElements2.item(i);
                    this.recreateContainedStorageObject(elm, stDes, tp, false);
                }
            }
            if ((length2 = (objectElements2 = keysElem.getElementsByTagName("Unique")).getLength()) > 0) {
                for (int i = 0; i < length2; ++i) {
                    elm = (Element)objectElements2.item(i);
                    this.recreateContainedStorageObject(elm, stDes, tp, false);
                }
            }
            if ((length2 = (objectElements2 = keysElem.getElementsByTagName("Index")).getLength()) > 0) {
                for (int i = 0; i < length2; ++i) {
                    elm = (Element)objectElements2.item(i);
                    this.recreateContainedStorageObject(elm, stDes, tp, false);
                }
            }
            if ((length2 = (objectElements2 = keysElem.getElementsByTagName("ForeignKey")).getLength()) > 0) {
                for (int i = 0; i < length2; ++i) {
                    elm = (Element)objectElements2.item(i);
                    this.recreateContainedStorageObject(elm, stDes, tp, false);
                }
            }
        }
    }

    private void readSAC_StorageObjects(TableProxy tp, Element root, StorageDesign stDes) {
        NodeList objectElements;
        int length;
        Element columnsElem = GenericRXMLStorageObject.getFirstChildByTagName(root, "storage_objects");
        if (columnsElem != null && (length = (objectElements = columnsElem.getElementsByTagName("storage_object")).getLength()) > 0) {
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)objectElements.item(i);
                this.recreateSACStorageObject(elm, stDes, tp, false);
            }
        }
    }

    public Object recreateObject(Document doc, ReadRequest request, StorageDesign stoDes, boolean hasLock) {
        StoragePathTranslator.WRITE_OPERATION = false;
        Element root = doc.getDocumentElement();
        StorageObject storageObject = null;
        Element objInfo = GenericRXMLStorageObject.getFirstChildByTagName(doc.getDocumentElement(), "object");
        storageObject = request.getStorageObject();
        this.readBasicObjectInfo(objInfo, storageObject, hasLock);
        Element propertiesElm = GenericRXMLStorageObject.getFirstChildByTagName(doc.getDocumentElement(), "properties");
        if (propertiesElm == null) {
            propertiesElm = GenericRXMLStorageObject.getFirstChildByTagName(objInfo, "properties");
        }
        this.readWrappedProperties(propertiesElm, storageObject);
        this.readObjectInfo(objInfo, storageObject, hasLock);
        storageObject.setPersisted(true);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(StoragePathTranslator.getPath(storageObject)).append('/').append(storageObject.getObjectID()).append(".dmd");
        storageObject.setFilePath(buffer.toString());
        String type = storageObject.getObjectTypeName();
        if (stoDes.getLoadedVersion() > 2.1f && "Table".equalsIgnoreCase(type) && storageObject instanceof TableProxy) {
            this.readTableElements((TableProxy)storageObject, root, stoDes);
            this.readSAC_StorageObjects((TableProxy)storageObject, root, stoDes);
        }
        storageObject.setDirty(false);
        return storageObject;
    }

    public Object recreateObjectContainedProxy(Element objInfo, StorageObject storageObject, StorageDesign stoDes, boolean hasLock) {
        this.readBasicObjectInfo(objInfo, storageObject, hasLock);
        Element propertiesElm = GenericRXMLStorageObject.getFirstChildByTagName(objInfo, "properties");
        this.readWrappedProperties(propertiesElm, storageObject);
        this.readObjectInfo(objInfo, storageObject, hasLock);
        storageObject.setPersisted(true);
        storageObject.setDirty(false);
        return storageObject;
    }

    public StorageObject recreateContainedStorageObject(Element objInfo, StorageDesign storageDesign, StorageObject pacElement, boolean hasLock) {
        StorageObject proxy = null;
        storageDesign.setInitialReadBackDone(true);
        String id = objInfo.getAttribute("id");
        if (id != null) {
            proxy = storageDesign.getStorageObject(id);
            if (proxy == null) {
                ModelIDObject obj;
                String newID = null;
                Map map = storageDesign.getCorrespondenceMap();
                if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                    newID = obj.getObjectID();
                    proxy = storageDesign.getStorageObject(newID);
                }
            }
            if (proxy != null) {
                DesignObject obj;
                boolean merge = true;
                if (proxy instanceof RelationalObjectProxy && (obj = ((RelationalObjectProxy)proxy).getObject()) != null) {
                    merge = obj.shouldBeMerge();
                }
                if (merge) {
                    AbstractXMLReader reader;
                    AbstractRXMLStorageDesign stReader = this.getStorageDesignReader();
                    if (!this.isNestedObject(proxy) && stReader != null && (reader = stReader.getReaderForContainedProxy(proxy)) instanceof GenericRXMLStorageObject) {
                        ((GenericRXMLStorageObject)reader).recreateObjectContainedProxy(objInfo, proxy, storageDesign, hasLock);
                    }
                }
                proxy.setPAC_Element(pacElement);
            }
        }
        return proxy;
    }

    public StorageObject recreateSACStorageObject(Element objInfo, StorageDesign storageDesign, StorageObject pacElement, boolean hasLock) {
        ModelIDObject proxy = null;
        storageDesign.setInitialReadBackDone(true);
        String id = objInfo.getAttribute("id");
        if (id != null) {
            String type = objInfo.getAttribute("type");
            AbstractRXMLStorageDesign stReader = this.getStorageDesignReader();
            if (stReader != null) {
                proxy = stReader.recreateStorageObject(objInfo, type, storageDesign, hasLock);
            }
            if (proxy != null) {
                proxy.setPAC_Element(pacElement);
            }
        }
        return proxy;
    }

    private boolean isNestedObject(StorageObject storageObject) {
        if (storageObject instanceof ColumnProxy) {
            Column column = (Column)((ColumnProxy)storageObject).getObject();
            return column.isNested();
        }
        return false;
    }

    protected void readWrappedProperties(Element parent, StorageObject object) {
        PropertyMapWrapper wrapper = this.getPropertyMapWrapper(object);
        wrapper.setTranslators(object.getStorageDesign().getPropertyTranslators());
        this.readPropertiesList(parent, wrapper, object);
        this.releasePropertyMapWrapper(wrapper);
        StorageDesign stDes = object.getStorageDesign();
        if (stDes.getDesign().isMerging() || stDes.isCloneOperation()) {
            object.setOwnerDesignName(stDes.getDesign().getName());
        }
    }

    protected PropertyMapWrapper getPropertyMapWrapper(StorageObject object) {
        return this.getPMWPoolMap().getInstance(this.getWrappeeClass(), this.getBaseClass(), object);
    }

    protected void releasePropertyMapWrapper(PropertyMapWrapper wrapper) {
        if (wrapper instanceof PMWPooled) {
            ((PMWPooled)wrapper).releaseFromPool();
        } else {
            LOGGER.error("releasePropertyMapWrapper: can not release");
        }
    }

    @Override
    public Object recreateObject(Document document, Design design, boolean hasLock) {
        throw new RuntimeException("Replaced with call to recreateObject(Document, ReadRequest, boolean).");
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == StorageObject.class;
    }

    public AbstractRXMLStorageDesign getStorageDesignReader() {
        return this.storageDesignReader;
    }

    public void setStorageDesignReader(AbstractRXMLStorageDesign storageDesignReader) {
        this.storageDesignReader = storageDesignReader;
    }
}

