/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLSQLAccessToAW
extends AbstractWXMLDesignObject
implements MDConstants {
    private SQLAccessToAW awSQL = null;
    private Slice slice;
    private Cube cube;

    public WXMLSQLAccessToAW(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof SQLAccessToAW;
        if (result) {
            this.awSQL = (SQLAccessToAW)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.awSQL != null) {
            String designName = this.awSQL.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.awSQL.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("sqltoawPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof SQLAccessToAW) {
            this.awSQL = (SQLAccessToAW)object;
            this.awSQL.verifyDefinitions();
            this.cube = this.awSQL.getCube();
            this.slice = this.awSQL.getSlice();
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", String.valueOf(this.awSQL.getDescription()));
            map.put("aw_name", String.valueOf(this.awSQL.getAWName()));
            map.put("aw_include_gids", String.valueOf(this.awSQL.isGenerateGIDs()));
            map.put("aw_use_object_types", String.valueOf(this.awSQL.isUseObjectType()));
            map.put("aw_use_model_clause", String.valueOf(this.awSQL.isUseModelClause()));
            map.put("aw_include_row2cell", String.valueOf(this.awSQL.isUseRowToCellColumn()));
            map.put("aw_object_type_name", String.valueOf(this.awSQL.getObjectADTName()));
            map.put("aw_table_type_name", String.valueOf(this.awSQL.getTableADTName()));
            if (this.slice != null) {
                map.put("slice_id", StringUtilities.encodeAttributeValue(this.slice.getObjectID()));
            } else {
                map.put("cube_id", StringUtilities.encodeAttributeValue(this.cube.getObjectID()));
            }
            this.appendProperties(objectInfoNode, "attributes", map);
            if (this.slice != null) {
                Element mesures = objectInfoNode.getOwnerDocument().createElement("measure_wrappers");
                this.appendMeasureWrappers(mesures, this.awSQL);
                objectInfoNode.appendChild(mesures);
            } else {
                this.appendObjects(objectInfoNode, this.awSQL.getMeasures().toArray(), "measures");
            }
            Element outAttributes = objectInfoNode.getOwnerDocument().createElement("aw_out_sql_attributes");
            this.appendOutAttributes(outAttributes, this.awSQL);
            objectInfoNode.appendChild(outAttributes);
            Element sdimensions = objectInfoNode.getOwnerDocument().createElement("aw_sql_dimensions");
            this.appendSQLDimensions(sdimensions, this.awSQL);
            objectInfoNode.appendChild(sdimensions);
        }
    }

    private void appendOutAttributes(Element parent, SQLAccessToAW awSQL) {
        for (SQLAttribute sqla : this.getOtherOutAttributes()) {
            this.appendSQLAttribute(parent, sqla);
        }
    }

    private void appendMeasureWrappers(Element parent, SQLAccessToAW awSQL) {
        if (this.slice != null) {
            for (Slice.MeasureWrapper mw : awSQL.getMeasureWrappers()) {
                Element felem = parent.getOwnerDocument().createElement("measure_wrapper");
                felem.setAttribute("measure_id", StringUtilities.encodeAttributeValue(mw.getMeasure().getObjectID()));
                if (mw.getAggrFunction() != null) {
                    felem.setAttribute("aggr_function_id", StringUtilities.encodeAttributeValue(mw.getAggrFunction().getObjectID()));
                }
                parent.appendChild(felem);
            }
        }
    }

    private void appendSQLDimensions(Element parent, SQLAccessToAW awSQL) {
        for (SQLAccessToAW.SQLDimension sqld : awSQL.getSqlDimensionDefinitions()) {
            Element delem = parent.getOwnerDocument().createElement("aw_sqldimension");
            this.appendSQLDimension(delem, sqld);
            parent.appendChild(delem);
        }
    }

    private void appendSQLDimension(Element dimElement, SQLAccessToAW.SQLDimension sqld) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("aw_use_long_desc", String.valueOf(sqld.isSelectedLongDescAttr()));
        map.put("aw_use_short_desc", String.valueOf(sqld.isSelectedShortDescAttr()));
        map.put("aw_use_level_name", String.valueOf(sqld.isSelectedLevelNameAttr()));
        map.put("aw_use_dim_column", String.valueOf(sqld.isSelectedDimensionID()));
        map.put("dimension_id", String.valueOf(StringUtilities.encodeAttributeValue(sqld.getDimension().getObjectID())));
        this.appendProperties(dimElement, "aw_sqldim_attributes", map);
        Iterator it = sqld.getAllSelectedAttributes().iterator();
        Element aelem = dimElement.getOwnerDocument().createElement("aw_sql_attributes");
        while (it.hasNext()) {
            SQLAttribute sqla = (SQLAttribute)it.next();
            this.appendSQLAttribute(aelem, sqla);
        }
        dimElement.appendChild(aelem);
        Element helem = dimElement.getOwnerDocument().createElement("aw_hierarchies");
        for (SQLAccessToAW.SQLHierarchy sqlh : sqld.getSelectedSQLHierarhies()) {
            this.appendSQLHierarchy(helem, sqlh);
        }
        dimElement.appendChild(helem);
    }

    private List getOtherOutAttributes() {
        ArrayList<SQLAttribute> list = new ArrayList<SQLAttribute>();
        for (SQLAttribute sqla : this.awSQL.getOutSQLAttributes()) {
            if (!SQLAccessToAW.ATTR_TYPE_MEASURE.equals(sqla.getType())) continue;
            list.add(sqla);
        }
        return list;
    }

    private void appendSQLAttribute(Element parent, SQLAttribute sqla) {
        Element aelem = parent.getOwnerDocument().createElement("aw_sql_attribute");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("name", sqla.getName());
        map.put("type", sqla.getType());
        map.put("datatype", sqla.getDataType());
        map.put("aw_sql_attr_out_position", String.valueOf(sqla.getOutPosition()));
        if (sqla.getHierarchy() != null) {
            map.put("hierarchy_id", StringUtilities.encodeAttributeValue(sqla.getHierarchy().getObjectID()));
        }
        if (sqla.getLevel() != null) {
            map.put("level_id", StringUtilities.encodeAttributeValue(sqla.getLevel().getObjectID()));
        }
        if (sqla.getCube() != null) {
            map.put("cube_id", StringUtilities.encodeAttributeValue(sqla.getCube().getObjectID()));
        }
        if (sqla.getSlice() != null) {
            map.put("slice_id", StringUtilities.encodeAttributeValue(sqla.getSlice().getObjectID()));
        }
        if (sqla.getMeasure() != null) {
            map.put("measure", StringUtilities.encodeAttributeValue(sqla.getMeasure().getObjectID()));
        }
        if (sqla.getMeasureWrapper() != null) {
            map.put("measure_wrapper", StringUtilities.encodeAttributeValue(sqla.getMeasureWrapper().getMeasure().getObjectID()));
            map.put("aggr_function_id", StringUtilities.encodeAttributeValue(sqla.getMeasureWrapper().getAggrFunction().getObjectID()));
        }
        if (sqla.getSlowChangingAttribute() != null) {
            map.put("attribute", StringUtilities.encodeAttributeValue(sqla.getSlowChangingAttribute().getAttribute().getObjectID()));
            map.put("scattribute_name", sqla.getSlowChangingAttribute().getName());
        }
        map.put("aw_isname_editable", String.valueOf(sqla.isNameEditable()));
        this.appendProperties(aelem, "aw_sql_attribute_props", map);
        parent.appendChild(aelem);
    }

    private void appendSQLHierarchy(Element parent, SQLAccessToAW.SQLHierarchy sqlh) {
        Element helem = parent.getOwnerDocument().createElement("aw_hierarchy");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("hierarchy_id", StringUtilities.encodeAttributeValue(sqlh.getHierarchy().getObjectID()));
        map.put("aw_is_rollupform", String.valueOf(sqlh.isRollupForm()));
        this.appendProperties(helem, "attributes", map);
        if (sqlh.getLabelAttribute() != null) {
            this.appendSQLAttribute(helem, sqlh.getLabelAttribute());
        }
        this.appendObjects(helem, sqlh.getSelectedLevels().toArray(), "levels");
        parent.appendChild(helem);
    }
}

