/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFromObjTransformer
extends MDTransformer
implements MDXMLConstants {
    public Document transformFromObject(Object object) {
        return this.transformFromObject(object, false);
    }

    public Document transformFromObject(Object object, boolean processExternals) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            Element rootElement = this.transformFromObject(object, null, doc, processExternals);
            if (rootElement != null) {
                doc.appendChild(rootElement);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    public Element transformFromObject(Object object, String tagName, Document doc) {
        return this.transformFromObject(object, tagName, doc, false);
    }

    public Element transformFromObject(Object object, String tagName, Document doc, boolean processExternals) {
        return this.transformFromObject(object, tagName, doc, processExternals, false);
    }

    public Element transformFromObject(Object object, String tagName, Document doc, boolean processExternals, boolean skipClassName) {
        Element rootElement = null;
        try {
            ClassDescription cd = this.getClassDescription();
            if (tagName != null) {
                rootElement = doc.createElement(tagName);
            } else {
                boolean innerClass = false;
                String xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                rootElement = doc.createElement(xmlName);
                if (innerClass) {
                    rootElement.setAttribute("innerClass", "true");
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                rootElement.setAttribute("class", cd.getClassName());
            }
            this.invokeMethod(object, cd.beforeTransform);
            if (processExternals) {
                this.invokeMethod(object, cd.beforeTransformExt);
            }
            this.processProperties(object, rootElement, cd, processExternals);
            this.processClassPropertyMap(object, rootElement, cd);
            this.processCollections(object, rootElement, cd, processExternals);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootElement;
    }

    private void processProperties(Object object, Element rootElement, ClassDescription cd) {
        this.processProperties(object, rootElement, cd, false);
    }

    private void processProperties(Object object, Element rootElement, ClassDescription cd, boolean processExternals) {
        Document doc = rootElement.getOwnerDocument();
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            XMLFromObjTransformer xmltr;
            Element element;
            MDTransformationManager.TrObjects tr;
            if (pd.isLoggingProp && !MDTransformer.includeLoggingProps || !MDTransformer.includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals) continue;
            if (pd.isRectangle) {
                Object obj = XMLFromObjTransformer.getObjectForProperty(object, pd);
                if (obj == null || !(obj instanceof Rectangle)) continue;
                this.appendBounds(rootElement, pd.xmlName, (Rectangle)obj);
                continue;
            }
            if (pd.isPropertyMap) {
                this.processPropertyAsPropertyMap(object, rootElement, pd);
                continue;
            }
            if (pd.isMap) {
                this.processMapProperty(object, rootElement, pd);
                continue;
            }
            if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
                String value = this.getProperty(object, pd);
                if (value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                value = StringUtilities.encodeAttributeValue(value);
                if (pd.isAttribute()) {
                    rootElement.setAttribute(pd.xmlName, value);
                    continue;
                }
                Element element2 = doc.createElement(pd.xmlName);
                Text content = doc.createTextNode(value);
                element2.appendChild(content);
                rootElement.appendChild(element2);
                continue;
            }
            Object nested = XMLFromObjTransformer.getObjectForProperty(object, pd);
            if (nested == null || (tr = this.getTransformationManager().getTransformersFor(nested.getClass())) == null || tr.getFromObjectTransformer() == null || !(tr.getFromObjectTransformer() instanceof XMLFromObjTransformer) || (element = (xmltr = (XMLFromObjTransformer)tr.getFromObjectTransformer()).transformFromObject(nested, pd.xmlName, doc, processExternals)) == null) continue;
            rootElement.appendChild(element);
        }
    }

    private void processPropertyAsPropertyMap(Object object, Element rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = XMLFromObjTransformer.getObjectForProperty(object, pd)) != null && obj instanceof PropertyMap) {
            Document doc = rootElement.getOwnerDocument();
            PropertyMap pm = (PropertyMap)obj;
            Iterator it = pm.getPropertyNames();
            Element pmElement = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pm.getProperty(key);
                if (value == null) continue;
                if (pmElement == null) {
                    pmElement = doc.createElement(pd.xmlName);
                    rootElement.appendChild(pmElement);
                }
                Element element = doc.createElement(pd.pmItemName);
                element.setAttribute(pd.pmKeyName, StringUtilities.encodeAttributeValue(key));
                element.setAttribute(pd.pmValueName, StringUtilities.encodeAttributeValue(value));
                pmElement.appendChild(element);
            }
        }
    }

    private void processMapProperty(Object object, Element rootElement, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = XMLFromObjTransformer.getObjectForProperty(object, pd)) != null && obj instanceof Map) {
            Document doc = rootElement.getOwnerDocument();
            Map map = (Map)obj;
            Iterator it = map.keySet().iterator();
            Element pmElement = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = map.get(key);
                if (value == null) continue;
                if (pmElement == null) {
                    pmElement = doc.createElement(pd.xmlName);
                    rootElement.appendChild(pmElement);
                }
                Element element = doc.createElement(pd.pmItemName);
                element.setAttribute("key", StringUtilities.encodeAttributeValue(key));
                element.setAttribute("value", StringUtilities.encodeAttributeValue(value.toString()));
                pmElement.appendChild(element);
            }
        }
    }

    private void processClassPropertyMap(Object object, Element rootElement, ClassDescription cd) {
        if (cd.isPropertyMap && object instanceof PropertyMap) {
            Document doc = rootElement.getOwnerDocument();
            PropertyMap pmap = (PropertyMap)object;
            Iterator it = pmap.getPropertyNames();
            Element element = null;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.skipProperty(key)) continue;
                String value = pmap.getProperty(key);
                if (element == null) {
                    element = doc.createElement("propertyMap");
                    rootElement.appendChild(element);
                }
                Element prop = doc.createElement("property");
                prop.setAttribute("name", StringUtilities.encodeAttributeValue(key));
                prop.setAttribute("value", StringUtilities.encodeAttributeValue(value));
                element.appendChild(prop);
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Object object, Element parent, ClassDescription cd) {
        this.processCollections(object, parent, cd, false);
    }

    private void processCollections(Object object, Element parent, ClassDescription cd, boolean processExternals) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object sourceCol;
            Collection col;
            if (cold.isExternalCollection && !processExternals || (col = this.getObjectList(sourceCol = XMLFromObjTransformer.getCollection(object, cold), cold)) == null || !(col instanceof Collection) || SKP_DEFAULTS && col.size() <= 0) continue;
            if (cold.itemIsRef) {
                this.processCollectionWithRefs(object, col, parent, cold, processExternals);
                continue;
            }
            this.processCollectionWithContained(col, parent, cold, processExternals);
        }
    }

    private void processCollectionWithRefs(Object object, Collection col, Element parent, ClassDescription.CollectionDescription cold) {
        this.processCollectionWithRefs(object, col, parent, cold, false);
    }

    private void processCollectionWithRefs(Object object, Collection col, Element parent, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        Document doc = parent.getOwnerDocument();
        Element colelem = doc.createElement(cold.xmlName);
        parent.appendChild(colelem);
        if (!cold.listOfRefs) {
            for (Object item : col) {
                if (item == null) continue;
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                Element element = doc.createElement(cold.itemXmlName);
                Text content = doc.createTextNode(id);
                element.appendChild(content);
                colelem.appendChild(element);
            }
        } else {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id = null;
                if (item instanceof ModelIDObject) {
                    id = ((ModelIDObject)item).getObjectID();
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(null, item);
                } else {
                    int k = 0;
                    ++k;
                }
                if (id == null) continue;
                if (first) {
                    sb.append(id);
                    first = false;
                    continue;
                }
                sb.append(' ').append(id);
            }
            String name = cold.refsXMLName;
            String idrefs = sb.toString();
            colelem.setAttribute(name, idrefs);
        }
    }

    private void processCollectionWithContained(Collection col, Element parent, ClassDescription.CollectionDescription cold) {
        this.processCollectionWithContained(col, parent, cold, false);
    }

    private void processCollectionWithContained(Collection col, Element parent, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        Document doc = parent.getOwnerDocument();
        Element colelem = doc.createElement(cold.xmlName);
        boolean skipClassName = false;
        if (!ApplicationView.INCLUDE_CLASS_NAME_IN_ITEM_XML && cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            skipClassName = true;
            colelem.setAttribute("itemClass", cold.itemClassName);
        }
        parent.appendChild(colelem);
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        MDTransformationManager.TrObjects tr = null;
        Class<?> currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (item instanceof Map) {
                    mapItem = true;
                    continue;
                }
                if (first || currentClass != null && !item.getClass().equals(currentClass)) {
                    tr = this.getTransformationManager().getTransformersFor(item.getClass());
                    first = false;
                    currentClass = item.getClass();
                }
                Element element = null;
                if (tr != null && tr.getFromObjectTransformer() != null && tr.getFromObjectTransformer() instanceof XMLFromObjTransformer) {
                    XMLFromObjTransformer xmltr = (XMLFromObjTransformer)tr.getFromObjectTransformer();
                    element = xmltr.transformFromObject(item, cold.itemXmlName, doc, processExternals, skipClassName);
                }
                if (element == null) continue;
                colelem.appendChild(element);
                this.processTopView(element, item);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                Element element = doc.createElement(cold.itemXmlName);
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    element.setAttribute(StringUtilities.encodeAttributeValue((String)key), StringUtilities.encodeAttributeValue((String)value));
                    colelem.appendChild(element);
                }
            }
        }
    }

    private void processTopView(Element element, Object item) {
        TopView tv;
        DesignObject designObject;
        if (item instanceof TopView && (designObject = (tv = (TopView)item).getModel()) != null) {
            TVConnector tvc;
            ConnectionInterface ci;
            element.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
            if (designObject instanceof DiagramView) {
                DiagramView dv = (DiagramView)designObject;
                element.setAttribute("dpv_id", StringUtilities.encodeAttributeValue(dv.getDpvID()));
            } else {
                element.setAttribute("otype", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
            }
            if (tv instanceof ContainerView) {
                element.setAttribute("vid", StringUtilities.encodeAttributeValue(tv.getViewID()));
                if (tv.getViewNumber() != 0) {
                    element.setAttribute("vnum", String.valueOf(tv.getViewNumber()));
                }
            } else if (tv instanceof TVConnector && (ci = (ConnectionInterface)((Object)(tvc = (TVConnector)tv).getModel())).getSourceObject() != null && ci.getTargetObject() != null && tvc.getSourceTopView() != null && tvc.getTargetTopView() != null) {
                element.setAttribute("vid_source", StringUtilities.encodeAttributeValue(tvc.getSourceTopView().getViewID()));
                element.setAttribute("vid_target", StringUtilities.encodeAttributeValue(tvc.getTargetTopView().getViewID()));
                this.addCollectionOfPoints(element, "points", tvc.getActualPoints());
            }
        }
    }

    private void appendBounds(Element element, String elemName, Rectangle bounds) {
        Element boundsElem = element.getOwnerDocument().createElement(elemName);
        boundsElem.setAttribute("x", String.valueOf(bounds.x));
        boundsElem.setAttribute("y", String.valueOf(bounds.y));
        boundsElem.setAttribute("width", String.valueOf(bounds.width));
        boundsElem.setAttribute("height", String.valueOf(bounds.height));
        element.appendChild(boundsElem);
    }

    private void addCollectionOfPoints(Element element, String elemName, Collection points) {
        if (points.size() > 0) {
            Document doc = element.getOwnerDocument();
            Element elem = doc.createElement(elemName);
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                Element pelem = doc.createElement("point");
                Point2D p = (Point2D)obj;
                pelem.setAttribute("x", String.valueOf((int)p.getX()));
                pelem.setAttribute("y", String.valueOf((int)p.getY()));
                elem.appendChild(pelem);
            }
            element.appendChild(elem);
        }
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        return this.transformFromObjectToString(object, false);
    }

    public String transformFromObjectToString(Object object, boolean processExternals) {
        try {
            Document doc = this.transformFromObject(object, processExternals);
            TransformerFactory transformerFactory = XMLFromObjTransformer.transformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public Document transformListOfObject(List list, String rootName) {
        return this.transformListOfObject(list, rootName, false);
    }

    public Document transformListOfObject(List list, String rootName, boolean processExternals) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            Element rootElement = rootName != null && !"".equals(rootName) ? doc.createElement(rootName) : doc.createElement("objects");
            if (rootElement != null) {
                doc.appendChild(rootElement);
                for (Object object : list) {
                    Element element = this.transformFromObject(object, null, doc, processExternals);
                    if (element == null) continue;
                    rootElement.appendChild(element);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }
}

