/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.lang.reflect.Method;

public class PropertySetter {
    Class cl;
    String propertyName;
    String getMethod;
    String setMethod;
    Method getter;
    Method setter;
    Class[] params = new Class[]{String.class};

    public PropertySetter(Class cl, String propertyName, String getMethod, String setMethod) {
        this.cl = cl;
        this.propertyName = propertyName;
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.init();
    }

    void init() {
        try {
            this.getter = this.cl.getMethod(this.getMethod, null);
            this.setter = this.cl.getMethod(this.setMethod, this.params);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public boolean setProperty(Object object, String value) {
        if (this.setter != null) {
            String obj = value;
            try {
                this.setter.invoke(object, obj);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getProperty(Object object) {
        Method method = this.getter;
        if (method != null && method.getDeclaringClass().isInstance(object)) {
            try {
                Object result = method.invoke(object, new Object[0]);
                return (String)result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

