/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TriggerPropertyDialogUDBv81;

public class TriggerUDBv81
extends TriggerUDB {
    protected TableViewProxyUDBv81 view;
    public static final String INSTEAD_OF = "INSTEAD OF";
    public static final String AFTER = "AFTER";
    public static final String NO_CASCADE_BEFORE = "NO CASCADE BEFORE";
    public static final String[] TRIGGER_TIMES_TABLE = new String[]{"NO CASCADE BEFORE", "AFTER", "INSTEAD OF"};
    public static final String[] TRIGGER_TIMES_VIEW = new String[]{"INSTEAD OF"};

    public TriggerUDBv81(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public TableViewProxyUDBv81 getView() {
        return this.view;
    }

    public void setView(TableViewProxyUDBv81 view) {
        if (view != null) {
            this.view = view;
            this.table = null;
            this.setTriggerTime(INSTEAD_OF);
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setTable(TableProxyUDB table) {
        if (table != null) {
            this.table = table;
            this.view = null;
            this.fireDataFieldChange();
        }
    }

    @Override
    public String[] getTriggerTimes() {
        if (this.view != null) {
            return TRIGGER_TIMES_VIEW;
        }
        return TRIGGER_TIMES;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TriggerPropertyDialogUDBv81 dialog = new TriggerPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TriggerUDBv81 trigger = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getTriggerSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                trigger = (TriggerUDBv81)storageObject;
            }
        } else {
            trigger = (TriggerUDBv81)((StorageDesignUDBv81)targetDesign).getTriggerSet().createTrigger();
        }
        if (trigger != null) {
            trigger.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 scheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv81 newScheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    trigger.setSchema(newScheme);
                } else {
                    trigger.setSchema(scheme);
                }
            }
            trigger.setActions(this.getActions());
            trigger.setTriggerTime(this.getTriggerTime());
            trigger.setScope(this.getScope());
            trigger.setRef_OLD_AS(this.getRef_OLD_AS());
            trigger.setRef_NEW_AS(this.getRef_NEW_AS());
            trigger.setOLD_TABLE_AS(this.getOLD_TABLE_AS());
            trigger.setNEW_TABLE_AS(this.getNEW_TABLE_AS());
            trigger.setCondition(this.getCondition());
            trigger.setOrder(this.getOrder());
            trigger.recreateColumnSet(this.getColumnSet().toString());
            trigger.setBody(this.getBody());
            trigger.setComment(this.getComment());
            trigger.setCommentInRDBMS(this.getCommentInRDBMS());
            trigger.setRawObject(false);
        }
    }
}

