/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k;

import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.DataBaseSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TriggerSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UserSqlServerv2k;

public class TableViewProxySqlServerv2k
extends TableViewProxySqlServer {
    public TableViewProxySqlServerv2k(TableView view, StorageDesign storage) {
        super(view, storage);
    }

    public TableViewProxySqlServerv2k(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView view = (TableView)((StorageDesignSqlServerv2k)targetDesign).getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxySqlServerv2k viewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignSqlServerv2k)targetDesign).getTableViewProxySet().getProxy(view.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            viewProxy = (TableViewProxySqlServerv2k)storageObject;
        }
        if (viewProxy != null) {
            viewProxy.setName(this.getName());
            for (IndexOnViewSqlServerv2k viewIndex : this.getIndexesOnView()) {
                IndexOnViewSqlServerv2k targetViewIndex = (IndexOnViewSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getIndexOnViewSet().getByName(viewIndex.getName());
                if (targetViewIndex == null) {
                    IndexOnViewSqlServerv2k newViewIndex = (IndexOnViewSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getIndexOnViewSet().createIndexOnView();
                    newViewIndex.setName(viewIndex.getName());
                    newViewIndex.setRawObject(true);
                    newViewIndex.setView(viewProxy);
                    viewProxy.addIndexesFromDesign(((StorageDesignSqlServerv2k)targetDesign).getIndexOnViewSet());
                    continue;
                }
                targetViewIndex.setView(viewProxy);
                viewProxy.addIndexesFromDesign(((StorageDesignSqlServerv2k)targetDesign).getIndexOnViewSet());
            }
            for (TriggerSqlServerv2k trigger : this.getTriggers()) {
                TriggerSqlServerv2k targetTrigger = (TriggerSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerSqlServerv2k newTrigger = (TriggerSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setView(viewProxy);
                    viewProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setView(viewProxy);
                viewProxy.addTriggersFromDesign(((StorageDesignSqlServerv2k)targetDesign).getTriggerSet());
            }
            if (this.getDataBase() != null) {
                DataBaseSqlServerv2k database = (DataBaseSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getDataBaseSet().getByName(this.getDataBase().getName());
                if (database == null) {
                    DataBaseSqlServerv2k newDatabase = (DataBaseSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDataBase().getName());
                    newDatabase.setRawObject(true);
                    viewProxy.setDataBase(newDatabase);
                } else {
                    viewProxy.setDataBase(database);
                }
            }
            if (this.getUser() != null) {
                UserSqlServerv2k user = (UserSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserSqlServerv2k newUser = (UserSqlServerv2k)((StorageDesignSqlServerv2k)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    viewProxy.setUser(newUser);
                } else {
                    viewProxy.setUser(user);
                }
            }
            viewProxy.setCheckOption(this.getCheckOption());
            viewProxy.setEncryption(this.getEncryption());
            viewProxy.setSchemaBinding(this.getSchemaBinding());
            viewProxy.setViewMetaData(this.getViewMetaData());
            viewProxy.setDefinition(this.getDefinition());
            viewProxy.recreateExtPropertiesSet(this.getExtPropsSet().toString());
            viewProxy.setComment(this.getComment());
            viewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            viewProxy.setRawObject(false);
        }
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }
}

