/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.QuotaItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.UserPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.propertymap.ComplexPropertyWrapper;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class UserOraclev9i
extends UserOracle
implements PropertiesPropagator {
    protected String identifiedByPassword = "";
    protected static final String[] PRIVILEGES = new String[]{"CREATE CLUSTER", "CREATE ANY CLUSTER", "ALTER ANY CLUSTER", "DROP ANY CLUSTER", "CREATE ANY CONTEXT", "DROP ANY CONTEXT", "CREATE TABLE", "ALTER DATABASE", "ALTER SYSTEM", "AUDIT SYSTEM", "CREATE DATABASE LINK", "CREATE PUBLIC DATABASE LINK", "DROP PUBLIC DATABASE LINK", "CREATE DIMENSION", "CREATE ANY DIMENSION", "ALTER ANY DIMENSION", "DROP ANY DIMENSION", "CREATE ANY DIRECTORY", "DROP ANY DIRECTORY", "CREATE INDEXTYPE", "CREATE ANY INDEXTYPE", "DROP ANY INDEXTYPE", "EXECUTE ANY INDEXTYPE", "ALTER ANY INDEXTYPE", "CREATE ANY INDEX", "ALTER ANY INDEX", "DROP ANY INDEX", "QUERY REWRITE", "GLOBAL QUERY REWRITE", "CREATE LIBRARY", "CREATE ANY LIBRARY", "DROP LIBRARY", "DROP ANY LIBRARY", "CREATE MATERIALIZED VIEW", "CREATE ANY MATERIALIZED VIEW", "ALTER ANY MATERIALIZED VIEW", "DROP ANY MATERIALIZED VIEW", "CREATE OPERATOR", "CREATE ANY OPERATOR", "DROP ANY OPERATOR", "EXECUTE ANY OPERATOR", "CREATE ANY OUTLINE", "ALTER ANY OUTLINE", "DROP ANY OUTLINE", "CREATE PROCEDURE", "CREATE ANY PROCEDURE", "ALTER ANY PROCEDURE", "DROP ANY PROCEDURE", "EXECUTE ANY PROCEDURE", "CREATE PROFILE", "ALTER PROFILE", "DROP PROFILE", "CREATE ROLE", "ALTER ANY ROLE", "DROP ANY ROLE", "GRANT ANY ROLE", "CREATE ROLLBACK SEGMENT", "ALTER ROLLBACK SEGMENT", "DROP ROLLBACK SEGMENT", "CREATE SEQUENCE", "CREATE ANY SEQUENCE", "ALTER ANY SEQUENCE", "DROP ANY SEQUENCE", "SELECT ANY SEQUENCE", "CREATE SESSION", "ALTER RESOURCE COST", "ALTER SESSION", "RESTRICTED SESSION", "CREATE SNAPSHOT", "CREATE ANY SNAPSHOT", "ALTER ANY SNAPSHOT", "DROP ANY SNAPSHOT", "CREATE SYNONYM", "CREATE ANY SYNONYM", "CREATE PUBLIC SYNONYM", "DROP ANY SYNONYM", "DROP PUBLIC SYNONYM", "CREATE ANY TABLE", "ALTER ANY TABLE", "BACKUP ANY TABLE", "DELETE ANY TABLE", "DROP ANY TABLE", "INSERT ANY TABLE", "LOCK ANY TABLE", "UPDATE ANY TABLE", "SELECT ANY TABLE", "CREATE TABLESPACE", "ALTER TABLESPACE", "DROP TABLESPACE", "MANAGE TABLESPACE", "UNLIMITED TABLESPACE", "CREATE TRIGGER", "CREATE ANY TRIGGER", "ALTER ANY TRIGGER", "DROP ANY TRIGGER", "ADMINISTER DATABASE TRIGGER", "CREATE TYPE", "CREATE ANY TYPE", "ALTER ANY TYPE", "DROP ANY TYPE", "EXECUTE ANY TYPE", "CREATE USER", "ALTER USER", "BECOME USER", "DROP USER", "CREATE VIEW", "CREATE ANY VIEW", "DROP ANY VIEW", "ANALYZE ANY", "AUDIT ANY", "COMMENT ANY TABLE", "FORCE ANY TRANSACTION", "FORCE TRANSACTION", "GRANT ANY PRIVILEGE", "SYSDBA", "SYSOPER", "ON COMMIT REFRESH", "FLASHBACK ANY TABLE", "UNDER ANY TYPE", "UNDER ANY VIEW", "EXEMPT ACCESS POLICY", "GRANT ANY OBJECT PRIVILEGE", "RESUMABLE", "SELECT ANY DICTIONARY"};
    public static final List PRIVILEGESLIST = Arrays.asList(PRIVILEGES);
    protected List propertyWrapperList = null;

    public UserOraclev9i(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public static List getPrivilegesValues() {
        Collections.sort(PRIVILEGESLIST, new StringComparator());
        return PRIVILEGESLIST;
    }

    public String getIdentifiedByPassword() {
        return this.identifiedByPassword;
    }

    public void setIdentifiedByPassword(String identifiedByPassword) {
        this.identifiedByPassword = identifiedByPassword;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            UserPropertyDialogOraclev9i dialog = new UserPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        UserOraclev9i user = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                user = (UserOraclev9i)stObject;
            }
        } else {
            user = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
        }
        if (user != null) {
            AbstractStorageObjectOracle newTableSpace;
            AbstractStorageObjectOracle tableSpace;
            user.setName(this.getName());
            user.setAuthType(this.getAuthType());
            user.setIdentifier(this.getIdentifier());
            for (QuotaItemOraclev9i quotaItem : this.getQuotaItems()) {
                QuotaItemOraclev9i targetQuotaItem = (QuotaItemOraclev9i)((StorageDesignOraclev9i)targetDesign).getQuotaItemSet().getByName(quotaItem.getName());
                if (targetQuotaItem == null) {
                    QuotaItemOraclev9i newQuotaItem = (QuotaItemOraclev9i)((StorageDesignOraclev9i)targetDesign).getQuotaItemSet().createQuotaItem();
                    newQuotaItem.setName(quotaItem.getName());
                    newQuotaItem.setUser(user);
                    newQuotaItem.setRawObject(true);
                    user.getQuotaItems().add(newQuotaItem);
                    continue;
                }
                targetQuotaItem.setUser(user);
                user.getQuotaItems().add(targetQuotaItem);
            }
            if (this.getDefTableSpace() != null) {
                tableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getDefTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    ((TableSpaceOracle)newTableSpace).setName(this.getDefTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    user.setDefTableSpace((TableSpaceOracle)newTableSpace);
                } else {
                    user.setDefTableSpace((TableSpaceOracle)tableSpace);
                }
            }
            if (this.getTempTableSpace() != null) {
                tableSpace = (TemporaryTablespaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTemporaryTablespaceSet().getByName(this.getTempTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = (TemporaryTablespaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
                    newTableSpace.setName(this.getTempTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    user.setTempTableSpace((TemporaryTablespaceOracle)newTableSpace);
                } else {
                    user.setTempTableSpace((TemporaryTablespaceOracle)tableSpace);
                }
            }
            user.setProfile(this.getProfile());
            user.setPasswordExpire(this.getPasswordExpire());
            user.setAccountLock(this.getAccountLock());
            user.setExternalName(this.getExternalName());
            user.setAdminOption(this.getAdminOption());
            user.setIdentifiedByPassword(this.getIdentifiedByPassword());
            user.recreateSystemPrivilegesSet(this.getPrivilegesSet().toString());
            user.recreateRoleSet(this.getRolesSet().toString());
            user.setComment(this.getComment());
            user.setRawObject(false);
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.DefaultTablespace"), this, "getDefTableSpace", "setDefTableSpace", TableSpaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.TempTableSpace"), this, "getTempTableSpace", "setTempTableSpace", TemporaryTablespaceOracle.class));
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.Privileges"), this, "getPrivileges", "setPrivileges", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.PrivilegesAdmin"), this, "getPrivilegesWithAdminOption", "setPrivilegesWithAdminOption", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.Roles"), this, "getRoles", "setRoles", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserPropertyDialogOracle.RolesAdmin"), this, "getRolesWithAdminOption", "setRolesWithAdminOption", String.class));
            ComplexPropertyWrapper pw = new ComplexPropertyWrapper(oracle.dbtools.crest.swingui.editor.storage.oracle.Messages.getString("UserAndRolePermissionsDialogOracle.Permissions"), this);
            pw.addCollectionName("permissions");
            this.propertyWrapperList.add(pw);
            pw = new ComplexPropertyWrapper(Messages.getString("UserOracle.Quotas"), this);
            pw.addCollectionName("quotaItems");
            this.propertyWrapperList.add(pw);
        }
        return this.propertyWrapperList;
    }
}

