/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxySetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceOraclev10g
extends TableSpaceOraclev9i {
    private DiskGroupOraclev10g diskGroup;
    private static Set fileTypeSet = null;
    public static final String BIGFILE = "BIGFILE";
    public static final String SMALLFILE = "SMALLFILE";
    private String fileType = FILE_TYPES[0];
    private static final String[] FILE_TYPES = new String[]{"", "BIGFILE", "SMALLFILE"};
    private static final String[] FLASHBACK_STATES = new String[]{"ON", "OFF"};
    private static List flashBackList = Arrays.asList(FLASHBACK_STATES);
    private static Set flashBackSet = null;
    private String flashBack = FLASHBACK_STATES[0];
    private static Set dsCompressionSet = null;
    private String dsCompression = DS_COMPRESSION_CHOICES[0];
    private static final String[] DS_COMPRESSION_CHOICES = new String[]{"", "NOCOMPRESS", "COMPRESS"};
    public static final String BASIC = "BASIC";
    public static final String ADVANCED = "ADVANCED";
    public static final String OLTP = "OLTP";
    public static final String QUERY_LOW = "QUERY LOW";
    public static final String QUERY_HIGH = "QUERY HIGH";
    public static final String ARCHIVE_LOW = "ARCHIVE LOW";
    public static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String[] COMPRESSION_TYPE_CHOICES_11g = new String[]{"", "BASIC", "OLTP", "QUERY LOW", "QUERY HIGH", "ARCHIVE LOW", "ARCHIVE HIGH"};
    private static final String[] COMPRESSION_TYPE_CHOICES_12c = new String[]{"", "BASIC", "ADVANCED", "QUERY LOW", "QUERY HIGH", "ARCHIVE LOW", "ARCHIVE HIGH"};
    private static Set compressionTypeSet = null;
    private String compressionType = "";
    private String encrypt = "";
    private String encryptionAlgorithm = "";
    public static final String ENC_ALG_AES128 = "AES128";
    public static final String ENC_ALG_AES192 = "AES192";
    public static final String ENC_ALG_AES256 = "AES256";
    public static final String ENC_ALG_3DES168 = "3DES168";
    private static final String[] ENC_ALG_CHOICES = new String[]{"", "AES128", "AES192", "AES256", "3DES168"};
    public static final String NO_MEMCOMPRESS = "NO MEMCOMPRESS";
    public static final String FOR_DML = "FOR DML";
    public static final String FOR_QUERY = "FOR QUERY";
    public static final String FOR_QUERY_LOW = "FOR QUERY LOW";
    public static final String FOR_QUERY_HIGH = "FOR QUERY HIGH";
    public static final String FOR_CAPACITY = "FOR CAPACITY";
    public static final String FOR_CAPACITY_LOW = "FOR CAPACITY LOW";
    public static final String FOR_CAPACITY_HIGH = "FOR CAPACITY HIGH";
    private static final String[] INMEMORY_COMPRESSION_CHOICES = new String[]{"", "NO MEMCOMPRESS", "FOR DML", "FOR QUERY", "FOR QUERY LOW", "FOR QUERY HIGH", "FOR CAPACITY", "FOR CAPACITY LOW", "FOR CAPACITY HIGH"};
    public static final String NONE = "NONE";
    public static final String LOW = "LOW";
    public static final String MEDIUM = "MEDIUM";
    public static final String HIGH = "HIGH";
    public static final String CRITICAL = "CRITICAL";
    private static final String[] INMEMORY_PRIORITY_CHOICES = new String[]{"", "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"};
    public static final String AUTO = "AUTO";
    public static final String BY_ROWID_RANGE = "BY ROWID RANGE";
    public static final String BY_PARTITION = "BY PARTITION";
    public static final String BY_SUBPARTITION = "BY SUBPARTITION";
    private static final String[] INMEMORY_DISTRIBUTE_CHOICES = new String[]{"", "AUTO", "BY ROWID RANGE", "BY PARTITION", "BY SUBPARTITION"};
    public static final String NO_DUPLICATE = "NO DUPLICATE";
    public static final String DUPLICATE = "DUPLICATE";
    public static final String DUPLICATE_ALL = "DUPLICATE ALL";
    private static final String[] INMEMORY_DUPLICATE_CHOICES = new String[]{"", "NO DUPLICATE", "DUPLICATE", "DUPLICATE ALL"};
    private static Set inMemoryCompressionSet = null;
    private static Set inMemoryPrioritySet = null;
    private static Set inMemoryDistributeSet = null;
    private static Set inMemoryDuplicateSet = null;
    private String inMemory = "";
    private String inMemoryCompression = "";
    private String inMemoryPriority = "";
    private String inMemoryDistribute = "";
    private String inMemoryDuplicate = "";

    public TableSpaceOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public DiskGroupOraclev10g getDiskGroup() {
        return this.diskGroup;
    }

    public void setDiskGroup(DiskGroupOraclev10g diskGroup) {
        if (diskGroup != null || this.diskGroup != null) {
            this.diskGroup = diskGroup;
            this.fireDataFieldChange();
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String value) {
        if (this.checkFileTypeState(value)) {
            this.fileType = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkFileTypeState(String value) {
        if (fileTypeSet == null) {
            fileTypeSet = new HashSet();
            fileTypeSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFileTypes()));
        }
        return fileTypeSet.contains(value);
    }

    public static String[] getFileTypes() {
        return FILE_TYPES;
    }

    public static String[] getFlashBackChoices() {
        return FLASHBACK_STATES;
    }

    protected boolean checkFlashBack(String value) {
        if (flashBackSet == null) {
            flashBackSet = new HashSet();
            flashBackSet.addAll(Arrays.asList(TableSpaceOraclev10g.getFlashBackChoices()));
        }
        return flashBackSet.contains(value);
    }

    public void setFlashBack(String value) {
        if (this.checkFlashBack(value)) {
            this.flashBack = value;
            this.fireDataFieldChange();
        }
    }

    public String getFlashBack() {
        return this.flashBack;
    }

    public static List getFlashBackValues() {
        return flashBackList;
    }

    public String getDSCompression() {
        return this.dsCompression;
    }

    public void setDSCompression(String value) {
        if (this.checkDSCompressionState(value)) {
            this.dsCompression = value;
            this.fireDataFieldChange();
        }
    }

    private boolean checkDSCompressionState(String value) {
        if (dsCompressionSet == null) {
            dsCompressionSet = new HashSet();
            dsCompressionSet.addAll(Arrays.asList(TableSpaceOraclev10g.getDSCompressionStates()));
        }
        return dsCompressionSet.contains(value);
    }

    public static String[] getDSCompressionStates() {
        return DS_COMPRESSION_CHOICES;
    }

    public String getCompressionType() {
        if (this.compressionType.equals(OLTP) && this.getStorageDesign() instanceof StorageDesignOraclev12c) {
            return ADVANCED;
        }
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        if (!this.compressionType.equals(compressionType)) {
            if (ADVANCED.equals(compressionType)) {
                compressionType = OLTP;
            }
            if (this.checkCompressionType(compressionType)) {
                this.compressionType = compressionType;
                this.fireDataFieldChange();
            }
        }
    }

    private boolean checkCompressionType(String value) {
        if (compressionTypeSet == null) {
            compressionTypeSet = new HashSet();
            compressionTypeSet.addAll(Arrays.asList(TableSpaceOraclev10g.getCompressionTypeValuesv11g()));
        }
        return compressionTypeSet.contains(value);
    }

    public static String[] getCompressionTypeValuesv11g() {
        return COMPRESSION_TYPE_CHOICES_11g;
    }

    public static String[] getCompressionTypeValues12c() {
        return COMPRESSION_TYPE_CHOICES_12c;
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(String value) {
        if (!this.encrypt.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.encrypt = value;
            this.fireDataFieldChange();
        }
    }

    public static String[] getEncryptionAlgorithmChoices() {
        return ENC_ALG_CHOICES;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String value) {
        this.encryptionAlgorithm = value;
    }

    public String getInMemory() {
        return this.inMemory;
    }

    public void setInMemory(String value) {
        if (!this.inMemory.equals(value) && (ConstantsOracle.checkYesNo(value) || "".equals(value))) {
            this.inMemory = value;
            this.fireDataFieldChange();
        }
    }

    public String getInMemoryCompression() {
        return this.inMemoryCompression;
    }

    public void setInMemoryCompression(String inMemoryCompression) {
        if (!this.inMemoryCompression.equals(inMemoryCompression) && this.checkInMemoryCompression(inMemoryCompression)) {
            this.inMemoryCompression = inMemoryCompression;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryCompression(String value) {
        if (inMemoryCompressionSet == null) {
            inMemoryCompressionSet = new HashSet();
            inMemoryCompressionSet.addAll(Arrays.asList(TableSpaceOraclev10g.getInMemoryCompressionValues()));
        }
        return inMemoryCompressionSet.contains(value);
    }

    public static String[] getInMemoryCompressionValues() {
        return INMEMORY_COMPRESSION_CHOICES;
    }

    public String getInMemoryPriority() {
        return this.inMemoryPriority;
    }

    public void setInMemoryPriority(String inMemoryPriority) {
        if (!this.inMemoryPriority.equals(inMemoryPriority) && this.checkInMemoryPriority(inMemoryPriority)) {
            this.inMemoryPriority = inMemoryPriority;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryPriority(String value) {
        if (inMemoryPrioritySet == null) {
            inMemoryPrioritySet = new HashSet();
            inMemoryPrioritySet.addAll(Arrays.asList(TableSpaceOraclev10g.getInMemoryPriorityValues()));
        }
        return inMemoryPrioritySet.contains(value);
    }

    public static String[] getInMemoryPriorityValues() {
        return INMEMORY_PRIORITY_CHOICES;
    }

    public String getInMemoryDistribute() {
        return this.inMemoryDistribute;
    }

    public void setInMemoryDistribute(String inMemoryDistribute) {
        if (!this.inMemoryDistribute.equals(inMemoryDistribute) && this.checkInMemoryDistribute(inMemoryDistribute)) {
            this.inMemoryDistribute = inMemoryDistribute;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryDistribute(String value) {
        if (inMemoryDistributeSet == null) {
            inMemoryDistributeSet = new HashSet();
            inMemoryDistributeSet.addAll(Arrays.asList(TableSpaceOraclev10g.getInMemoryDistributeValues()));
        }
        return inMemoryDistributeSet.contains(value);
    }

    public static String[] getInMemoryDistributeValues() {
        return INMEMORY_DISTRIBUTE_CHOICES;
    }

    public String getInMemoryDuplicate() {
        return this.inMemoryDuplicate;
    }

    public void setInMemoryDuplicate(String inMemoryDuplicate) {
        if (!this.inMemoryDuplicate.equals(inMemoryDuplicate) && this.checkInMemoryDuplicate(inMemoryDuplicate)) {
            this.inMemoryDuplicate = inMemoryDuplicate;
            this.fireDataFieldChange();
        }
    }

    private boolean checkInMemoryDuplicate(String value) {
        if (inMemoryDuplicateSet == null) {
            inMemoryDuplicateSet = new HashSet();
            inMemoryDuplicateSet.addAll(Arrays.asList(TableSpaceOraclev10g.getInMemoryDuplicateValues()));
        }
        return inMemoryDuplicateSet.contains(value);
    }

    public static String[] getInMemoryDuplicateValues() {
        return INMEMORY_DUPLICATE_CHOICES;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = super.getPropertyWrapperList();
            this.propertyWrapperList.add(0, new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.FileType"), this, "getFileType", "setFileType", String.class));
            this.propertyWrapperList.add(1, new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DiskGroup"), this, "getDiskGroup", "setDiskGroup", DiskGroupOraclev10g.class));
            this.propertyWrapperList.add(8, new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.DefaultCompression"), this, "getDSCompression", "setDSCompression", String.class));
            this.propertyWrapperList.add(9, new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.CompressionType"), this, "getCompressionType", "setCompressionType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.FlashbackMode"), this, "getFlashBack", "setFlashBack", String.class));
            if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.Encrypt"), this, "getEncrypt", "setEncrypt", String.class));
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TableSpacePropertyDialogOracle.EncryptionAlgorithm"), this, "getEncryptionAlgorithm", "setEncryptionAlgorithm", String.class));
            }
            if (this.getStorageDesign() instanceof StorageDesignOraclev12c) {
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.InMemory"), this, "getInMemory", "setInMemory", String.class));
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.InMemoryCompression"), this, "getInMemoryCompression", "setInMemoryCompression", String.class));
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.InMemoryPriority"), this, "getInMemoryPriority", "setInMemoryPriority", String.class));
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.InMemoryDistribute"), this, "getInMemoryDistribute", "setInMemoryDistribute", String.class));
                this.propertyWrapperList.add(new PropertyWrapper(this.getPropertyDialogName("TablePropertyDialogOracle.InMemoryDuplicate"), this, "getInMemoryDuplicate", "setInMemoryDuplicate", String.class));
            }
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceOraclev10g tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceOraclev10g)stObject;
            }
        } else {
            tableSpace = (TableSpaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setObjectID(this.getObjectID());
            tableSpace.setName(this.getName());
            for (StorageObjectPlaceHolder tables : this.getTabcoll()) {
                TableProxyOraclev10g targetTables = (TableProxyOraclev10g)((TableProxySetOraclev10g)targetDesign.getTableProxySet()).getByName(tables.getName());
                if (targetTables == null) {
                    TableProxyOraclev10g newTable = (TableProxyOraclev10g)((TableProxySetOraclev10g)targetDesign.getTableProxySet()).createProxy(tables.getGenerator());
                    newTable.setName(tables.getName());
                    newTable.setTableSpace(tableSpace);
                    newTable.setRawObject(true);
                    tableSpace.registerToTableProxyFromDesign(targetDesign.getTableProxySet());
                    continue;
                }
                targetTables.setTableSpace(tableSpace);
                tableSpace.registerToTableProxyFromDesign(targetDesign.getTableProxySet());
            }
            for (DataFileOraclev10g dataFile : this.getDfiles()) {
                DataFileOraclev10g targetDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileOraclev10g newDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setTableSpace(tableSpace);
                    newDataFile.setRawObject(true);
                    tableSpace.getDfiles().add(newDataFile);
                    continue;
                }
                targetDataFile.setTableSpace(tableSpace);
                tableSpace.getDfiles().add(targetDataFile);
            }
            tableSpace.setDiskGroup(this.getDiskGroup());
            tableSpace.setMinExtLen(this.getMinExtLen());
            tableSpace.setBlockSize(this.getBlockSize());
            tableSpace.setLogging(this.getLogging());
            tableSpace.setForceLogging(this.getForceLogging());
            tableSpace.setStatus(this.getStatus());
            tableSpace.setContents(this.getContents());
            tableSpace.setDSInitialExtent(this.getDSInitialExtent());
            tableSpace.setDSNextExtent(this.getDSNextExtent());
            tableSpace.setDSMinExtents(this.getDSMinExtents());
            tableSpace.setDSMaxExtents(this.getDSMaxExtents());
            tableSpace.setDSPctIncrease(this.getDSPctIncrease());
            tableSpace.setExtentManagement(this.getExtentManagement());
            tableSpace.setEMLocalSubtype(this.getEMLocalSubtype());
            tableSpace.setEMUniformSize(this.getEMUniformSize());
            tableSpace.setSegmentManagement(this.getSegmentManagement());
            tableSpace.setFileType(this.getFileType());
            tableSpace.setFlashBack(this.getFlashBack());
            tableSpace.setDSCompression(this.getDSCompression());
            tableSpace.setCompressionType(this.getCompressionType());
            tableSpace.setEncrypt(this.getEncrypt());
            tableSpace.setEncryptionAlgorithm(this.getEncryptionAlgorithm());
            tableSpace.setInMemory(this.getInMemory());
            tableSpace.setInMemoryCompression(this.getInMemoryCompression());
            tableSpace.setInMemoryPriority(this.getInMemoryPriority());
            tableSpace.setInMemoryDistribute(this.getInMemoryDistribute());
            tableSpace.setInMemoryDuplicate(this.getInMemoryDuplicate());
            tableSpace.setComment(this.getComment());
            tableSpace.setRawObject(false);
        }
    }
}

