/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;

public abstract class ColumnProxySetDB2
extends ColumnProxySet {
    public ColumnProxySetDB2(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public abstract RelationalObjectProxy createProxy(DesignObject var1);

    @Override
    public void doAfterAdd(RelationalObjectProxy addedProxy) {
        ColumnProxyDB2 proxy = (ColumnProxyDB2)addedProxy;
        Column column = (Column)proxy.getObject();
        String defaultConstant = proxy.getDefaultValueConstant();
        if (defaultConstant == null || "".equalsIgnoreCase(defaultConstant)) {
            String colDefaultValue = column.getDefaultValue();
            boolean colUsesDefault = column.getUsesDefaultValue();
            proxy.setDefault(colUsesDefault);
            if (colUsesDefault) {
                proxy.setDefaultValue(ColumnProxyDB2.getDefaultValueChoices()[1]);
                proxy.setDefaultValueConstant(colDefaultValue);
                proxy.setDefault(true);
            }
        }
    }

    @Override
    public ColumnProxyDB2 getByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ColumnProxyDB2 cpo = (ColumnProxyDB2)it.next();
            if (!name.equals(cpo.getName())) continue;
            return cpo;
        }
        return null;
    }
}

