/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.editor.process.EventPropertiesDialogEx;

public class Event
extends AbstractProcessObject {
    public static final String[] DAYS_OF_WEEK_DISPLAY = new String[]{Messages.getString("Event.MondaythruSunday"), Messages.getString("Event.MondaythruFriday"), Messages.getString("Event.Monday"), Messages.getString("Event.Tuesday"), Messages.getString("Event.Wednesday"), Messages.getString("Event.Thursday"), Messages.getString("Event.Friday"), Messages.getString("Event.Saturday"), Messages.getString("Event.Sunday")};
    public static final String[] DAYS_OF_WEEK = new String[]{"Monday thru Sunday", "Monday thru Friday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    public static final String[] MONTHS_DISPLAY = new String[]{Messages.getString("Event.AllMonths"), Messages.getString("Event.January"), Messages.getString("Event.February"), Messages.getString("Event.March"), Messages.getString("Event.April"), Messages.getString("Event.May"), Messages.getString("Event.June"), Messages.getString("Event.July"), Messages.getString("Event.August"), Messages.getString("Event.September"), Messages.getString("Event.October"), Messages.getString("Event.November"), Messages.getString("Event.December")};
    public static final String[] MONTHS = new String[]{"All Months", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] EVENT_TYPE_NAMES = new String[]{Messages.getString("Event.TypeInfoFlow"), Messages.getString("Event.TypeClockCalendar"), Messages.getString("Event.TypePerson"), Messages.getString("Event.TypeStorage")};
    public static final int QUARTER_ALL = 0;
    public static final int QUARTER_1 = 1;
    public static final int QUARTER_2 = 2;
    public static final int QUARTER_3 = 3;
    public static final int QUARTER_4 = 4;
    public static final int AT_OPEN_OF_BUSINESS_DAY = 1;
    public static final int AT_CLOSE_OF_BUSINESS_DAY = 2;
    public static final int WHEN_CONVENIENT_DURING_DAY = 3;
    public static final int AT_SPECIFIED_TIME = 4;
    public static final int TYPE_INFO_FLOW = 0;
    public static final int TYPE_CLOCK_CALENDAR = 1;
    public static final int TYPE_PERSON = 2;
    public static final int TYPE_STORAGE = 3;
    private int eventType = 0;
    private String text = "";
    private List processTriggered = new ArrayList();
    private Flow flow;
    private int frequency = 0;
    private boolean onDay = true;
    private String dayOfWeek = DAYS_OF_WEEK[0];
    private int dayOfMonth = 0;
    private String months = MONTHS[0];
    private int quarter = 0;
    private int year = 0;
    private boolean fiscal = true;
    private int timesWhenRun = 1;
    private boolean atTime;
    private int hour = 0;
    private int minute = 0;
    private int timeFreq = 0;
    public static final String TYPE_NAME = "Event";

    public Event(DesignPart designPart, int eventType) {
        super(designPart);
        this.eventType = eventType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "EVN";
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isAtTime() {
        return this.atTime;
    }

    public void setAtTime(boolean atTime) {
        this.atTime = atTime;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public boolean isFiscal() {
        return this.fiscal;
    }

    public void setFiscal(boolean fiscal) {
        this.fiscal = fiscal;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public String getMonths() {
        return this.months;
    }

    public void setMonths(String months) {
        this.months = months;
    }

    public boolean isOnDay() {
        return this.onDay;
    }

    public void setOnDay(boolean onDay) {
        this.onDay = onDay;
    }

    public int getQuarter() {
        return this.quarter;
    }

    public void setQuarter(int quarter) {
        this.quarter = quarter;
    }

    public int getTimesWhenRun() {
        return this.timesWhenRun;
    }

    public void setTimesWhenRun(int timesWhenRun) {
        this.timesWhenRun = timesWhenRun;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getEventTypeName() {
        return EVENT_TYPE_NAMES[this.eventType];
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            EventPropertiesDialogEx dialog = new EventPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public int getTimeFreq() {
        return this.timeFreq;
    }

    public void setTimeFreq(int timeFreq) {
        this.timeFreq = timeFreq;
    }

    public List getProcessTriggered() {
        return this.processTriggered;
    }

    public void addProcess(Process process) {
        if (process != null && !this.processTriggered.contains(process)) {
            this.processTriggered.add(process);
        }
    }

    public void removeProcess(Process process) {
        if (this.processTriggered.contains(process)) {
            this.processTriggered.remove(process);
        }
    }

    public void removeFromProcessTriggered() {
        for (Process process : this.getProcessTriggered()) {
            process.getEvents().remove(this);
        }
    }

    public void removeFromFlow() {
        if (this.flow != null) {
            this.flow.setEvent(null);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "event" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getEventTypeDecoded() {
        if (this.eventType >= 0 && this.eventType < EVENT_TYPE_NAMES.length) {
            return EVENT_TYPE_NAMES[this.eventType];
        }
        return "";
    }
}

