/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewUDB
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewUDB.class);

    public MOHViewUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT a.tabname,a.ROWTYPESCHEMA,a.ROWTYPENAME, ");
                buffer.append("  b.super_schema, b.super_name ");
                buffer.append(" from syscat.tables a left join syscat.hierarchies b ");
                buffer.append("  on a.rowtypename = b.sub_name ");
                buffer.append("  and a.rowtypeschema = b.sub_schema ");
                buffer.append("WHERE TYPE in ('V','W') and tabschema  = '");
                buffer.append(dboNext.getName()).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    String tableTypeOwner = rs.getString(2);
                    String tableType = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject dboView = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, "VIEW", dboNext.getName());
                    dboView.setTypeName(tableType);
                    dboView.setTypeOwner(tableTypeOwner);
                    dboView.setSuperTypeOwner(superTypeOwner);
                    dboView.setSuperTypeName(superTypeName);
                    list.add(dboView);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        String url = sqlConnection.getMetaData().getURL().toLowerCase();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String schemaName = dbo.getSchema();
            if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT  V.VIEWNAME,V.VIEWCHECK,V.READONLY,V.TEXT ,t.REMARKS  ");
                buffer.append("FROM syscat.VIEWS v,syscat.TABLES t ");
                buffer.append("WHERE TABSCHEMA = '").append(schemaName).append("'");
                buffer.append(" AND  TABNAME = '").append(name).append("'");
                buffer.append(" AND  t.TABSCHEMA = v.VIEWSCHEMA");
                buffer.append(" AND  TABNAME = v.VIEWNAME");
                buffer.append(" AND t.TYPE IN ('V','W')");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewUDB.generate():", e);
                LOGGER.error("MOHViewUDB: name: " + name);
            }
            if (rs != null) {
                if (rs.next()) {
                    String checkOption = rs.getString(2);
                    String definition = "";
                    if (url.startsWith("jdbc:odbc")) {
                        try {
                            definition = new Scanner(rs.getBinaryStream(4), "UTF-8").useDelimiter("\\A").next();
                        }
                        catch (Exception e) {
                            definition = rs.getString(4);
                        }
                    } else {
                        definition = rs.getString(4);
                    }
                    String comments = rs.getString(5);
                    TableView view = this.getRelationalDesign().getTableViewSet().createTableView(null);
                    view.setName(name);
                    view.setSchema(schemaName);
                    this.stampModelObject(view, dbo);
                    view.setSyntaxProvider("DB2");
                    if (dbo.getTypeName() != null) {
                        StructuredTypeProxy stp = ((StructuredTypeProxySetUDB)this.getStorageDesign().getStructuredTypeProxySet()).getBySchemaAndName(dbo.getTypeOwner(), dbo.getTypeName());
                        if (stp != null) {
                            view.setBasedOnStructuredType(stp.getStructuredType());
                        }
                    } else {
                        view.setUserDefined(true);
                        view.getColumns(definition.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
                    }
                    view.setCommentInRDBMS(comments);
                    view.setUserDefinedSQL(this.parseAsSelect(definition));
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
                        SchemaUDB schema;
                        StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                        TableViewProxyUDB proxy = (TableViewProxyUDB)storage.getTableViewProxySet().getProxy(view.getObjectID());
                        if (!"N".equalsIgnoreCase(checkOption)) {
                            proxy.setCheckOption(true);
                            if ("L".equalsIgnoreCase(checkOption)) {
                                proxy.setCheckOptionScope("LOCAL");
                            }
                        }
                        if ((schema = (SchemaUDB)storage.getSchemaSet().getByName(schemaName)) != null) {
                            proxy.setSchema(schema);
                            proxy.setOwner(schema.getOwner());
                        }
                    }
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private String parseAsSelect(String userDef) {
        String beforeAs = Token.getStringBefore2(userDef, "AS");
        String afterAs = Token.getStringAfter(userDef, "AS");
        if (!"".equals(beforeAs) && !"".equals(afterAs) && afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
            return beforeAs + " AS " + afterAs;
        }
        return userDef;
    }
}

