/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHAliasUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "ALIAS";
    private static final Logger LOGGER = new Logger(MOHAliasUDB.class);

    public MOHAliasUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String schemaName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT  t.TABNAME aliasname,t.BASE_TABSCHEMA objectschema, ");
                buffer.append(" t.BASE_TABNAME objectname,a.TYPE objecttype ");
                buffer.append("FROM syscat.TABLES t,syscat.TABLES a ");
                buffer.append("WHERE t.type = 'A' and t.tabschema = '");
                buffer.append(schemaName).append("'");
                buffer.append(" AND t.tabname = '");
                buffer.append(dbo.getName()).append("'");
                buffer.append(" AND T.BASE_TABSCHEMA =a.TABSCHEMA");
                buffer.append(" AND T.BASE_TABNAME = a.TABNAME");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHAliasUDB.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    String objectName = rs.getString(3);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
                        TableProxyUDB t;
                        StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                        AliasUDB alias = storage.getAliasSet().createAlias();
                        alias.setName(name);
                        this.stampModelObject(alias, dbo);
                        SchemaUDB schema = (SchemaUDB)storage.getSchemaSet().getByName(schemaName);
                        if (schema != null) {
                            alias.setSchema(schema);
                        }
                        if ((t = ((TableProxySetUDB)storage.getTableProxySet()).getByName(objectName)) != null) {
                            alias.setReferencedObject(t);
                        } else {
                            TableViewProxyUDB v = ((TableViewProxySetUDB)storage.getTableViewProxySet()).getByName(objectName);
                            if (v != null) {
                                alias.setReferencedObject(v);
                            } else {
                                AliasUDB a = (AliasUDB)storage.getAliasSet().getByName(objectName);
                                if (a != null) {
                                    alias.setReferencedObject(a);
                                } else if (schema != null) {
                                    alias.setReferencedObject(schema);
                                }
                            }
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME from SYSCAT.TABLES").append(' ');
                buffer.append("WHERE TYPE = 'A' and TABSCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHAliasUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }
}

