/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateClusterOraclev9i
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateClusterOraclev9i.class);

    public SHCreateClusterOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateClusterOraclev9i.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "CREATE CLUSTER")) {
            this.parseCluster(statement);
        } else {
            this.nextHandler(line);
        }
    }

    public void parseCluster(String statement) {
        ClusterOraclev9i cluster;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev9i stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(site);
        if (stoDesign != null && (cluster = (ClusterOraclev9i)stoDesign.getClusterSet().createCluster()) != null) {
            try {
                this.initName(cluster);
                this.initUser(cluster, stoDesign);
                this.initColumns(cluster, stoDesign);
                this.initSegment(cluster, stoDesign);
                this.initSize(cluster);
                this.initTableSpace(cluster, stoDesign);
                this.initIndex(cluster);
                this.initSingleTable(cluster);
                this.initHashKeys(cluster);
                this.initParallel(cluster);
                this.initRowDependency(cluster);
                this.initCache(cluster);
                this.design.getRelationalDesign().stampModelObjectDDL(cluster);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for Oracle failed!");
                this.importLog.addFailedStatement(SHCreateClusterOraclev9i.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initRowDependency(ClusterOraclev9i cluster) {
        if (Token.hasToken(this.statement, "ROWDEPENDENCIES")) {
            cluster.setRowDependency("YES");
        } else if (Token.hasToken(this.statement, "NOROWDEPENDENCIES")) {
            cluster.setRowDependency("NO");
        }
    }

    private void initName(ClusterOraclev9i cluster) {
        String startOfName = Token.getStringAfterToken(this.statement, "CLUSTER");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.userName = name.substring(0, posPoint);
            name = name.substring(posPoint + 1);
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        cluster.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            cluster.setNameHasQuotes(true);
        }
    }

    private void initUser(ClusterOraclev9i cluster, StorageDesignOraclev9i storageDesign) {
        if (this.userName != null) {
            UserOraclev9i user = (UserOraclev9i)storageDesign.getUserSet().getByName(this.userName);
            if (user == null) {
                user = (UserOraclev9i)storageDesign.getUserSet().createUser();
                user.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            cluster.setUser(user);
        }
    }

    private void initColumns(ClusterOraclev9i cluster, StorageDesignOraclev9i storageDesign) {
        String line = Token.getStringAfter(this.statement, Token.getTokenAfter(this.statement, "CLUSTER").trim());
        if (line.indexOf("(") == 0) {
            String columns = Token.getValBetweenBrackets(line, 1);
            int columnNumber = 1;
            StringTokenizer tokenizer = new StringTokenizer(columns, ",");
            while (tokenizer.hasMoreTokens()) {
                String columnType;
                int bracketIndex;
                Object oneColumn = tokenizer.nextToken();
                while (Token.hasOpenBracket((String)oneColumn) && tokenizer.hasMoreTokens()) {
                    oneColumn = (String)oneColumn + "," + tokenizer.nextToken();
                }
                oneColumn = ((String)oneColumn).trim();
                String columnName = Token.getFirstName((String)oneColumn, '\"', '\"');
                boolean colNameQuoted = ((String)oneColumn).startsWith("\"");
                if (colNameQuoted) {
                    if (((String)(oneColumn = ((String)oneColumn).substring(columnName.length() + 1))).startsWith("\"")) {
                        oneColumn = ((String)oneColumn).substring(1);
                    }
                } else {
                    oneColumn = ((String)oneColumn).substring(columnName.length());
                }
                if ((bracketIndex = (columnType = Token.getFirstToken((String)(oneColumn = ((String)oneColumn).trim().toUpperCase()))).indexOf("(")) >= 0) {
                    columnType = columnType.substring(0, bracketIndex);
                }
                if (columnType.equals("TIMESTAMP")) {
                    if (((String)oneColumn).indexOf("WITH") >= 0) {
                        columnType = ((String)oneColumn).indexOf("LOCAL") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : "TIMESTAMP WITH TIME ZONE";
                    }
                } else if (columnType.equals("INTERVAL")) {
                    if (((String)oneColumn).indexOf("YEAR") >= 0) {
                        columnType = "INTERVAL YEAR TO MONTH";
                    } else if (((String)oneColumn).indexOf("DAY") >= 0) {
                        columnType = "INTERVAL DAY TO SECOND";
                    }
                } else if (columnType.equals("DOUBLE")) {
                    columnType = "DOUBLE PRECISION";
                }
                ClusterColumnOracle clusterColumn = storageDesign.getClusterColumnSet().createClusterColumn();
                clusterColumn.setCluster(cluster);
                clusterColumn.setName(columnName);
                if (colNameQuoted && !columnName.equals(columnName.toUpperCase())) {
                    clusterColumn.setNameHasQuotes(true);
                }
                this.design.getRelationalDesign().stampModelObjectDDL(clusterColumn);
                clusterColumn.setDataType(columnType);
                if (Token.hasCloseAndOpenBrackets((String)oneColumn)) {
                    if (columnType.equals("INTERVAL DAY TO SECOND")) {
                        String secondsPrecision;
                        String afterTo;
                        String afterSecond;
                        String precision;
                        String intervalType = Token.cutTokenFromFront((String)oneColumn, "INTERVAL");
                        String afterDay = Token.cutTokenFromFront(intervalType, "DAY");
                        if (afterDay.startsWith("(") && (precision = Token.getValBetweenBrackets(afterDay, 1).trim()).length() > 0) {
                            clusterColumn.setLengthPrecision(precision);
                        }
                        if ((afterSecond = Token.cutTokenFromFront(afterTo = Token.getStringAfterToken(intervalType, "TO"), "SECOND")).startsWith("(") && (secondsPrecision = Token.getValBetweenBrackets(afterSecond, 1).trim()).length() > 0) {
                            try {
                                clusterColumn.setScale(Integer.parseInt(secondsPrecision));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("Wrong precision format " + secondsPrecision);
                                this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                            }
                        }
                    } else {
                        String withinBrackets = Token.getValBetweenBrackets((String)oneColumn);
                        int commaIndex = withinBrackets.indexOf(44);
                        if (commaIndex >= 0) {
                            String afterComma = withinBrackets.substring(commaIndex + 1).trim();
                            withinBrackets = withinBrackets.substring(0, commaIndex).trim();
                            try {
                                clusterColumn.setScale(Integer.parseInt(afterComma));
                            }
                            catch (NumberFormatException exc) {
                                LOGGER.error("wrong format in SHCreateClusterOracle.initColumns : " + exc.getMessage());
                                this.importLog.addWarning("Wrong Scale value in statement " + this.statement);
                            }
                        }
                        clusterColumn.setLengthPrecision(withinBrackets);
                    }
                }
                clusterColumn.setPosition(columnNumber++);
            }
        }
    }

    private void initSegment(ClusterOraclev9i cluster, StorageDesignOraclev9i storageDesign) {
        SegmentOraclev9i segment = null;
        if (Token.hasToken(this.statement, "PCTFREE") && (segment = (SegmentOraclev9i)storageDesign.getSegmentSet().createSegment()) != null) {
            this.initPctFree(segment);
            this.initPctUsed(segment);
            this.initInitrans(segment);
            this.initMaxtrans(segment);
            this.initStorage(segment);
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
            SegmentOracle equalSegment = storageDesign.getSegmentSet().findEqual(segment);
            cluster.setSegment(equalSegment);
        }
    }

    private void initPctFree(SegmentOraclev9i segment) {
        if (segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            String pctFreeStr = Token.getTokenAfter(this.statement, "PCTFREE").trim();
            try {
                int pctFree = Integer.parseInt(pctFreeStr);
                segment.setPCTFree(pctFree);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initPctFree : " + e.getMessage());
            }
        }
    }

    private void initPctUsed(SegmentOraclev9i segment) {
        if (Token.hasToken(this.statement, "PCTUSED") && segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
            String strValue = Token.getTokenAfter(this.statement, "PCTUSED").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setPCTUsed(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initPctUsed : " + e.getMessage());
            }
        }
    }

    private void initInitrans(SegmentOraclev9i segment) {
        if (Token.hasToken(this.statement, "INITRANS") && segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(this.statement, "INITRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setInitrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initInitrans : " + e.getMessage());
            }
        }
    }

    private void initMaxtrans(SegmentOraclev9i segment) {
        if (Token.hasToken(this.statement, "MAXTRANS") && segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            String strValue = Token.getTokenAfter(this.statement, "MAXTRANS").trim();
            try {
                int value = Integer.parseInt(strValue);
                segment.setMaxTrans(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MAXTRANS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initMaxtrans : " + e.getMessage());
            }
        }
    }

    private void initStorage(SegmentOraclev9i segment) {
        String line;
        if (Token.hasToken(this.statement, "STORAGE") && Token.getFirstToken(line = Token.getStringAfter(this.statement, "STORAGE")).equalsIgnoreCase("(")) {
            line = Token.getValBetweenBrackets(line, 1).trim();
            this.initInitial(line, segment);
            this.initNext(line, segment);
            this.initPCtIncrease(line, segment);
            this.initMinExtents(line, segment);
            this.initMaxExtents(line, segment);
            this.initFreeLists(line, segment);
            this.initFreeListGroups(line, segment);
            this.initSegBufferPool(line, segment);
        }
    }

    private void initInitial(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "INITIAL") && segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long value = Long.parseLong(str);
                segment.setSCInitialExtent(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong INITIAL format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initInitial : " + e.getMessage());
            }
        }
    }

    private void initNext(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "NEXT") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long value = Long.parseLong(str);
                segment.setSCNextExtent(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong NEXT format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initNext : " + e.getMessage());
            }
        }
    }

    private void initPCtIncrease(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "PCTINCREASE") && segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int value = Integer.parseInt(str);
                segment.setSCPctIncrease(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTINCREASE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initPCtIncrease : " + e.getMessage());
            }
        }
    }

    private void initMinExtents(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "MINEXTENTS") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int value = Integer.parseInt(str);
                segment.setSCMinExtents(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINEXTENTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initMinExtents : " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "MAXEXTENTS") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            segment.setSCMaxExtents(str);
        }
    }

    private void initFreeLists(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "FREELISTS") && segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "FREELISTS").trim());
            try {
                int value = Integer.parseInt(str);
                segment.setSCFreeLists(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong FREELISTS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initFreeLists : " + e.getMessage());
            }
        }
    }

    private void initFreeListGroups(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "GROUPS") && segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            String str = this.getNumberOnly(Token.getTokenAfter(line, "GROUPS").trim());
            try {
                int value = Integer.parseInt(str);
                segment.setSCFreelistGroups(value);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong GROUPS format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initFreeListGroups : " + e.getMessage());
            }
        }
    }

    private void initSegBufferPool(String line, SegmentOraclev9i segment) {
        if (Token.hasToken(line, "BUFFER_POOL") && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            String str = Token.getQuotedNameAfterToken(line, "BUFFER_POOL").trim();
            segment.setSCBufferPool(str);
        }
    }

    private void initSize(ClusterOraclev9i cluster) {
        if (Token.hasToken(this.statement, "SIZE")) {
            String nextToken;
            String sizeStr;
            String sizeClause = Token.getStringAfter(this.statement, "SIZE").toUpperCase();
            String sizeDigits = sizeStr = Token.getFirstToken(sizeClause);
            String measureUnit = "";
            if (sizeStr.endsWith("K") || sizeStr.endsWith("M")) {
                sizeDigits = sizeStr.substring(0, sizeStr.length() - 1);
                measureUnit = sizeStr.substring(sizeStr.length() - 1);
            }
            try {
                cluster.setSize(Integer.parseInt(sizeDigits));
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateClusterOracle.initSize : " + e.getMessage());
            }
            if ("".equalsIgnoreCase(measureUnit) && ((nextToken = Token.getTokenAfter(sizeClause, sizeStr)).equals("K") || nextToken.equals("M"))) {
                measureUnit = nextToken;
            }
            if (!"".equalsIgnoreCase(measureUnit)) {
                cluster.setMeasureUnit(measureUnit);
            }
        }
    }

    private void initTableSpace(ClusterOraclev9i cluster, StorageDesignOraclev9i storageDesign) {
        if (Token.hasToken(this.statement, "TABLESPACE")) {
            String tsName = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
            TableSpaceOraclev9i ts = (TableSpaceOraclev9i)storageDesign.getTableSpaceSet().getByName(tsName);
            if (ts != null) {
                cluster.setTableSpace(ts);
            }
        }
    }

    private void initIndex(ClusterOraclev9i cluster) {
        if (Token.hasToken(Token.getStringAfter(this.statement, Token.getTokenAfter(this.statement, "CLUSTER")), "INDEX")) {
            cluster.setIndexed("YES");
        } else {
            cluster.setIndexed("NO");
        }
    }

    private void initSingleTable(ClusterOraclev9i cluster) {
        if (Token.hasString(this.statement, "SINGLE TABLE")) {
            cluster.setSingleTable("YES");
        }
    }

    private void initHashKeys(ClusterOraclev9i cluster) {
        if (Token.hasToken(this.statement, "HASHKEYS")) {
            String str = Token.getTokenAfter(this.statement, "HASHKEYS").trim();
            try {
                int value = Integer.parseInt(str);
                cluster.setHashKeys(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateClusterOracle.initHashKeys : " + e.getMessage());
                this.importLog.addWarning("Wrong HASHKEYS format in statement " + this.statement);
            }
            if (Token.hasString(this.statement, "HASH IS")) {
                String hash = Token.getStringAfter(this.statement, "HASH IS");
                if (Token.hasToken(hash, "PARALLEL")) {
                    hash = Token.getStringBefore(hash, "PARALLEL");
                } else if (Token.hasToken(hash, "NOPARALLEL")) {
                    hash = Token.getStringBefore(hash, "NOPARALLEL");
                } else if (Token.hasToken(hash, "ROWDEPENDENCIES")) {
                    hash = Token.getStringBefore(hash, "ROWDEPENDENCIES");
                } else if (Token.hasToken(hash, "NOROWDEPENDENCIES")) {
                    hash = Token.getStringBefore(hash, "NOROWDEPENDENCIES");
                } else if (Token.hasToken(hash, "CACHE")) {
                    hash = Token.getStringBefore(hash, "CACHE");
                } else if (Token.hasToken(hash, "NOCACHE")) {
                    hash = Token.getStringBefore(hash, "NOCACHE");
                }
                cluster.setHashExpression(hash);
            }
        }
    }

    private void initParallel(ClusterOraclev9i cluster) {
        if (Token.hasToken(this.statement, "PARALLEL")) {
            cluster.setParallel("YES");
        }
    }

    private void initCache(ClusterOraclev9i cluster) {
        if (Token.hasToken(this.statement, "CACHE")) {
            cluster.setCache("YES");
        }
    }
}

