/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DeletedFile;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.RevisionRange;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLFromMapToSteramTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.layout.ViewId;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNMergeWindow
extends SVNHistoryWindow {
    public static final String WINDOW_ID = "SVNMergeWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "SVNMergeWindow");
    private static final String TEST_MERGE = Messages.getString("SVNMergeWindow.TestMerge");
    private static final Logger LOGGER = new Logger(SVNMergeWindow.class);
    private static final SVNMergeWindow INSTANCE = new SVNMergeWindow();
    protected SVNUrl mergeUrl;
    protected String mergeSvnDesignPath;

    protected SVNMergeWindow() {
        this.historyTable.setDefaultRenderer(Object.class, new ConflictedRevisionCellRenderer());
        this.changedObjectsTable.setDefaultRenderer(Object.class, new ConflictedFileCellRenderer());
        this.historyTable.setSelectionMode(2);
    }

    public static SVNMergeWindow getInstance() {
        return INSTANCE;
    }

    @Override
    protected void addToolbarActions() {
        this.toolbar.add((Action)new MergeReintegrateAction());
        this.toolbar.addSeparator();
    }

    @Override
    public String getTitleName() {
        return Messages.getString("SVNMergeWindow.MergeDesign");
    }

    @Override
    public Icon getTabIcon() {
        return (Icon)SVNMergeDesignCommand.getAction().getValue("SmallIcon");
    }

    @Override
    protected List<ISVNLogMessage> getLogMessages() {
        if (this.mergeUrl != null) {
            return this.getLogMessages(this.mergeUrl.toString(), null, null, true, false);
        }
        return null;
    }

    @Override
    protected void installPopupMenus() {
        this.installPopupMenu(this.historyTable, new MergeRevisionAction(), new TestMergeRevisionAction());
        this.installPopupMenu(this.changedObjectsTable, new AbstractAction[]{new VCSHistoryWindow.ComparePreviousAction(Messages.getString("SVNMergeWindow.ComparePrevious")), new VCSHistoryWindow.ComparePreviousAsTextAction(Messages.getString("SVNMergeWindow.ComparePreviousAsText")), new CompareAndMergeAction(), new CompareAndMergeAsTextAction(), new MergeAction(), new TestMergeAction(), new DeleteLocalFolderAction(), new DeleteLocalFilesAction(), new VCSHistoryWindow.CopyAction(), new MarkAsMergedAction(), SVNViewPropertiesCommand.getAction()});
    }

    @Override
    protected String readPropertyName(File file, SVNStorableObjectStatus storableObjectStatus, Long revision) {
        String propertyName = null;
        if (!storableObjectStatus.isAdded()) {
            propertyName = super.readPropertyName(file, storableObjectStatus, revision);
        }
        if (!StringUtilities.isNotEmpty(propertyName)) {
            try {
                propertyName = SVN_CLIENT_HELPER.doGetProperty(new SVNUrl(storableObjectStatus.getURL()), 5, revision);
            }
            catch (MalformedURLException e) {
                LOGGER.error(e);
            }
        }
        return propertyName;
    }

    protected void init(SVNUrl mergeUrl, Design design) {
        this.mergeUrl = mergeUrl;
        this.design = design;
        ISVNInfo svnInfo = SVN_CLIENT_HELPER.doInfo(new File(design.getDesignPath()));
        this.repositoryUrl = svnInfo.getRepository().toString();
        this.svnDesignPath = this.resolveSvnDesignPath(svnInfo);
        this.mergeSvnDesignPath = mergeUrl.toString().replaceAll(this.repositoryUrl, "");
        this.updateDesignLabel(design);
    }

    @Override
    protected Long findLastMergedRevision() {
        File designPath = new File(ApplicationView.getInstance().getCurrentDesign().getDesignPath());
        return SVN_CLIENT_HELPER.getLastMergedRevision(designPath, null, this.mergeUrl.toString());
    }

    @Override
    protected Long findLastCopiedRevision() {
        File designPath = new File(ApplicationView.getInstance().getCurrentDesign().getDesignPath());
        return SVN_CLIENT_HELPER.doGetLogMessages(designPath, (Long)null, (Long)null, true, false, 1).get(0).getRevision().getNumber();
    }

    @Override
    protected File resolveLocalFile(ISVNLogMessageChangePath changePath) {
        String path = changePath.getPath();
        String svnFile = path.indexOf(this.svnDesignPath) > -1 ? path.replace(this.svnDesignPath, "") : path.replace(this.mergeSvnDesignPath, "");
        return new File(this.design.getDesignPath() + svnFile);
    }

    @Override
    public void clear() {
        super.clear();
        this.mergeUrl = null;
    }

    @Override
    public void clearForDesign(Design design) {
        if (design.equals(this.design)) {
            this.clear();
        }
    }

    public void setMergeUrl(SVNUrl mergeUrl) {
        this.init(mergeUrl, ApplicationView.getInstance().getCurrentDesign());
        this.fileLabel.setText(mergeUrl.toString());
        this.refresh();
    }

    private List<VersioningTreeNode> collectNodesForMerging(boolean collectAll) {
        ArrayList<VersioningTreeNode> nodesForMerging = new ArrayList<VersioningTreeNode>();
        if (!collectAll && this.changedObjectsTable.getSelectedRowCount() > 0) {
            for (int i : this.changedObjectsTable.getSelectedRows()) {
                this.createAndAddNodeForMerging(i, nodesForMerging, collectAll);
            }
        } else {
            for (int i = 0; i < this.changedObjectsTable.getRowCount(); ++i) {
                this.createAndAddNodeForMerging(i, nodesForMerging, collectAll);
            }
        }
        return nodesForMerging;
    }

    private void createAndAddNodeForMerging(int changedObjectIndex, List<VersioningTreeNode> nodesForMerging, boolean collectAll) {
        SVNStorableObjectStatus storableObjectStatus = (SVNStorableObjectStatus)this.changedObjectsTableModel.getChangedObjects().get(changedObjectIndex);
        if (collectAll || !storableObjectStatus.isAdded()) {
            nodesForMerging.add(new VersioningTreeNode(storableObjectStatus));
        }
    }

    private void removeMergeConflicts(List<VersioningTreeNode> nodesForRefreshing, List<MergeConflict> mergeConflicts) {
        if (mergeConflicts.isEmpty() || nodesForRefreshing.isEmpty()) {
            return;
        }
        block0: for (MergeConflict mergeConflict : mergeConflicts) {
            StorableObjectStatus mergeConflictStorableObjectStatus = mergeConflict.getStorableObjectStatus();
            for (VersioningTreeNode node : nodesForRefreshing) {
                if (!node.getStorableObjectStatus().equals(mergeConflictStorableObjectStatus)) continue;
                nodesForRefreshing.remove(node);
                continue block0;
            }
        }
    }

    private boolean mergeEnabled() {
        for (int selectedRow : this.changedObjectsTable.getSelectedRows()) {
            SVNStorableObjectStatus selectedStorableObjectStatus = (SVNStorableObjectStatus)this.changedObjectsTableModel.getValueAt(selectedRow, 1);
            if (selectedStorableObjectStatus.getPathUrl().startsWith(this.mergeSvnDesignPath) && !selectedStorableObjectStatus.isAdded()) continue;
            return false;
        }
        return true;
    }

    private List<RevisionRange> collectSelectedRevisionRanges() {
        int selectionEndIndex;
        ArrayList<RevisionRange> revisionRanges = new ArrayList<RevisionRange>();
        ListSelectionModel selectionModel = this.historyTable.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int selectionStartIndex = selectionModel.getMaxSelectionIndex();
        do {
            selectionEndIndex = this.findSelectionEndIndex(selectionModel, selectionStartIndex);
            revisionRanges.add(this.createRevisionRange(selectionStartIndex, selectionEndIndex));
        } while ((selectionStartIndex = this.findSelectionStartIndex(selectionModel, selectionEndIndex)) >= minSelectionIndex);
        return revisionRanges;
    }

    private int findSelectionStartIndex(ListSelectionModel selectionModel, int fromIndex) {
        return this.findNextSelectedIndex(selectionModel, fromIndex, true);
    }

    private int findSelectionEndIndex(ListSelectionModel selectionModel, int fromIndex) {
        return this.findNextSelectedIndex(selectionModel, fromIndex, false) + 1;
    }

    private int findNextSelectedIndex(ListSelectionModel selectionModel, int fromIndex, boolean selected) {
        for (int i = fromIndex - 1; i >= 0; --i) {
            if (selectionModel.isSelectedIndex(i) != selected) continue;
            return i;
        }
        return -1;
    }

    private RevisionRange createRevisionRange(int selectionStartIndex, int selectionEndIndex) {
        Long startRevision = this.getRevisionNumber(selectionStartIndex);
        Long endRevision = this.getRevisionNumber(selectionEndIndex);
        Set<StorableObjectStatus> changedObjects = this.getChangedObjects(selectionEndIndex, selectionStartIndex);
        return new RevisionRange(startRevision, endRevision, changedObjects);
    }

    private Long getRevisionNumber(int row) {
        return ((ISVNLogMessage)this.historyTableModel.getRows().get(row)).getRevision().getNumber();
    }

    private Set<StorableObjectStatus> getChangedObjects(int rowFrom, int rowTo) {
        HashSet<StorableObjectStatus> changedObjects = new HashSet<StorableObjectStatus>();
        for (int i = rowFrom; i <= rowTo; ++i) {
            ISVNLogMessage logMessage = (ISVNLogMessage)this.historyTableModel.getRows().get(i);
            List storableObjectStatuses = (List)this.storableObjectStatusesMap.get(logMessage);
            changedObjects.addAll(storableObjectStatuses);
        }
        return changedObjects;
    }

    private boolean containsMergeConflicts() {
        List<RevisionRange> revisionRanges = this.collectSelectedRevisionRanges();
        ArrayList<StorableObjectStatus> allChangedObjects = new ArrayList<StorableObjectStatus>();
        for (RevisionRange revisionRange : revisionRanges) {
            Set<StorableObjectStatus> currentRevisionChangedObjects = revisionRange.getChangedObjects();
            if (!allChangedObjects.isEmpty()) {
                for (StorableObjectStatus changedObject : currentRevisionChangedObjects) {
                    if (!allChangedObjects.contains(changedObject)) continue;
                    return true;
                }
            }
            allChangedObjects.addAll(currentRevisionChangedObjects);
        }
        return false;
    }

    private boolean containsTreeConflicts() {
        List<RevisionRange> revisionRanges = this.collectSelectedRevisionRanges();
        for (RevisionRange revisionRange : revisionRanges) {
            if (!this.containsTreeConflicts(revisionRange)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTreeConflicts(RevisionRange revisionRange) {
        for (StorableObjectStatus changedObject : revisionRange.getChangedObjects()) {
            if (!this.containsTreeConflict(changedObject)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTreeConflict(StorableObjectStatus storableObjectStatus) {
        Long revision = storableObjectStatus.getRevision();
        String copyPath = storableObjectStatus.getCopyPath();
        return revision != null && this.lastCopiedRevision != null && revision > this.lastCopiedRevision && storableObjectStatus.isAdded() && storableObjectStatus.getFilePath().exists() && SVN_CLIENT_HELPER.isVersioned(storableObjectStatus.getFilePath()) && storableObjectStatus.getPathUrl().startsWith(this.mergeSvnDesignPath) && (!StringUtilities.isNotEmpty(copyPath) || !copyPath.startsWith(this.svnDesignPath));
    }

    private boolean hasOutgoingChanges() {
        List<ISVNStatus> outgoingChanges = SVN_CLIENT_HELPER.doStatus(new File(this.design.getDesignPath()), false);
        for (ISVNStatus outgoingChange : outgoingChanges) {
            if (SVNStatusKind.NORMAL.equals((Object)outgoingChange.getTextStatus()) || SVNStatusKind.UNVERSIONED.equals((Object)outgoingChange.getTextStatus()) || SVNStatusKind.NONE.equals((Object)outgoingChange.getTextStatus())) continue;
            return true;
        }
        return false;
    }

    private class ConflictedRevisionCellRenderer
    extends DefaultTableCellRenderer {
        private ConflictedRevisionCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                if (SVNMergeWindow.this.containsTreeConflicts(SVNMergeWindow.this.createRevisionRange(row, row))) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
            return tableCellRendererComponent;
        }
    }

    private class ConflictedFileCellRenderer
    extends DefaultTableCellRenderer {
        private ConflictedFileCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                if (SVNMergeWindow.this.containsTreeConflict((StorableObjectStatus)SVNMergeWindow.this.changedObjectsTableModel.getValueAt(row, 1))) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(Color.BLACK);
                }
            }
            return tableCellRendererComponent;
        }
    }

    private class MergeReintegrateAction
    extends AbstractAction {
        protected MergeReintegrateAction() {
            super(Messages.getString("SVNMergeWindow.MergeReintegrate"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (SVNMergeWindow.this.hasOutgoingChanges()) {
                MessageDialogs.showWarningMessage(Messages.getString("SVNMergeWindow.OutgoingChangesFound"));
            } else {
                int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.MergeReintegrateQuestion"), Messages.getString("SVNMergeWindow.MergeReintegrate"), 0);
                if (choice == 0) {
                    List<MergeConflict> allMergeConflicts = new ArrayList<MergeConflict>();
                    SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
                    try {
                        boolean res_ok = SVN_CLIENT_HELPER.doMergeReintegrate(SVNMergeWindow.this.mergeUrl, new File(SVNMergeWindow.this.design.getDesignPath()), allMergeConflicts);
                        if (res_ok) {
                            List<VersioningTreeNode> nodesForRefreshing = SVN_CLIENT_HELPER.getLastMergedObjects();
                            allMergeConflicts = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, allMergeConflicts, nodesForRefreshing, false);
                            VersioningTreeNode.refresh(nodesForRefreshing, false, true);
                        }
                    }
                    finally {
                        SVN_CLIENT_HELPER.setCurrentDesign(null);
                    }
                }
            }
        }
    }

    private class MergeRevisionAction
    extends VCSHistoryWindow.UpdateableAction {
        protected boolean dryRun;

        protected MergeRevisionAction() {
            this(Messages.getString("SVNMergeWindow.Merge"));
        }

        protected MergeRevisionAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            if (SVNMergeWindow.this.containsTreeConflicts()) {
                this.putValue("Name", Messages.getString("SVNMergeWindow.MergeConflict"));
            } else {
                this.putValue("Name", Messages.getString("SVNMergeWindow.Merge"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<RevisionRange> revisionRanges = SVNMergeWindow.this.collectSelectedRevisionRanges();
            if (!revisionRanges.isEmpty()) {
                if (SVNMergeWindow.this.hasOutgoingChanges()) {
                    MessageDialogs.showWarningMessage(Messages.getString("SVNMergeWindow.OutgoingChangesFound"));
                } else {
                    this.merge(revisionRanges);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void merge(List<RevisionRange> revisionRanges) {
            SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
            try {
                List<VersioningTreeNode> nodesForMerging = SVNMergeWindow.this.collectNodesForMerging(true);
                List<MergeConflict> mergeConflicts = SVN_CLIENT_HELPER.doMerge(SVNMergeWindow.this.mergeUrl, new File(SVNMergeWindow.this.design.getDesignPath()), revisionRanges, false, this.dryRun);
                if (!this.dryRun) {
                    SVNMergeWindow.this.lastMergedRevision = SVNMergeWindow.this.findLastMergedRevision();
                    List<MergeConflict> list = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, mergeConflicts, nodesForMerging, false);
                }
            }
            finally {
                SVN_CLIENT_HELPER.setCurrentDesign(null);
            }
        }
    }

    private class TestMergeRevisionAction
    extends MergeRevisionAction {
        private TestMergeRevisionAction() {
            super(TEST_MERGE);
            this.dryRun = true;
        }

        @Override
        public void update() {
        }
    }

    private class CompareAndMergeAction
    extends VCSHistoryWindow.ComparePreviousAction {
        protected File localFile;

        protected CompareAndMergeAction() {
            super(Messages.getString("SVNMergeWindow.CompareAndMerge"));
        }

        @Override
        public void update() {
            super.update();
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        @Override
        protected void init() {
            super.init();
            this.localFile = new File(this.url.replace(SVNMergeWindow.this.repositoryUrl, "").replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.design.getDesignPath()));
        }

        @Override
        protected InputStream getRightText() {
            return SVNMergeWindow.this.getRevision(this.url.replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.svnDesignPath), null);
        }

        @Override
        protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle) {
            XMLMetadataComparator comparator;
            Map mergedMap;
            StorageDesign storageDesign = null;
            StorableObjectStatus selectedStorableObjectStatus = SVNMergeWindow.this.getSelectedStorableObjectStatus();
            if (selectedStorableObjectStatus != null) {
                storageDesign = SVNMergeWindow.this.getVCSClientHelper().findStorageDesign(SVNMergeWindow.this.design, selectedStorableObjectStatus.getStorableObjectID());
            }
            if ((mergedMap = (comparator = new XMLMetadataComparator(SVNMergeWindow.this.design, storageDesign, leftText, leftTextTitle, rightText, rightTextTitle, true)).showModal()) != null && selectedStorableObjectStatus != null) {
                StorableObject storableObject = selectedStorableObjectStatus.getStorableObject();
                XMLFromMapToSteramTransformer.transformMapToXMLFileStram(mergedMap, this.localFile.getPath(), false, null, false);
                if (storableObject != null) {
                    DataModelerAddin.getVCSClientHelper().reloadStorableObject(storableObject, this.localFile, selectedStorableObjectStatus.getDesignPart());
                }
                try {
                    SVN_CLIENT_HELPER.doMerge(new SVNUrl(selectedStorableObjectStatus.getURL()), selectedStorableObjectStatus.getFilePath(), SVNMergeWindow.this.collectSelectedRevisionRanges(), true, false);
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e);
                }
            }
        }
    }

    private class CompareAndMergeAsTextAction
    extends VCSHistoryWindow.ComparePreviousAsTextAction {
        protected File localFile;

        public CompareAndMergeAsTextAction() {
            super(Messages.getString("SVNMergeWindow.CompareAndMergeAsText"));
        }

        @Override
        public void update() {
            super.update();
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        @Override
        protected void init() {
            super.init();
            this.localFile = new File(this.url.replace(SVNMergeWindow.this.repositoryUrl, "").replace(SVNMergeWindow.this.mergeSvnDesignPath, SVNMergeWindow.this.design.getDesignPath()));
        }

        @Override
        protected InputStream getRightText() {
            return SVNMergeWindow.this.getRevision(this.localFile, null);
        }

        @Override
        protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle) {
            final StorableObjectStatus selectedStorableObjectStatus = SVNMergeWindow.this.getSelectedStorableObjectStatus();
            VCSTextCompareFrame textCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), this.localFile, leftText, leftTextTitle, rightText, rightTextTitle, true, false, selectedStorableObjectStatus){

                @Override
                public void afterSave() {
                    super.afterSave();
                    try {
                        SVN_CLIENT_HELPER.doMerge(new SVNUrl(selectedStorableObjectStatus.getURL()), selectedStorableObjectStatus.getFilePath(), SVNMergeWindow.this.collectSelectedRevisionRanges(), true, false);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error(e);
                    }
                }
            };
            textCompareFrame.showModal();
        }
    }

    private class MergeAction
    extends MergeRevisionAction {
        protected MergeAction() {
        }

        protected MergeAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            this.setEnabled(SVNMergeWindow.this.mergeEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void merge(List<RevisionRange> revisionRanges) {
            List<MergeConflict> allMergeConflicts = new ArrayList<MergeConflict>();
            List<VersioningTreeNode> nodesForMerging = SVNMergeWindow.this.collectNodesForMerging(false);
            ArrayList<VersioningTreeNode> reallyMerged = new ArrayList<VersioningTreeNode>();
            SVN_CLIENT_HELPER.setCurrentDesign(SVNMergeWindow.this.design);
            try {
                for (VersioningTreeNode versioningTreeNode : nodesForMerging) {
                    try {
                        SVNStorableObjectStatus storableObjectStatus = (SVNStorableObjectStatus)versioningTreeNode.getStorableObjectStatus();
                        SVNUrl urlFrom = new SVNUrl(storableObjectStatus.getURL());
                        List<MergeConflict> mergeConflicts = SVN_CLIENT_HELPER.doMerge(urlFrom, storableObjectStatus.getFilePath(), revisionRanges, false, this.dryRun);
                        reallyMerged.addAll(SVN_CLIENT_HELPER.getLastMergedObjects());
                        allMergeConflicts.addAll(mergeConflicts);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error(e);
                    }
                }
                if (!this.dryRun) {
                    allMergeConflicts = MergeConflictsDialog.getInstance().processConflicts(SVNMergeWindow.this.design, allMergeConflicts, nodesForMerging, false);
                    VersioningTreeNode.refresh(reallyMerged, false, true);
                }
            }
            finally {
                SVN_CLIENT_HELPER.setCurrentDesign(null);
            }
        }
    }

    private class TestMergeAction
    extends MergeAction {
        protected TestMergeAction() {
            super(TEST_MERGE);
            this.dryRun = true;
        }

        @Override
        public void update() {
        }
    }

    private class DeleteLocalFolderAction
    extends VCSHistoryWindow.UpdateableAction {
        protected DeleteLocalFolderAction(String name) {
            super(name);
        }

        protected DeleteLocalFolderAction() {
            super(Messages.getString("SVNMergeWindow.DeleteLocalFolder"));
        }

        @Override
        public void update() {
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<StorableObjectStatus> selectedStorableObjects = SVNMergeWindow.this.getSelectedStorableObjectsStatuses();
            ArrayList<File> filePathsList = new ArrayList<File>();
            ArrayList deletedFiles = new ArrayList();
            for (StorableObjectStatus selectedStorableObject : selectedStorableObjects) {
                this.collectFiles(selectedStorableObject, filePathsList);
            }
            if (filePathsList.isEmpty()) {
                return;
            }
            File[] filePaths = filePathsList.toArray(new File[filePathsList.size()]);
            SVN_CLIENT_HELPER.doRemoveLocalFolder(filePaths);
            this.refresh(filePaths);
            if (this.commit()) {
                SVN_CLIENT_HELPER.doCommit(filePaths, Messages.getString("SVNMergeWindow.DeleteLocalCommitMessage"), false, false);
                SVN_CLIENT_HELPER.doUpdate(new File[]{new File(SVNMergeWindow.this.design.getDesignPath())}, true);
            }
        }

        protected void refresh(File[] filePaths) {
        }

        protected boolean commit() {
            return true;
        }

        protected void collectFiles(StorableObjectStatus storableObjectStatus, List<File> filePaths) {
            filePaths.add(storableObjectStatus.getFilePath());
        }
    }

    private class DeleteLocalFilesAction
    extends DeleteLocalFolderAction {
        private DeleteLocalFilesAction() {
            super(Messages.getString("SVNMergeWindow.DeleteLocalFiles"));
        }

        @Override
        protected void refresh(File[] filePaths) {
            ArrayList<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();
            for (File filePath : filePaths) {
                SVNStorableObjectStatus storableObjectStatus = new SVNStorableObjectStatus(SVNMergeWindow.this.design, filePath, "D", null, null);
                nodesForRefreshing.add(new VersioningTreeNode(storableObjectStatus));
            }
            VersioningTreeNode.refresh(nodesForRefreshing, false, true);
        }

        @Override
        protected boolean commit() {
            int commitOption = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("SVNMergeWindow.DeleteLocalFilesCommitDialogText"), Messages.getString("SVNMergeWindow.DeleteLocalCommitDialogTitle"), 0, 3);
            return commitOption == 0;
        }

        @Override
        protected void collectFiles(StorableObjectStatus storableObjectStatus, List<File> filePaths) {
            List<DeletedFile> deletedFiles = SVNMergeWindow.this.design.getDesignLevelSettings().getDeletedFiles();
            File[] files = null;
            files = storableObjectStatus.getFilePath().isFile() ? new File[]{storableObjectStatus.getFilePath()} : storableObjectStatus.getFilePath().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            });
            for (File file : files) {
                ISVNInfo svnInfo = SVN_CLIENT_HELPER.doInfo(file);
                String url = svnInfo.getUrlString();
                Long currentRevision = svnInfo.getRevision().getNumber();
                filePaths.add(file);
                deletedFiles.add(new DeletedFile(file, url, currentRevision));
            }
            SVNMergeWindow.this.design.saveDesignLevelSettings();
        }
    }

    private class MarkAsMergedAction
    extends VCSHistoryWindow.UpdateableAction {
        private MarkAsMergedAction() {
            super("Mark local as Merged");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<StorableObjectStatus> selectedStorableObjectsStatuses = SVNMergeWindow.this.getSelectedStorableObjectsStatuses();
            for (StorableObjectStatus storableObjectStatus : selectedStorableObjectsStatuses) {
                Long rev = this.getRevisionToCopy(storableObjectStatus);
                try {
                    ArrayList<RevisionRange> revisionRanges = new ArrayList<RevisionRange>();
                    HashSet<StorableObjectStatus> changedObjects = new HashSet<StorableObjectStatus>();
                    changedObjects.add(storableObjectStatus);
                    RevisionRange revisionRange = new RevisionRange(rev, rev, changedObjects);
                    revisionRanges.add(revisionRange);
                    SVNMergeWindow.this.getVCSClientHelper().doMerge(new SVNUrl(storableObjectStatus.getURL()), storableObjectStatus.getFilePath(), revisionRanges, true, false);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }

        protected Long getRevisionToCopy(StorableObjectStatus selectedStorableObject) {
            return selectedStorableObject.getRevision();
        }

        @Override
        public void update() {
        }
    }
}

