/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNIncomingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.SVNStorableObjectStatus;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.SVNDMPropertiesManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.TimeLog;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.vop.VersionOperationTreePanel;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNStatus;

public class ChangeListTreePanel
extends VersionOperationTreePanel
implements IChangeListPanel {
    private static final String OPENING_BRACKET_DETAILS = " [";
    private static final String CLOSING_BRACKET_DETAILS = "]";
    private static final String DETAILS_SEPARATOR = "; ";
    private static final String OPENING_BRACKET_CONFLICTS = " (";
    private static final String CLOSING_BRACKET_CONFLICTS = ")";
    private static final String PROPERTIES_MODIFIED_TEXT = "properties modified ";
    public static final String SVN_NORMAL_STATUS = " ";
    public static final String SVN_ADDED_STATUS = "A";
    protected DefaultTreeModel treeModel;
    protected final JTree tree;
    protected List<StorableObjectStatus> statuses;
    protected int conflicts;
    protected DataModelerChangeList changeList;
    private GUIConfiguration conf = GUIConfiguration.getInstance();
    private VersioningTreeNode rootNode = null;
    private VersioningTreeNode designNode = null;
    Map<String, VersioningTreeNode> allNodesMap;
    Map mapByID;
    List<File> conflicted = new ArrayList<File>();

    public ChangeListTreePanel(DataModelerChangeList changeList) {
        this.changeList = changeList;
        this.tree = (JTree)this.getInternalComponent();
        this.init();
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                VersioningTreeNode versioningTreeNode = (VersioningTreeNode)value;
                StorableObjectStatus storableObjectStatus = versioningTreeNode.getStorableObjectStatus();
                Icon icon = versioningTreeNode.getIcon();
                SVNStatus status = null;
                if (storableObjectStatus instanceof SVNStorableObjectStatus) {
                    status = ((SVNStorableObjectStatus)storableObjectStatus).getSVNStatus();
                }
                if (storableObjectStatus != null) {
                    File svnStatusFile = storableObjectStatus.getFilePath();
                    if (icon == null) {
                        if (svnStatusFile.isDirectory() || !svnStatusFile.exists() && status != null && status.getRemoteKind() == SVNNodeKind.DIR) {
                            TreeNode node = null;
                            try {
                                node = versioningTreeNode.getFirstChild();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (node == null) {
                                icon = UIManager.getIcon("FileView.directoryIcon");
                            }
                        } else if (svnStatusFile.getAbsolutePath().endsWith(".xml")) {
                            icon = GUIConfiguration.getInstance().getIcon("XML_FILE_ICON");
                        }
                    }
                }
                if (icon == null) {
                    icon = this.getIcon();
                }
                if (icon != null) {
                    if (storableObjectStatus != null) {
                        this.setIcon(ChangeListTreePanel.this.getIconForStatus(storableObjectStatus.getTextStatus(), icon));
                    } else {
                        this.setIcon(icon);
                    }
                }
                if (versioningTreeNode.isConflicted() || storableObjectStatus != null && storableObjectStatus.isInconflict()) {
                    this.setForeground(Color.RED);
                }
                if (storableObjectStatus != null) {
                    String designObjectName = storableObjectStatus.getStorableObjectName();
                    StringBuilder text = new StringBuilder(designObjectName != null ? designObjectName : versioningTreeNode.getUserObject().toString());
                    Long revision = storableObjectStatus.getRevision();
                    String propertyStatus = storableObjectStatus.getPropertyStatus();
                    StringBuilder details = new StringBuilder();
                    if (revision != null) {
                        details.append(String.valueOf(revision));
                    }
                    if ("M".equals(propertyStatus)) {
                        if (details.length() > 0) {
                            details.append(ChangeListTreePanel.DETAILS_SEPARATOR);
                        }
                        details.append(ChangeListTreePanel.PROPERTIES_MODIFIED_TEXT);
                    }
                    if (details.length() > 0) {
                        text.append(ChangeListTreePanel.OPENING_BRACKET_DETAILS).append(details.toString()).append(ChangeListTreePanel.CLOSING_BRACKET_DETAILS);
                    }
                    this.setText(text.toString());
                } else if (ChangeListTreePanel.this.conflicts > 0 && ChangeListTreePanel.this.treeModel.getRoot().equals(versioningTreeNode)) {
                    this.setForeground(Color.RED);
                    this.setText(versioningTreeNode.toString() + ChangeListTreePanel.OPENING_BRACKET_CONFLICTS + ChangeListTreePanel.this.conflicts + ChangeListTreePanel.CLOSING_BRACKET_CONFLICTS);
                }
                return this;
            }
        });
    }

    private Icon getIconForStatus(String status, Icon icon) {
        if (SVN_ADDED_STATUS.equalsIgnoreCase(status)) {
            return this.conf.getObjectAddedIcon(icon);
        }
        if ("D".equalsIgnoreCase(status)) {
            return this.conf.getObjectDeletedIcon(icon);
        }
        if ("M".equalsIgnoreCase(status)) {
            return this.conf.getObjectModifiedIcon(icon);
        }
        if ("MI".equalsIgnoreCase(status) || "!".equalsIgnoreCase(status)) {
            return this.conf.getObjectMissingIcon(icon);
        }
        return icon;
    }

    public static boolean isFileAndDirModel(Class aClass) {
        return aClass != null && (RelationalDesign.class.isAssignableFrom(aClass) || MultidimensionalDesign.class.isAssignableFrom(aClass) || DataFlowDesign.class.isAssignableFrom(aClass) || TransformationTask.class.isAssignableFrom(aClass) || Design.class.isAssignableFrom(aClass) || TransformationPackage.class.isAssignableFrom(aClass));
    }

    public static String getModelDir(StorableObjectStatus stat) {
        Class oclass;
        if (stat != null && (oclass = stat.getObjectClass()) != null) {
            if (ChangeListTreePanel.isFileAndDirModel(oclass)) {
                String path = stat.getFilePath().getPath();
                int ind = path.lastIndexOf(".xml");
                if (ind == -1) {
                    ind = path.lastIndexOf(".dmd");
                }
                if (ind > 0) {
                    return path.substring(0, ind);
                }
            } else {
                return stat.getFilePath().getParent();
            }
        }
        return null;
    }

    public static boolean isParentPathExists(Map modelPats, File file) {
        String path = file.getPath();
        for (String dir : modelPats.keySet()) {
            if (!path.startsWith(dir)) continue;
            return true;
        }
        return false;
    }

    public static void removeNewModelsElements(List<StorableObjectStatus> statuses) {
        HashMap<String, StorableObjectStatus> models = new HashMap<String, StorableObjectStatus>();
        TimeLog.log("start  collectModels");
        ChangeListTreePanel.collectModels(statuses, models);
        TimeLog.log("end  collectModels");
        for (Map.Entry entry : models.entrySet()) {
            TimeLog.log("start  getModelElements");
            List<StorableObjectStatus> toadd = ChangeListTreePanel.getModelElements(statuses, (String)entry.getKey(), (StorableObjectStatus)entry.getValue());
            TimeLog.log("end  getModelElements");
            statuses.clear();
            statuses.addAll(toadd);
            TimeLog.log("end  removeAll");
        }
    }

    private static void collectModels(List<StorableObjectStatus> statuses, Map<String, StorableObjectStatus> models) {
        for (StorableObjectStatus stat : statuses) {
            String path;
            if (stat.getObjectClass() == null) continue;
            if (SVN_ADDED_STATUS.equals(stat.getTextStatus()) && Design.class.isAssignableFrom(stat.getObjectClass())) {
                if (stat.getFilePath().isDirectory()) continue;
                path = stat.getFilePath().getPath();
                int ind = path.lastIndexOf(".dmd");
                if (ind == -1) {
                    ind = path.lastIndexOf(".xml");
                }
                if (ind <= 0) continue;
                models.put(path.substring(0, ind), stat);
                return;
            }
            if (SVN_ADDED_STATUS.equals(stat.getTextStatus()) && DesignPart.class.isAssignableFrom(stat.getObjectClass())) {
                if (stat.getFilePath().isDirectory()) continue;
                path = ChangeListTreePanel.getModelDir(stat);
                if (ChangeListTreePanel.isParentPathExists(models, stat.getFilePath())) continue;
                models.put(path, stat);
                continue;
            }
            if (SVN_ADDED_STATUS.equals(stat.getTextStatus()) && StorageDesign.class.isAssignableFrom(stat.getObjectClass())) {
                if (stat.getFilePath().isDirectory()) continue;
                path = ChangeListTreePanel.getModelDir(stat);
                if (ChangeListTreePanel.isParentPathExists(models, stat.getFilePath())) continue;
                models.put(path, stat);
                continue;
            }
            if (!SVN_ADDED_STATUS.equals(stat.getTextStatus()) || !TransformationPackage.class.isAssignableFrom(stat.getObjectClass()) || stat.getFilePath().isDirectory()) continue;
            path = ChangeListTreePanel.getModelDir(stat);
            if (ChangeListTreePanel.isParentPathExists(models, stat.getFilePath())) continue;
            models.put(path, stat);
        }
    }

    private static List<StorableObjectStatus> getModelElements(List<StorableObjectStatus> statuses, String path, StorableObjectStatus model) {
        ArrayList<StorableObjectStatus> list = new ArrayList<StorableObjectStatus>();
        for (StorableObjectStatus stat : statuses) {
            if (stat.getFilePath().getPath().startsWith(path) && stat != model) continue;
            list.add(stat);
        }
        return list;
    }

    @Override
    public List<StorableObjectStatus> update() {
        return this.update(this.statuses);
    }

    @Override
    public List<StorableObjectStatus> update(List<StorableObjectStatus> statuses) {
        return this.constructTree(statuses);
    }

    protected List<StorableObjectStatus> constructTree(List<StorableObjectStatus> statuses) {
        Design design;
        int option;
        boolean addDesignNode = false;
        this.init();
        if (statuses != null && statuses.size() > 0) {
            TimeLog.log("start  sort statuses");
            Collections.sort(statuses, StorableObjectStatus.FILE_PATH_COMPARATOR);
            TimeLog.log("start  removeNewModelsElements statuses");
            if (!(this.getParent() instanceof SVNIncomingChangesChangeList)) {
                ChangeListTreePanel.removeNewModelsElements(statuses);
            }
            for (int i = statuses.size() - 1; i >= 0; --i) {
                String spath;
                StorableObjectStatus storableObjectStatus = statuses.get(i);
                String storableObjectName = storableObjectStatus.getStorableObjectName();
                File filePath = storableObjectStatus.getFilePath();
                if (storableObjectStatus.getTextStatus().equalsIgnoreCase(SVN_NORMAL_STATUS) || storableObjectStatus.getTextStatus().equalsIgnoreCase("?")) continue;
                File sfile = null;
                Design design2 = DataModelerChangeList.getSelectedDesign();
                if (design2 == null) {
                    return null;
                }
                String designStoragePath = null;
                if (design2 != null) {
                    designStoragePath = design2.getStoragePath();
                }
                if (!"".equals(spath = ApplicationView.getInstance().getSettings().getDefaultSystemTypesPath())) {
                    sfile = new File(spath);
                }
                String additionalFilesPath = design2.getDesignPath() + File.separator + design2.getName() + File.separator + "files";
                if (design2 != null && design2.getDesignPath().equals(filePath.getPath())) {
                    this.findOrCreateRootNode().setStorableObjectStatus(storableObjectStatus);
                    this.tree.setRootVisible(true);
                    continue;
                }
                if (SVNClientHelper.isSystemFile(filePath, sfile)) {
                    String nodeName = storableObjectStatus.getStorableObjectName();
                    VersioningTreeNode aNode = null;
                    if (designStoragePath != null && filePath.getPath().startsWith(designStoragePath)) {
                        addDesignNode = true;
                        this.findOrCreateDesignNode();
                        aNode = this.findOrCreateNode(storableObjectStatus, storableObjectStatus.getObjectClass(), storableObjectStatus.getPath(), nodeName, filePath, this.designNode);
                    } else {
                        aNode = this.findOrCreateNode(storableObjectStatus, storableObjectStatus.getObjectClass(), storableObjectStatus.getPath(), nodeName, filePath, this.findOrCreateRootNode());
                    }
                    aNode.setStorableObjectStatus(storableObjectStatus);
                    continue;
                }
                if (storableObjectStatus.getObjectClass() == null && storableObjectStatus.getStorableObjectName() == null && !storableObjectStatus.getStorableObjectName().startsWith("LastAddedObjects")) {
                    storableObjectStatus.setStorableObjectName(storableObjectStatus.getFilePath().toString().substring(additionalFilesPath.length() + 1));
                }
                this.findOrCreateDesignNode();
                if (this.addToDesignNode(storableObjectStatus)) {
                    addDesignNode = true;
                    continue;
                }
                statuses.remove(i);
            }
            if (addDesignNode) {
                this.findOrCreateRootNode().add(this.designNode);
            }
        }
        TimeLog.log("end building tree");
        this.treeModel.setRoot(this.rootNode);
        TimeLog.log("end setting tree");
        this.statuses = statuses;
        if (!this.conflicted.isEmpty() && (option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("MergeConflictsDialog.ConflictFoundMessage"), Messages.getString("MergeConflictsDialog.ConflictFoundTitle"), 0, 2)) == 0) {
            ArrayList<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();
            this.fixConflicts(this.conflicted, nodesForRefreshing);
            this.conflicted.clear();
        }
        if (this.getParent() instanceof SVNIncomingChangesChangeList && (design = DataModelerChangeList.getSelectedDesign()) != null) {
            SVNDMPropertiesManager.saveAllAddedObjectsProperties(design);
        }
        return statuses;
    }

    protected void fixConflicts(List<File> conflicted, List<VersioningTreeNode> nodesForRefreshing) {
        if (conflicted.size() > 0) {
            ArrayList<MergeConflict> updConflicts = new ArrayList<MergeConflict>();
            for (File file : conflicted) {
                ISVNStatus stat = SVNClientHelper.getInstance().getSingleStatusLocal(file);
                if (stat.getConflictWorking() != null) {
                    MergeConflict newMergeConflict = new MergeConflict(stat);
                    if (newMergeConflict != null) {
                        updConflicts.add(newMergeConflict);
                    }
                    for (MergeConflict mergeConflict : updConflicts) {
                        SVNClientHelper.copyOverConflicted(mergeConflict.getLocalFile(), mergeConflict.getLocalLabel());
                    }
                    continue;
                }
                SVNClientHelper.resolve(file, SVNConflictChoice.MERGED);
            }
            MergeConflictsDialog.getInstance().processConflicts(DataModelerChangeList.getSelectedDesign(), updConflicts, nodesForRefreshing, false);
        }
    }

    private VersioningTreeNode findOrCreateRootNode() {
        if (this.rootNode == null) {
            File designPath = new File(DataModelerChangeList.getSelectedDesign().getDesignPath());
            this.rootNode = new VersioningTreeNode(designPath.getName(), designPath);
        }
        return this.rootNode;
    }

    private VersioningTreeNode findOrCreateDesignNode() {
        if (this.designNode == null) {
            this.designNode = new VersioningTreeNode(DataModelerChangeList.getSelectedDesign().getName(), new File(DataModelerChangeList.getSelectedDesign().getStorageName()), Design.class);
        }
        return this.designNode;
    }

    private void init() {
        if (this.allNodesMap != null) {
            this.allNodesMap.forEach((key, value) -> {
                StorableObjectStatus storableObjectStatus = value.getStorableObjectStatus();
                if (storableObjectStatus != null) {
                    storableObjectStatus.clearDesign();
                }
            });
        }
        this.allNodesMap = new HashMap<String, VersioningTreeNode>();
        this.mapByID = new HashMap();
        this.rootNode = null;
        this.designNode = null;
        this.conflicts = 0;
        this.treeModel = new DefaultTreeModel(null);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(false);
    }

    private boolean addToDesignNode(StorableObjectStatus storableObjectStatus) {
        VersioningTreeNode aNode;
        Class objectClass = storableObjectStatus.getObjectClass();
        Design design = DataModelerChangeList.getSelectedDesign();
        String storableObjectFilePathString = storableObjectStatus.getFilePath().toString();
        String additionalFilesPath = design.getDesignPath() + File.separator + design.getName() + File.separator + "files";
        if (objectClass == null && storableObjectStatus.getFilePath() == null) {
            return false;
        }
        if (objectClass != null && Design.class.isAssignableFrom(objectClass)) {
            this.designNode.setStorableObjectStatus(storableObjectStatus);
            return true;
        }
        String nodeName = null;
        nodeName = storableObjectStatus instanceof SVNStorableObjectStatus ? ((SVNStorableObjectStatus)storableObjectStatus).getStorableObjectName() : storableObjectStatus.getStorableObjectName();
        if ((nodeName == null || storableObjectFilePathString.length() > additionalFilesPath.length() && storableObjectFilePathString.startsWith(additionalFilesPath)) && storableObjectFilePathString.length() > additionalFilesPath.length() && storableObjectFilePathString.startsWith(additionalFilesPath)) {
            nodeName = storableObjectFilePathString.substring(additionalFilesPath.length() + 1);
            String relativeFilePath = nodeName;
            nodeName = relativeFilePath.lastIndexOf(File.separator) > 0 ? relativeFilePath.substring(relativeFilePath.lastIndexOf(File.separator) + 1) : relativeFilePath;
            storableObjectStatus.setStorableObjectName(nodeName);
        }
        StringBuffer phys = new StringBuffer(File.separator + "phys" + File.separator);
        if (nodeName == null || nodeName != null && storableObjectFilePathString.contains(phys) && storableObjectStatus.getTextStatus().equalsIgnoreCase(SVN_ADDED_STATUS)) {
            nodeName = storableObjectStatus.getFilePath().getName();
            storableObjectStatus.setStorableObjectName(nodeName);
            if (this.getParent() instanceof SVNIncomingChangesChangeList) {
                SVNIncomingChangesChangeList svnIncomingChangesChangeList = (SVNIncomingChangesChangeList)((Object)this.getParent());
                svnIncomingChangesChangeList.addStorableObjectStatusToCheck(storableObjectStatus);
            }
        }
        if ((aNode = this.findOrCreateNode(storableObjectStatus, objectClass, storableObjectStatus.getPath(), nodeName, storableObjectStatus.getFilePath(), this.designNode)) != null) {
            aNode.setStorableObjectStatus(storableObjectStatus);
            if (storableObjectStatus.getTextStatus().equals("C")) {
                ++this.conflicts;
                this.conflicted.add(storableObjectStatus.getFilePath());
            }
        }
        return true;
    }

    private String convertPath(TreePathHelper[] path, String objectName) {
        String result = "";
        for (int i = 0; i < path.length; ++i) {
            if (i == 0) {
                result = result.concat(path[i].getPathName());
                continue;
            }
            result = result.concat("/");
            String pathName = path[i].getPathName();
            if (pathName == null) continue;
            result = result.concat(pathName);
        }
        if (objectName != null && objectName.length() > 0) {
            result = result.length() > 0 ? result.concat("/").concat(objectName) : result.concat(objectName);
        }
        return result;
    }

    VersioningTreeNode getParentNode(String parentName, String parentID) {
        String parid;
        VersioningTreeNode pnode;
        StorableObjectStatus status;
        VersioningTreeNode node;
        VersioningTreeNode result = null;
        if (parentID != null && (result = this.allNodesMap.get(parentName + parentID)) == null && (node = (VersioningTreeNode)this.mapByID.get(parentID)) != null && (status = node.getStorableObjectStatus()) != null && (pnode = this.getParentNode(parentName, parid = status.getStorableObjectParentID())) != null) {
            return pnode;
        }
        return result;
    }

    VersioningTreeNode getDirectParentNode(String parentName, String parentID) {
        VersioningTreeNode result = null;
        if (parentID != null && (result = this.allNodesMap.get(parentName + parentID)) == null) {
            VersioningTreeNode node = (VersioningTreeNode)this.mapByID.get(parentID);
            return node;
        }
        return result;
    }

    private VersioningTreeNode findOrCreateNode(StorableObjectStatus storableObjectStatus, Class aClass, TreePathHelper[] path, String aNodeName, File aNodePath, VersioningTreeNode root) {
        String objPath = this.convertPath(path, aNodeName);
        VersioningTreeNode node = null;
        String id = storableObjectStatus.getStorableObjectID();
        String parentID = storableObjectStatus.getStorableObjectParentID();
        Design design = DataModelerChangeList.getSelectedDesign();
        File svnStatusFile = storableObjectStatus.getFilePath();
        File designStoragePathFile = new File(design.getStoragePath());
        if (aClass != null && StorageDesign.class.isAssignableFrom(aClass)) {
            id = null;
        }
        if (id != null) {
            node = this.allNodesMap.get(objPath + id);
        }
        if (node == null) {
            node = this.allNodesMap.get(objPath);
        }
        if (node == null) {
            String parentName = "";
            if (path.length > 0) {
                VersioningTreeNode pfNode;
                VersioningTreeNode parentNode = null;
                for (int i = 0; i < path.length; ++i) {
                    VersioningTreeNode aNode;
                    String pathName = path[i].getPathName();
                    if (pathName != null) {
                        parentName = i == 0 ? parentName.concat(pathName) : parentName.concat("/").concat(pathName);
                    }
                    if ((aNode = this.allNodesMap.get(parentName)) == null && parentID != null) {
                        aNode = this.getParentNode(parentName, parentID);
                    }
                    if (aNode == null) {
                        aNode = new VersioningTreeNode(path[i].getPathName(), path[i].getFile(), path[i].getPathClass());
                        this.allNodesMap.put(parentName, aNode);
                        if (parentNode == null) {
                            root.add(aNode);
                        } else {
                            parentNode.add(aNode);
                        }
                        parentNode = aNode;
                        continue;
                    }
                    parentNode = aNode;
                }
                if (aClass == null && (pfNode = this.getDirectParentNode("", aNodePath.getParent())) != null) {
                    parentNode = pfNode;
                }
                if (parentNode != null) {
                    node = new VersioningTreeNode(aNodeName, aNodePath, aClass);
                    if (id != null) {
                        this.allNodesMap.put(objPath + id, node);
                        this.mapByID.put(id, node);
                        if (aClass != null && RelationalDesign.class.isAssignableFrom(aClass)) {
                            this.allNodesMap.put(objPath + ModelIDObject.getShortID(id), node);
                            this.allNodesMap.put(objPath, node);
                        }
                    } else {
                        this.allNodesMap.put(objPath, node);
                    }
                    parentNode.add(node);
                }
            } else {
                parentName.concat("files");
                VersioningTreeNode aNode = null;
                String parentNodeKey = null;
                if (aNodePath.toString().startsWith(design.getStoragePath() + File.separator)) {
                    String nodeName = aNodePath.toString().substring((design.getStoragePath() + File.separator).length());
                    parentNodeKey = nodeName.lastIndexOf(File.separator) > 0 && nodeName.substring(0, nodeName.lastIndexOf(File.separator)).length() > 0 ? nodeName.substring(0, nodeName.lastIndexOf(File.separator)) : nodeName;
                    aNode = this.allNodesMap.get(parentNodeKey);
                }
                VersioningTreeNode parentNode = aNode;
                if (aNode == null && root.toString().equalsIgnoreCase(design.getName()) && aNodePath.getParentFile().getName().equalsIgnoreCase(design.getName())) {
                    aNode = new VersioningTreeNode(aNodePath.getName(), aNodePath);
                    root.add(aNode);
                    return aNode;
                }
                if (aNode == null && root.toString().equalsIgnoreCase(design.getName()) && aNodePath.toString().startsWith(design.getStoragePath() + File.separator + "files")) {
                    aNode = root.getFilePath().toString().lastIndexOf(".") > -1 ? (aNodeName.lastIndexOf(File.separator) > 0 ? new VersioningTreeNode("files" + File.separator + aNodeName.substring(0, aNodeName.lastIndexOf(File.separator) + 1), new File(root.getFilePath().toString().substring(0, root.getFilePath().toString().lastIndexOf(".")) + File.separator + "files"), TreePathHelper.class) : new VersioningTreeNode("files", new File(root.getFilePath().toString().substring(0, root.getFilePath().toString().lastIndexOf(".")) + File.separator + "files"), TreePathHelper.class)) : (aNodeName.lastIndexOf(File.separator) > 0 ? new VersioningTreeNode("files" + File.separator + aNodeName.substring(0, aNodeName.lastIndexOf(File.separator) + 1), new File(root.getFilePath().toString() + File.separator + "files"), TreePathHelper.class) : new VersioningTreeNode("files", new File(root.getFilePath().toString() + File.separator + "files"), TreePathHelper.class));
                    if (aNodeName.lastIndexOf(File.separator) > 0 && aNodeName.substring(0, aNodeName.lastIndexOf(File.separator)).length() > 0) {
                        this.allNodesMap.put("files" + File.separator + aNodeName.substring(0, aNodeName.lastIndexOf(File.separator)), aNode);
                    } else {
                        this.allNodesMap.put("files", aNode);
                    }
                    if (parentNode == null) {
                        root.add(aNode);
                    } else {
                        parentNode.add(aNode);
                    }
                    parentNode = aNode;
                } else if (aNode == null && !root.toString().equalsIgnoreCase(design.getName())) {
                    root = this.findOrCreateDesignNode();
                } else {
                    parentNode = aNode;
                }
                node = aNodeName.lastIndexOf(File.separator) > 0 ? new VersioningTreeNode(aNodeName.substring(aNodeName.lastIndexOf(File.separator) + 1), aNodePath, aClass) : new VersioningTreeNode(aNodeName, aNodePath, aClass);
                if (aNodePath.toString().startsWith(design.getStoragePath() + File.separator + "files")) {
                    this.allNodesMap.put(aNodePath.toString().substring((design.getStoragePath() + File.separator).length()), node);
                } else if (id != null) {
                    this.allNodesMap.put(objPath + id, node);
                    this.mapByID.put(id, node);
                } else {
                    this.allNodesMap.put(objPath, node);
                }
                if (!aNodePath.isDirectory()) {
                    String parentNodeLabel = null;
                    if (node.getLongLabel().indexOf(File.separator) > 0) {
                        parentNodeLabel = node.getLongLabel().substring(0, node.getLongLabel().indexOf(File.separator));
                        VersioningTreeNode subNode = this.allNodesMap.get(parentNodeLabel);
                        if (subNode == null) {
                            subNode = this.allNodesMap.get(parentNodeLabel + parentNodeLabel);
                        } else {
                            parentNode = subNode;
                        }
                    }
                }
                if (parentNode != null && svnStatusFile.getAbsolutePath().startsWith(designStoragePathFile.getAbsolutePath() + File.separator + "files")) {
                    parentNode.add(node);
                } else if (svnStatusFile.getAbsolutePath().startsWith(designStoragePathFile.getAbsolutePath() + File.separator + "rdbms")) {
                    VersioningTreeNode rdbmsNode = this.allNodesMap.get(root.getFilePath().toString().substring(0, root.getFilePath().toString().lastIndexOf(".")) + File.separator + "rdbms");
                    if (rdbmsNode == null) {
                        rdbmsNode = new VersioningTreeNode("rdbms", new File(root.getFilePath().toString().substring(0, root.getFilePath().toString().lastIndexOf(".")) + File.separator + "rdbms"), TreePathHelper.class);
                        this.allNodesMap.put(root.getFilePath().toString().substring(0, root.getFilePath().toString().lastIndexOf(".")) + File.separator + "rdbms", rdbmsNode);
                        rdbmsNode.add(node);
                        root.add(rdbmsNode);
                    } else {
                        rdbmsNode.add(node);
                    }
                } else if (!svnStatusFile.getAbsolutePath().startsWith(designStoragePathFile.getAbsolutePath() + File.separator + "rel")) {
                    root.add(node);
                }
            }
        }
        return node;
    }

    @Override
    public List<File> getSelectedFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        return this.getSelectedFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories, false);
    }

    public List<File> getSelectedFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories, boolean singleUpdate) {
        TreePath[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths == null) {
            return this.getAllFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories);
        }
        ArrayList<File> selectedFilePaths = new ArrayList<File>();
        for (TreePath selectionPath : selectionPaths) {
            VersioningTreeNode treeNode = (VersioningTreeNode)selectionPath.getLastPathComponent();
            if (alwaysRecurseDirectories && treeNode.getFilePath().isDirectory()) {
                recursively = true;
            }
            this.addSelectedFilePath(treeNode, selectedFilePaths, recursively, singleUpdate);
            this.addTreeNodesForRefreshing(treeNode, treeNodesForRefreshing, recursively);
        }
        return selectedFilePaths;
    }

    public List<File> getAllFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        return this.getAllFilePaths(treeNodesForRefreshing, recursively, alwaysRecurseDirectories, false);
    }

    public List<File> getAllFilePaths(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories, boolean singleUpdate) {
        ArrayList<File> allFilePaths = new ArrayList<File>();
        VersioningTreeNode root = (VersioningTreeNode)this.treeModel.getRoot();
        VersioningTreeNode node = null;
        if (this.tree.isRootVisible()) {
            node = root;
        } else if (root != null && root.getChildCount() > 0) {
            node = (VersioningTreeNode)root.getFirstChild();
        }
        if (node != null) {
            this.addSelectedFilePath(node, allFilePaths, recursively);
            this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
        }
        return allFilePaths;
    }

    public List<File> getAllFilePathsForCommit(List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively, boolean alwaysRecurseDirectories) {
        ArrayList<File> allFilePaths = new ArrayList<File>();
        VersioningTreeNode root = (VersioningTreeNode)this.treeModel.getRoot();
        VersioningTreeNode node = null;
        if (this.tree.isRootVisible()) {
            node = root;
            if (node != null) {
                this.addSelectedFilePath(node, allFilePaths, recursively);
                this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
            }
        } else if (root != null && root.getChildCount() > 0) {
            for (node = (VersioningTreeNode)root.getFirstChild(); node != null; node = (VersioningTreeNode)node.getNextSibling()) {
                this.addSelectedFilePath(node, allFilePaths, recursively);
                this.addTreeNodesForRefreshing(node, treeNodesForRefreshing, recursively);
            }
        }
        return allFilePaths;
    }

    protected void addSelectedFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths, boolean recursively) {
        this.addSelectedFilePath(versioningTreeNode, selectedFilePaths, recursively, false);
    }

    protected void addSelectedFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths, boolean recursively, boolean singleUpdate) {
        selectedFilePaths.add(versioningTreeNode.getFilePath());
        if (recursively) {
            if (!singleUpdate) {
                this.addDependantFilePath(versioningTreeNode, selectedFilePaths);
            }
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addSelectedFilePath((VersioningTreeNode)versioningTreeNode.getChildAt(i), selectedFilePaths, recursively);
            }
        }
    }

    private void addDependantFilePath(VersioningTreeNode versioningTreeNode, List<File> selectedFilePaths) {
        File dependantFilePath = versioningTreeNode.getDependantFilePath();
        if (dependantFilePath != null) {
            selectedFilePaths.add(dependantFilePath);
        }
    }

    protected void addTreeNodesForRefreshing(VersioningTreeNode versioningTreeNode, List<VersioningTreeNode> treeNodesForRefreshing, boolean recursively) {
        if (versioningTreeNode.getStorableObjectStatus() != null) {
            treeNodesForRefreshing.add(versioningTreeNode);
        }
        if (recursively) {
            for (int i = 0; i < versioningTreeNode.getChildCount(); ++i) {
                this.addTreeNodesForRefreshing((VersioningTreeNode)versioningTreeNode.getChildAt(i), treeNodesForRefreshing, recursively);
            }
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List<StorableObjectStatus> getStatuses() {
        return this.statuses;
    }

    @Override
    public VersioningTreeNode getSelectedNode() {
        return (VersioningTreeNode)this.tree.getLastSelectedPathComponent();
    }

    @Override
    public boolean hasSelection() {
        TreePath[] selection = this.tree.getSelectionPaths();
        return selection != null;
    }

    @Override
    public boolean hasSingleSelection() {
        TreePath[] selection = this.tree.getSelectionPaths();
        return selection != null && selection.length == 1;
    }

    @Override
    public Component getUnderlyingComponent() {
        return this.getInternalComponent();
    }
}

