/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalOraclePreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplateDialog;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplate;
import oracle.dbtools.crest.util.options.oracle.OracleTableTemplateDialog;
import oracle.ide.panels.TraversableContext;

final class ModelPhysicalOraclePP
extends AbstractPP {
    private static final long serialVersionUID = -3185294406341791172L;
    private static final String DIALOG_NAME = Messages.getString("OptionsDialog.NameElementProvider");
    private static final String NONE = Messages.getString("OptionsDialog.NONE");
    private static final String TRIGGER = Messages.getString("OptionsDialog.TRIGGER");
    private static final String DEFAULTClause = Messages.getString("OptionsDialog.DEFAULTClause");
    private static final String IDENTITYClause = Messages.getString("OptionsDialog.IDENTITYClause");
    private static final String[] defaultAutoIncDDLChoices = new String[]{NONE, TRIGGER, DEFAULTClause};
    private static final String[] defaultIdentityDDLChoices = new String[]{NONE, TRIGGER, DEFAULTClause, IDENTITYClause};
    private JTextField defaultOracleOwner;
    private JTextField defaultOracleTablespace;
    private JCheckBox chbOracleTableTemplate;
    private JCheckBox chbOracleIndexTemplate;
    private JButton bnOracleTableTemplate;
    private JButton bnOracleIndexTemplate;
    private JTextField defaultOracleTriggerName;
    private JTextField defaultOracleSequenceName;
    private JComboBox defaultOracleAutoIncDDL;
    private JComboBox defaultOracleIdentityDDL;
    private final OracleTableTemplate oracleTableTemplate = settings.getOracleTableTemplate();
    private final OracleIndexTemplate oracleIndexTemplate = settings.getOracleIndexTemplate();

    public ModelPhysicalOraclePP() {
        this.setHelpID("MODEL_PHYSICAL_ORACLE_PREFS_PANEL");
        JPanel pnDefaults = new JPanel(new GridBagLayout());
        pnDefaults.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Defaults")));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultUser"));
        this.addItem(pnDefaults, label, 0, 0, 1, 1, 17, 0, 100);
        this.defaultOracleOwner = new JTextField();
        this.addItem(pnDefaults, this.defaultOracleOwner, 1, 0, 2, 1, 17, 100, 100);
        label = new JLabel(Messages.getString("OptionsDialog.DefaultTablespace"));
        this.addItem(pnDefaults, label, 0, 1, 1, 1, 17, 0, 100);
        this.defaultOracleTablespace = new JTextField();
        this.addItem(pnDefaults, this.defaultOracleTablespace, 1, 1, 2, 1, 17, 100, 100);
        this.chbOracleTableTemplate = new JCheckBox(Messages.getString("OptionsDialog.UseTableTemplate"));
        this.addItem(pnDefaults, this.chbOracleTableTemplate, 0, 2, 1, 1, 17, 0, 100);
        this.bnOracleTableTemplate = new JButton(Messages.getString("OptionsDialog.ViewEdit"));
        this.addItem(pnDefaults, this.bnOracleTableTemplate, 1, 2, 1, 1, 17, 0, 100);
        this.chbOracleTableTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPhysicalOraclePP.this.bnOracleTableTemplate.setEnabled(ModelPhysicalOraclePP.this.chbOracleTableTemplate.isSelected());
            }
        });
        this.bnOracleTableTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OracleTableTemplateDialog(ModelPhysicalOraclePP.this.getApplicationView(), ModelPhysicalOraclePP.this.oracleTableTemplate).showDialog();
            }
        });
        this.chbOracleIndexTemplate = new JCheckBox(Messages.getString("OptionsDialog.UseIndexTemplate"));
        this.addItem(pnDefaults, this.chbOracleIndexTemplate, 0, 3, 1, 1, 17, 0, 100);
        this.bnOracleIndexTemplate = new JButton(Messages.getString("OptionsDialog.ViewEdit"));
        this.addItem(pnDefaults, this.bnOracleIndexTemplate, 1, 3, 1, 1, 17, 0, 100);
        this.chbOracleIndexTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPhysicalOraclePP.this.bnOracleIndexTemplate.setEnabled(ModelPhysicalOraclePP.this.chbOracleIndexTemplate.isSelected());
            }
        });
        this.bnOracleIndexTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OracleIndexTemplateDialog(ModelPhysicalOraclePP.this.getApplicationView(), ModelPhysicalOraclePP.this.oracleIndexTemplate).showDialog();
            }
        });
        JPanel pnAutoIncrementColumnTemplates = new JPanel(new GridBagLayout());
        pnAutoIncrementColumnTemplates.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AutoIncrementColumnTemplates")));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.TriggerName")), 0, 0, 1, 1, 17, 0, 100);
        this.defaultOracleTriggerName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultOracleTriggerName, 1, 0, 1, 1, 17, 100, 100);
        JButton btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 0, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultOracleTriggerName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.SequenceName")), 0, 1, 1, 1, 17, 0, 100);
        this.defaultOracleSequenceName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultOracleSequenceName, 1, 1, 1, 1, 17, 100, 100);
        btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 1, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultOracleSequenceName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultAutoIncrementDDL")), 0, 2, 1, 1, 17, 0, 100);
        this.defaultOracleAutoIncDDL = new JComboBox<String>(defaultAutoIncDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultOracleAutoIncDDL, 1, 2, 1, 1, 17, 100, 100);
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultIdentityDDL")), 0, 3, 1, 1, 17, 0, 100);
        this.defaultOracleIdentityDDL = new JComboBox<String>(defaultIdentityDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultOracleIdentityDDL, 1, 3, 1, 1, 17, 100, 100);
        this.add(pnDefaults, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnAutoIncrementColumnTemplates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public void onEntry(TraversableContext tc) {
        this.defaultOracleOwner.setText(settings.getDefaultOracleUser());
        this.defaultOracleTablespace.setText(settings.getDefaultOracleTablespace());
        this.chbOracleTableTemplate.setSelected(settings.useOracleTableTemplate());
        this.chbOracleIndexTemplate.setSelected(settings.useOracleIndexTemplate());
        this.bnOracleTableTemplate.setEnabled(this.chbOracleTableTemplate.isSelected());
        this.bnOracleIndexTemplate.setEnabled(this.chbOracleIndexTemplate.isSelected());
        this.defaultOracleTriggerName.setText(settings.getDefaultOracleTriggerName());
        this.defaultOracleSequenceName.setText(settings.getDefaultOracleSequenceName());
        this.defaultOracleAutoIncDDL.setSelectedItem(this.translate(settings.getDefaultOracleAutoIncDDL(), Settings.AUTOINCREMENT_DDL, defaultAutoIncDDLChoices));
        this.defaultOracleIdentityDDL.setSelectedItem(this.translate(settings.getDefaultOracleIdentityDDL(), Settings.IDENTITY_DDL, defaultIdentityDDLChoices));
    }

    public void onExit(TraversableContext tc) {
        settings.setDefaultOracleUser(this.defaultOracleOwner.getText());
        settings.setDefaultOracleTablespace(this.defaultOracleTablespace.getText());
        boolean useOracleTT = this.chbOracleTableTemplate.isSelected();
        boolean useOracleIT = this.chbOracleIndexTemplate.isSelected();
        settings.setUseOracleTableTemplate(useOracleTT);
        settings.setUseOracleIndexTemplate(useOracleIT);
        if (useOracleTT) {
            this.oracleTableTemplate.copyTo(settings.getOracleTableTemplate());
        }
        if (useOracleIT) {
            this.oracleIndexTemplate.copyTo(settings.getOracleIndexTemplate());
        }
        settings.setDefaultOracleTriggerName(this.defaultOracleTriggerName.getText());
        settings.setDefaultOracleSequenceName(this.defaultOracleSequenceName.getText());
        settings.setDefaultOracleAutoIncDDL(this.translate((String)this.defaultOracleAutoIncDDL.getSelectedItem(), defaultAutoIncDDLChoices, Settings.AUTOINCREMENT_DDL));
        settings.setDefaultOracleIdentityDDL(this.translate((String)this.defaultOracleIdentityDDL.getSelectedItem(), defaultIdentityDDLChoices, Settings.IDENTITY_DDL));
        ModelPhysicalOraclePreferences preferences = this.getModelPhysicalOraclePreferences(tc);
        preferences.setDefaultOracleUser(this.defaultOracleOwner.getText());
        preferences.setDefaultOracleTablespace(this.defaultOracleTablespace.getText());
        preferences.setUseOracleTableTemplate(useOracleTT);
        preferences.setUseOracleIndexTemplate(useOracleIT);
        preferences.setDefaultOracleTriggerName(this.defaultOracleTriggerName.getText());
        preferences.setDefaultOracleSequenceName(this.defaultOracleSequenceName.getText());
        preferences.setDefaultOracleAutoIncDDL(settings.getDefaultOracleAutoIncDDL());
        preferences.setDefaultOracleIdentityDDL(settings.getDefaultOracleIdentityDDL());
        preferences.setTableTemplate(this.oracleTableTemplate);
        preferences.setIndexTemplate(this.oracleIndexTemplate);
    }

    @Override
    protected String getDialogName() {
        return DIALOG_NAME;
    }

    private ModelPhysicalOraclePreferences getModelPhysicalOraclePreferences(TraversableContext tc) {
        return ModelPhysicalOraclePreferences.getInstance(tc.getPropertyStorage());
    }

    private class AddVariableActionListener
    implements ActionListener {
        private JTextField textField;

        private AddVariableActionListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[][] tablespaceName = new String[][]{{"{table}", Messages.getString("ModelPhysicalOraclePP.TableName")}, {"{table abbr}", Messages.getString("ModelPhysicalOraclePP.TableAbbreviation")}, {"{column}", Messages.getString("ModelPhysicalOraclePP.ColumnName")}, {"{column abbr}", Messages.getString("ModelPhysicalOraclePP.ColumnAbbreviation")}};
            ModelPhysicalOraclePP.this.createDialog(tablespaceName, this.textField);
        }
    }
}

